/********************************************************************
      FUNCTION: This procedure checks fields of the supplied
                ATTACH_HEADER for validity. (PS is responsible for
                checking the reminding fields.)

      INPUT:    ATTACH_HEADER

      OUTPUT:   X'00000000', if here is no error; or sense data will be return by
                ATTACH_LENGTH_CHECK; or data will be return by
                ATTACH_SECURITY_CHECK;
                or one of the following sense data will be return:

                   X'080F6051'    Security Not Valid
                   X'084B6031'    TP Not Available--Retry Allowed
                   X'084C0000'    TP Not Available--No Retry
                   X'1008600B'    Unrecognized FMH Command
                   X'10086021'    TP Name Not Recognized
                   X'10086040'    Invalid Attach Parameter
                   X'10086041'    Sync  Level Not Supported


  CopyRight 1995. Nicholas Poljakov all rights reserved.

***********************************************************************/

#include <state1.h>
#include <fmh5.h>
#include <string.h>
#include <memory.h>

unsigned long attltck(void *);

unsigned long attacheck(p)
char *p;
{
 unsigned long rc;
 struct FMH5 *a_ptr;
 unsigned char mask[2];

#if OS_TYPE == 1
/*********  Trace facility **********/
unsigned int rtype;   /* type of record */
unsigned int pnum;    /* point number */
char pname[8];        /* name of module */
char *drec;       /* record for dump */
int  lenr;            /* record length */

rtype = INPROC;
strcpy(pname, "attchk");
pnum = 1;
drec = p;
lenr = 200;
gtf(rtype, pname, pnum, drec, lenr);
/***********************************/
#endif

   a_ptr = (struct FMH5 *)p;
   mask[0] = 2;
   mask[1] = 0xff;
   if (memcmp(a_ptr -> type, mask, 2) == 0) {
        rc = attltck(a_ptr);
   }
   else
        rc = 0x1008600b;

   return(rc);

 }
