#	Makefile for DOS & TCC

TC=		command /e:2048 /c ..\build\tc
TXBOOT=		command /e:2048 /c txboot
MAKEGEN=	command /e:2048 /c makegen

default:	libtx.lib txcgg.exe txcgboot.exe txcg386.exe txcg386e.exe \
		txcg86t.exe txcg86a.exe txcgc.exe txtrn.exe txopt.exe \
		txpp.exe

libtx.lib:	libtx.c lib86.s
	tcc -w-rvl -ms -Dmsdos -c libtx.c
	tasm /ml lib86.s
	-del libtx.lib
	tlib libtx.lib /c /e +libtx.obj +lib86.obj

txcgg.exe:	txcgg.t
	$(TC) -P txcgg

txcgboot.exe:	txcg_asm_frame cg86t.def
	copy txcg_asm_frame txcg_frame
	.\txcgg <cg86t.def >txcg86t.t
	del txcg_frame
	$(TC) -P txcg86t
	command /c if exist txcgboot.exe del txcgboot.exe
	ren txcg86t.exe txcgboot.exe

txcg386.exe:	cg386.def
	$(MAKEGEN) -asm 386

txcg386e.exe:	cg386e.def
	$(MAKEGEN) -asm 386e

txcg86t.exe:	cg86t.def
	$(MAKEGEN) -asm 86t

txcg86a.exe:	cg86a.def
	$(MAKEGEN) -asm 86a

txcgc.exe:	cgc.def
	$(MAKEGEN) -hll c

txtrn.exe:	../compiler/txtrn.t
	copy ..\compiler\txtrn.t .
	$(TXBOOT) txtrn
	del txtrn.t

txopt.exe:	../compiler/txopt.t
	copy ..\compiler\txopt.t .
	$(TXBOOT) txopt
	del txopt.t

txpp.exe:	../compiler/txpp.t
	copy ..\compiler\txpp.t .
	$(TXBOOT) txpp
	del txpp.t

diff:
	..\compiler\txtrn <..\compiler\txtrn.t >__t3
	txtrn.exe <..\compiler\txtrn.t >__t3x
	-comp __t3 __t3x
	..\compiler\txx ..\build\txcg86t.tco <__t3 >__86t
	txcg86t.exe <__t3x >__86tN
	-comp __86t __86tN
	-del __t3
	-del __t3x
	-del __86t
	-del __86tN

clean:
	-del *.obj
	-del *.ERR

clobber:	clean
	-del txcgboot.exe
	-del txcg386.exe
	-del txcg386.t
	-del txcg386e.exe
	-del txcg386e.t
	-del txcg86t.exe
	-del txcg86t.t
	-del txcg86a.exe
	-del txcg86a.t
	-del txcgc.exe
	-del txcgc.t
	-del libtx.lib
	-del txtrn.exe
	-del txopt.exe
	-del txpp.exe

