{ $DEFINE ANALOGIZE}
{* S Compiler, ver 1.00.
   Copyright (C) 1994, Henri LESOURD.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This compiler is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  *}
Unit Writify;

Interface

{$IFDEF ANALOGIZE}
Var
   ColorKeyWord,ColorOperator,ColorPredef,ColorSymbol,ColorConstant : Byte;

Procedure MonoChrome;
Procedure SetMonoMode1;
Procedure SetMonoMode2;
Procedure SetMonoMode3;
Procedure SetColorMode;
Procedure WriteS(S : String);
Procedure SWriteS(S : String);
{$ENDIF}
Procedure WriteInt(I : LongInt; Base : Byte);
Procedure FWriteInt(Var F : Text; I : LongInt; Base : Byte);
{$IFDEF ANALOGIZE}
Procedure WriteKeyWord(Id : Word);
Procedure WriteOperator(Id : Word);
Procedure WriteSymbol(P : Pointer);
Procedure WriteConstant(B : Pointer);
{$ENDIF}

Implementation

Uses
    Crt,Errorify,Symbolize,Lexify;

{$IFDEF ANALOGIZE}
Procedure MonoChrome;
Begin
  Inline($B8/7/0/$CD/$10);
End;

Procedure SetMonoMode1;
Begin
  MonoChrome;
  ColorKeyWord:=$1;   { Soulign }
  ColorOperator:=$70;
  ColorSymbol:=7;
  ColorPredef:=7;
  ColorConstant:=$87;
End;

Procedure SetMonoMode2;
Begin
  MonoChrome;
  ColorKeyWord:=$70;
  ColorOperator:=$F0;
  ColorSymbol:=7;
  ColorPredef:=7;
  ColorConstant:=$1;
End;

Procedure SetMonoMode3;
Begin
  ColorKeyWord:=$70;
  ColorOperator:=$F0;
  ColorSymbol:=7;
  ColorPredef:=7;
  ColorConstant:=$87;
End;

Procedure SetColorMode;
Begin
  ColorKeyWord:=12;
  ColorOperator:=15;
  ColorSymbol:=7;
  ColorPredef:=13;
  ColorConstant:=10;
End;

Procedure WriteS(S : String);
Begin
  Write(S);
  TextAttr:=7;
  Write(' ');
End;

Procedure SWriteS(S : String);
Var
   OldTextAttr : Byte;
Begin
  OldTextAttr:=TextAttr;
  TextAttr:=7;
  Write(' ');
  TextAttr:=OldTextAttr;
  Write(S);
  TextAttr:=7;
  Write(' ');
End;

Procedure WriteKeyWord(Id : Word);
Begin
  TextAttr:=ColorKeyWord;
  Case Name(Id) Of
    KeyPackage: WriteS('Package');
    KeyUses: WriteS('Uses');
    KeyInterface: Write('Interface');
    KeyImplementation: Write('Implementation');
    KeyConst: Write('Const');
    KeyType: Write('Type');
    KeyVar: Write('Var');
    KeyStatic : Write('Static');
    KeyDef: WriteS('Def');
    KeySub: WriteS('Sub');
    KeyEnter: Write('Enter');
    KeyLeave: Write('Leave');
    KeyRecord: WriteS('Record');
    KeyIs: SWriteS('Is');
    KeyIf: WriteS('If');
    KeyThen: SWriteS('Then');
    KeyBegin: Write('Begin');
    KeyElse: WriteS('Else');
    KeyEnd: WriteS('End');
    KeyAlways: WriteS('Always');
    KeyAwhile: WriteS('Awhile');
    KeyWhile: WriteS('While');
    KeyWend: Write('Wend');
    KeyDo: SWriteS('Do');
    KeyFor: WriteS('For');
    KeyTo: SWriteS('To');
    KeyDownTo: SWriteS('DownTo');
    KeyToInf: SWriteS('To<');
    KeyDowntoSup: SWriteS('Downto>');
    KeyStep: SWriteS('Step');
    KeyNext: Write('Next');
    KeyCase: WriteS('Case');
    KeyOf: SWriteS('Of');
    KeyLabel: Write('');
    KeyGoto: WriteS('Goto');
    KeyWhen: WriteS('When');
    KeyInLine: Write('InLine');
    KeyDeuxPoints : Write(':');
    KeyCarriage: Begin
                     TextAttr:=7;
                     WriteCarriage;
                     While NbSpaces<>0 Do
                     Begin
                       Write(' ');Dec(NbSpaces);
                     End;
                   End;
    KeyPVirg: Write(';');
    KeyPFerm: Write(')');
    KeyCRFerm: Write(']');
    KeyEOF: Write('<EOF>');
  End;
End;

Procedure WriteOperator(Id : Word);
Begin
  TextAttr:=ColorOperator;
  Case Name(Id) Of
    OpPoint: Write('.');
    OpFlechePoint: Write('^.');
    OpPouvr: Write('(');
    OpCrouvr: Write('[');
    OpAdr: Write('@');
    OpMoins: Write('-,');
    OpPlus: Write('+,');
    OpFleche: Write('^');
    OpFlecheFleche: Write('^~');
    OpMul: Write('*');
    OpDiv: Write('/');
    OpMod: Write('%');
    OpAdd: Write('+');
    OpSub: Write('-');
    OpLogNot: Write('~');
    OpLogAnd: Write('&');
    OpLogOr: Write('|');
    OpLogXor: Write('~');
    OpLeftShift: Write('<<');
    OpRightShift: Write('>>');
    OpEq: Write('');
    OpNeq: Write('<>');
    OpInf: Write('<');
    OpInfEq: Write('<=');
    OpSup: Write('>');
    OpSupEq: Write('>=');
    OpNot: WriteS('Not');
    OpAnd: SWriteS('And');
    OpOr: SWriteS('Or');
    OpPointPoint: Write('..');
    OpOf: SWriteS('Of');
    OpIs: SWriteS('Is');
    OpAs: SWriteS('As');
    OpLet: Write(':=');
    OpAddLet: Write('+=');
    OpSubLet: Write('-=');
    OpMulLet: Write('*=');
    OpDivLet: Write('/=');
    OpModLet: Write('%=');
    OpLogAndLet: Write('&=');
    OpLogOrLet: Write('|=');
    OpLeftShiftLet: Write('<<=');
    OpRightShiftLet: Write('>>=');
    OpVirg: Write(',');
    OpPVirg: Write(';');
  End;
End;

Procedure WriteSymbol(P : Pointer);
Var
   B : SymbPtr;
Begin
  TextAttr:=ColorSymbol;B:=P;
  If Name(B^.Nature)=$3FFF Then PrintSymbName(B)
  Else
    Begin
      TextAttr:=ColorPredef;
      Case Name(B^.Nature) Of
        PredAX: Write('Ax');
        PredBX: Write('Bx');
        PredCX: Write('Cx');
        PredDX: Write('Dx');
        PredSP: Write('Sp');
        PredBP: Write('Bp');
        PredSI: Write('Si');
        PredDI: Write('Di');
        PredExitDef: Write('Exit Def');
        PredExitSub: Write('Exit Sub');
        PredExitWhile: Write('Exit While');
        PredExitFor: Write('Exit For');
        PredExitCase: Write('Exit Case');
        PredLabel: Write('Label');
        PredRegister: Write('Register');
        PredBoolean: Write('Boolean');
        PredShortInt: Write('ShortInt');
        PredInt: Write('Int');
        PredLongInt: Write('LongInt');
        PredByte: Write('Byte');
        PredWord: Write('Word');
        PredLongWord: Write('LongWord');
        PredArray: Write('Array');
        PredPointer: Write('Pointer');
        PredReference: Write('Reference');
        PredResult: Write('Result');
        PredHigh: Write('High');
        PredLow: Write('Low');
        PredSize: Write('Size');
        Else
          Write('<PREDEF>');
      End;
    End;
End;
{$ENDIF}

Procedure WriteInt(I : LongInt; Base : Byte);
Var
   S : String;
   Ptr : Byte;
Begin
  Ptr:=0;
  While I<>0 Do
  Begin
    Inc(Ptr);
    S[Ptr]:=Chr(I Mod Base);
    I:=I Div Base;
  End;
  If Ptr=0 Then Write('0')
  Else
    While Ptr<>0 Do
    Begin
      If Ord(S[Ptr])<=9 Then Write(Chr(Ord(S[Ptr])+Ord('0')))
                        Else Write(Chr(Ord(S[Ptr])+Ord('A')-$A));
      Dec(Ptr);
    End;
End;

Procedure FWriteInt(Var F : Text; I : LongInt; Base : Byte);
Var
   S : String;
   Ptr : Byte;
Begin
  Ptr:=0;
  While I<>0 Do
  Begin
    Inc(Ptr);
    S[Ptr]:=Chr(I Mod Base);
    I:=I Div Base;
  End;
  If Ptr=0 Then Write(F,'0')
  Else
    While Ptr<>0 Do
    Begin
      If Ord(S[Ptr])<=9 Then Write(F,Chr(Ord(S[Ptr])+Ord('0')))
                        Else Write(F,Chr(Ord(S[Ptr])+Ord('A')-$A));
      Dec(Ptr);
    End;
End;

{$IFDEF ANALOGIZE}
Procedure WriteConstant(B : Pointer);
Var
   CB : CharBoxPtr;
   SB : StringBoxPtr;
   BB : ByteBoxPtr;
   WB : WordBoxPtr;
   LB : LongBoxPtr;
   Base : Byte;
Begin
  TextAttr:=ColorConstant;
  CB:=B;SB:=B;
  BB:=B;WB:=B;LB:=B;
  Case CB^.Nature And 3 Of
    ConstChar: Write('''',CB^.Value,'''');
    ConstString: Begin
                   Write('"');
                   WriteString(SB^.Value);
                   Write('"');
                 End;
    ConstNum:
      Begin
        Case NumBase(CB^.Nature) Of
          BasedDec: Base:=10;
          BasedBin: Begin Base:=2;Write('&B'); End;
          BasedOct: Begin Base:=8;Write('&O'); End;
          BasedHex: Begin Base:=16;Write('&H'); End;
        End;
        Case NumLength(CB^.Nature) Of
          Length8: WriteInt(BB^.Value,Base);
          Length16: WriteInt(WB^.Value,Base);
          Length32: WriteInt(LB^.Value,Base);
        End;
      End;
  End;
End;
{$ENDIF}

Begin
End.