{* S Compiler, ver 1.00.
   Copyright (C) 1994, Henri LESOURD.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This compiler is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  *}
{Ŀ
  Suldrun's garden 
 }

Unit Loadify;

Interface

Uses
    Crt,Errorify,Lexify,Writify;

Type
    WString=Array[0..$7FFE] Of Word;
    BString=Array[0..$FFFE] Of Byte;
    StringPtr=^String;
    BStringPtr=^BString;
    WordPtr=^Word;
Var
   Envir0 : EnvirPtr;


Procedure WriteHeader(Var H : Header);
Procedure WriteType(B : StringPtr);
Function WriteSigma(B : StringPtr) : Pointer;
Function GetName(H : HeaderPtr) : StringPtr;
Function SizExports(H : HeaderPtr) : Word;
Function GetExports(H : HeaderPtr) : StringPtr;
Function WriteExports(SP : StringPtr; Len : Word) : StringPtr;
Function WriteImports(SP : StringPtr; Len : Word) : StringPtr;
Procedure WritePak(S : String);

Function FindPakInTheMem(S : StringPtr) : EnvirPtr;
Function LoadPak(S : String) : EnvirPtr;
Procedure LinkPak(E : EnvirPtr);

Var
   Stack : Block;

Procedure StartPak(E : EnvirPtr);
Procedure LLS(S : String);

Implementation

{ ****************
  Une fn max (...)
  **************** }
Function Max(A,B : Word) : Word;
Begin
  If A>B Then Max:=A
         Else Max:=B;
End;

{ **********************
  Procdures d'affichage
  ********************** }
Procedure WriteHeader(Var H : Header);
Var
   SP : ^String;
Begin
  Writeln('C0=',H.C0);
  Writeln('#CS=',H.SizCode);
  Writeln('Ofs(Start)=',H.OfsStart);
  Writeln('#DS=',H.SizData);
  Writeln('#Imports=',H.SizImports);
  Writeln('CS=',H.CS);
  Writeln('DS=',H.DS);
  SP:=@H;SP:=@SP^[SizeOf(H)];
  Writeln('Name=',SP^);
End;

Procedure WriteType(B : StringPtr);
Var
   WPtr : ^WString;
   Fini : Boolean;
   TheEndPtr : StringPtr;
   LenType : Byte;
Begin
  Fini:=False;
  LenType:=Ord(B^[0]);
  B:=@B^[1];
  While Not Fini Do
  Begin
    Write('(');
    WriteInt(Ord(B^[0]),16);
    If (Ord(B^[0])=ValTVSub) Or (Ord(B^[0])=ValTVDef) Then
      Begin
        Write(')');
        TheEndPtr:=@B^[LenType];
        B:=@B^[1];
        While B<>TheEndPtr Do
        Begin
          WriteType(B);
          B:=@B^[Ord(B^[0])+1];
        End;
        Fini:=True;
      End
    Else
      Begin
        Write(' ');
        WPtr:=@B^[1];
        WriteInt(WPtr^[0],16);
        Case Ord(B^[0]) Of
          ValTVArray:
            Begin
              Write(' ');
              WriteInt(WPtr^[1],16);
              Write(' ');
              WriteInt(WPtr^[2],16);
              B:=@WPtr^[3];
            End;
          ValTVPtr:
            Begin
              B:=@WPtr^[1];
            End;
          Else
            Fini:=True;
        End;
        Write(')');
      End;
  End;
End;

Function WriteSigma(B : StringPtr) : Pointer;
Var
   LenT : Word;
   WP : ^Word;
Begin
  Write(B^,',');
  LenT:=Ord(B^[Ord(B^[0])+1]);
  WriteType(@B^[Ord(B^[0])+1]);
  WP:=@B^[Ord(B^[0])+2+LenT];
  Write(',');
  WriteInt(WP^,16);
  B:=Pointer(WP);
  WriteSigma:=@B^[SizeOf(WP^)];
End;

Function GetName(H : HeaderPtr) : StringPtr;
Begin
  GetName:=@StringPtr(H)^[SizeOf(H^)];
End;

Function SizExports(H : HeaderPtr) : Word;
Begin
  SizExports:=H^.C0-
              SizeOf(H^)-
              Ord(
                   StringPtr(
                              @StringPtr(H)^[
                                              SizeOf(H^)
                                            ]
                            )^[0]
                 )+
              1;
End;

Function GetExports(H : HeaderPtr) : StringPtr;
Begin
  GetExports:=@StringPtr(H)^[SizeOf(H^)+Ord(StringPtr(H)^[SizeOf(H^)])+1];
End;

Function WriteExports(SP : StringPtr; Len : Word) : StringPtr;
Var
   TheEndPtr : Pointer;
Begin
  TheEndPtr:=@SP^[Len];
  While SP<>TheEndPtr Do
  Begin
    SP:=WriteSigma(SP);
    Writeln;
  End;
  WriteExports:=SP;
End;

Function WriteImports(SP : StringPtr; Len : Word) : StringPtr;
Var
   TheEndPtr : Pointer;
   TEP2 : StringPtr;
Begin
  TheEndPtr:=@SP^[Len];
  While SP<>TheEndPtr Do
  Begin
  { Nom du module }
    Write(SP^,' ');
    SP:=@SP^[Ord(SP^[0])+1];
  { #Sigmas }
    WriteInt(WordPtr(SP)^,16);
    Writeln;
    TEP2:=@SP^[WordPtr(SP)^+2];
    SP:=@SP^[2];
    While SP<>TEP2 Do
    Begin
      Write('  ');
      SP:=WriteSigma(SP);
      Write(' ');
      WriteInt(WordPtr(SP)^,16);
      Writeln;
      SP:=@SP^[2];
    End;
  End;
End;

Procedure WritePak(S : String);
Type
    Segment=Array[0..$FFFE] Of Byte;
Var
   SP : StringPtr;
   F : File;
   H : HeaderPtr;
   Buf : Array[0..1023] Of Byte;
   TheEndPtr,TEP2 : Pointer;
   CS : ^Segment;
   Ptr : Word;
Begin
  S:=Concat(S,'.Pak');
{ Open }
  Assign(F,S);
  Reset(F,1);
{ C0,Header }
  H:=@Buf;
  BlockRead(F,H^.C0,SizeOf(H^.C0));
  SP:=@Buf[SizeOf(H^.C0)];
  BlockRead(F,SP^,H^.C0);
  WriteHeader(H^);
{ Exports }
  SP:=@Buf[SizeOf(H^)];
  SP:=WriteExports(@SP^[Ord(SP^[0])+1],H^.C0-SizeOf(H^)-Ord(SP^[0])+1);
{ Code }
  Ptr:=0;
  CS:=Pointer(SP);
  BlockRead(F,SP^,H^.SizCode);
  While Ptr<>H^.SizCode Do
  Begin
    WriteInt(CS^[Ptr],16);
    Write(' ');
    Inc(Ptr);
    If Ptr Mod $10=0 Then Writeln;
  End;
  If Ptr Mod $10<>0 Then Writeln;
{ Imports }
{$R-}
  SP:=@SP^[H^.SizCode];
{$R+}
  BlockRead(F,SP^,H^.SizImports);
  SP:=WriteImports(SP,H^.SizImports);
{ Close }
  Close(F);
End;

{ *********
  Le loader
  ********* }
Function FindPakInTheMem(S : StringPtr) : EnvirPtr;
Var
   E : EnvirPtr;
Begin
  FindPakInTheMem:=Nil;
  E:=Envir0;
  While E<>Nil Do
    If GetName(E^.H)^=S^ Then
      Begin
        FindPakInTheMem:=E;
        Exit;
      End
    Else
      E:=E^.Next;
End;

Type
    SegmentPtr=^Segment;
    Segment=Array[0..$FFFE] Of Byte;

Procedure FillRepString(Var B : Segment; Ofs,Value : Word);
Var
   OfsOld : Word;
Begin
  While Ofs<>$FFFF Do
  Begin
    OfsOld:=Ofs;
    Ofs:=WordPtr(@B[Ofs])^;
    WordPtr(@B[OfsOld])^:=Value;
  End;
End;

{ ********
  * Load *
  ******** }
Function LoadPak(S : String) : EnvirPtr;
Var
   F : File;
   E : EnvirPtr;
   W : Word;
   SP : BStringPtr;
   Padder : Word;
Begin
{ Open F }
  S:=Concat(S,'.Pak');
  If Not FileExists(S) Then Error('LoadPak : File not found');
  Assign(F,S);
  Reset(F,1);
{ C0,Header }
  BlockRead(F,W,SizeOf(W));
  New(E);
  E^.Linked:=False;
  Padder:=16-((W+2) Mod 16);
  GetMem(E^.H,W+2+Padder);
  E^.H^.C0:=W;
  BlockRead(F,WordPtr(@E^.H^.SizCode)^,W+Padder);
{ Code }
  GetBlock(E^.CS,E^.H^.SizCode);
  BlockRead(F,WordPtr(E^.CS.BA)^,E^.H^.SizCode);
{ Data/Imports }
  GetBlock(E^.DS,Max(E^.H^.SizImports,E^.H^.SizData));
  BlockRead(F,WordPtr(E^.DS.BA)^,E^.H^.SizImports);
  Close(F);
{ WriteHeader(E^.H^);
  SP:=WriteExports(GetExports(E^.H),SizExports(E^.H));
  SP:=WriteImports(E^.DS.BA,E^.H^.SizImports); }
{ Rentrer le module ds Envir0 }
  E^.Next:=Envir0;
  Envir0:=E;
  LoadPak:=E;
End;

{ ********
  * Link *
  ******** }
Procedure LinkPak(E : EnvirPtr);
Var
   E2 : EnvirPtr;
   SP,EndImports,EndLine : BStringPtr;
   CS,DS : Word;
   WP : ^Word;
   Tag : Byte;
Begin
{ Test Linked }
  If E^.Linked Then Exit Else E^.Linked:=True;
{ Linker la chane des DS }
  FillRepString(SegmentPtr(E^.CS.BA)^,E^.H^.DS,AccessPtr(@E^.DS.BA)^[1]);
{ Se positionner sur la table des imports }
  SP:=E^.DS.BA;
  EndImports:=@SP^[E^.H^.SizImports];
{ Tq il y a des modules imports, pour 1 module import }
  While SP<>EndImports Do
  Begin
  { Rechercher s'il est ds Envir0 }
    E2:=FindPakInTheMem(StringPtr(SP));
  { Si non, le charger }
    If E2=Nil Then
    Begin
      LLS(StringPtr(SP)^);
      E2:=FindPakInTheMem(StringPtr(SP));
      If E2=Nil Then Error('LoadPak : Import Pak !FoundInTheMem (Khouill)');
    End;
  { Getter ses CS & DS }
    CS:=AccessPtr(@E2^.CS.BA)^[1];
    DS:=AccessPtr(@E2^.DS.BA)^[1];
  { Se positionner au dbut des Li }
    SP:=@SP^[Ord(SP^[0])+1];
    EndLine:=@SP^[WordPtr(SP)^+SizeOf(Word)];
    SP:=@SP^[SizeOf(Word)];
  { Tq pas  la fin des Li }
    While SP<>EndLine Do
    Begin
    { Trouver l'entre correspondante ds les exports de l'autre }
      SP:=@SP^[Ord(SP^[0])+1];
      Tag:=Byte(SP^[2]);
      If Tag=ValTVType Then
      Begin
        SP:=@SP^[3];
        SP:=@SP^[WordPtr(@SP^[0])^+2];
        SP:=@SP^[2];
      End
      Else
      If Tag=ValTVConst Then
      Begin
        SP:=@SP^[3];
        WP:=@SP^[3];
        SP:=@SP^[WordPtr(@SP^[0])^+2];
        Case WP^ Of
          2: SP:=@SP^[2];
          4: SP:=@SP^[4];
          Else
            Error('Load : Const : big couille');
        End;
        SP:=@SP^[2];
      End
      Else
      Begin
      { Checker les types et adresses }
      { Aucun check ici, eh patate !!! On ne fait que skipper le type. }
        SP:=@SP^[WordPtr(@SP^[0])^+SizeOf(Word)+2];
      { Balancer CS ou DS le long de la chane de reprise }
        If (Tag=ValTVSub) Or (Tag=ValTVDef)
        Then
          FillRepString(SegmentPtr(E^.CS.BA)^,WordPtr(SP)^,CS)
        Else
          FillRepString(SegmentPtr(E^.CS.BA)^,WordPtr(SP)^,DS)
        ;
      { Avancer d'un lment import }
        SP:=@SP^[SizeOf(Word)];
      { Avancer d'un lment export }
        ;
      End;
    End;
  End;

{ ****************************************
  Et l, c'est torch, le module est link
  **************************************** }
End;

{ *****************
  Start d'un module
  ***************** }

{$F+}
Procedure StartPak(E : EnvirPtr);
Var
   NewDS : Word;
   A : Access;
Begin
{ InLine($CC); }
{ Sauvegarder SS,BP,SP,DS qqpart o ou puisse les retrouver aprs }
{ PUSH DS }
  InLine($1E);
{ Sets : SS=Stack.BA : SP=Stack.Size : DS=E^.DS }
{ MOV AX,E^.DS }
  NewDS:=AccessPtr(@E^.DS.BA)^[1];
{ MOV AX,[BP-2] (BP-2=@NewDS) }
  InLine($8B/$46/$FE);
{ MOV DS,AX }
  InLine($8E/$D8);
{ CALL FAR E^.CS:E^.H^.OfsStart }
  A[1]:=AccessPtr(@E^.CS.BA)^[1];
  A[0]:=E^.H^.OfsStart;
{ CALL FAR [BP-6] (BP-6=@A) }
  InLine($FF/$5E/$FA);
{ Restaurer SS,BP,SP,DS }
{ POP DS }
  InLine($1F);
End;
{$F-}

{ ****************
  Load, Link&Start
  **************** }
Procedure LLS(S : String);
Var
   E : EnvirPtr;
Begin
  E:=LoadPak(S);
  LinkPak(E);
  StartPak(E);
End;

Begin
  Envir0:=Nil;
End.