/*
 * MultiMail offline mail reader
 * letter_header and letter_list

 Copyright (c) 1996 Toth Istvan <stoty@vma.bme.hu>
 Copyright (c) 1998 William McBrine <wmcbrine@clark.net>

 Distributed under the GNU General Public License.
 For details, see the file COPYING in the parent directory. */

#include "mmail.h"

// ---------------------------------------------------------------------------
// Letter header methods
// ---------------------------------------------------------------------------

letter_header::letter_header(mmail *mmA, const char *subjectA,
		const char *toA, const char *fromA, const char *dateA,
		int replyToA, int LetterIDA, int msgNumA, int AreaIDA,
		int privatA, int lengthA, specific_driver *driverA,
		net_address *netAddrA)
{
	dl = mmA->driverList;
	driver = driverA;
	readO = dl->getReadObject(driver);
	subject = strdupplus(subjectA);
	to = strdupplus(toA);
	from = strdupplus(fromA);
	date = strdupplus(dateA);
	replyTo = replyToA;
	LetterID = LetterIDA;
	AreaID = AreaIDA;
	privat = privatA;
	length = lengthA;
	msgNum = msgNumA;
	if (netAddrA)
		netAddr = *netAddrA;
	else
		netAddr.zone = 0;
}

letter_header::~letter_header()
{
	delete subject;
	delete to;
	delete from;
	delete date;
}

const char *letter_header::getSubject()
{
	return subject;
}

const char *letter_header::getTo()
{
	return to;
}

const char *letter_header::getFrom()
{
	return from;
}

const char *letter_header::getDate()
{
	return date;
}

int letter_header::getReplyTo()
{
	return replyTo;
}

int letter_header::getLetterID()
{
	return LetterID;
}

int letter_header::getAreaID()
{
	return AreaID + dl->getOffset(driver);
}

int letter_header::getPrivate()
{
	return privat;
}

const char *letter_header::getBody()
{
	return driver->getBody(AreaID, LetterID);
}

int letter_header::getLength()
{
	return length;
}

specific_driver *letter_header::getDriver()
{
	return driver;
}

int letter_header::getRead()
{
	return readO->getRead(AreaID, LetterID);
}

void letter_header::setRead()
{
	readO->setRead(AreaID, LetterID, 1);
}

int letter_header::getStatus()
{
	return readO->getStatus(AreaID, LetterID);
}

void letter_header::setStatus(int stat)
{
	readO->setStatus(AreaID, LetterID, stat);
}

int letter_header::getMsgNum()
{
	return msgNum;
}

net_address *letter_header::getNetAddr()
{
	return &netAddr;
}

// ---------------------------------------------------------------------------
// Letterlist methods
// ---------------------------------------------------------------------------

letter_list::letter_list(mmail *mmA, int areaNumberA, int isCollA)
{
	dl = mmA->driverList;
	areaNumber = areaNumberA;
	driver = dl->getDriver(areaNumber);
	areaNumber -= dl->getOffset(driver);
	readO = dl->getReadObject(driver);
	isColl = isCollA;
	init();
}

void letter_list::init()
{
	driver->selectArea(areaNumber);
	noOfLetters = driver->getNoOfLetters();
	letterHeader = new letter_header *[noOfLetters];
	driver->resetLetters();
	for (int c = 0; c < noOfLetters; c++)
		letterHeader[c] = driver->getNextLetter();
	currentLetter = 0;
	if ((noOfLetters > 1) && !isColl)
		lettqsort(0, noOfLetters - 1);
		//sort(LS_SUBJ);	// test/default sort key should be here
}

letter_list::~letter_list()
{
	cleanup();
}

void letter_list::cleanup()
{
	while (noOfLetters)
		delete letterHeader[--noOfLetters];
	delete letterHeader;
}

void letter_list::lettqsort(int left, int right)
{
	int lower, upper, d, t;
	letter_header *pivot, *lhtmp;
	const char *p;
	int p2;

	lower = left;
	upper = right;
	pivot = letterHeader[((left + right) >> 1)];
	p = pivot->getSubject();
	p2 = pivot->getLetterID();
	do {
		do {
			d = strcasecmp(letterHeader[lower]->getSubject(), p);
			t = (d < 0) || (!d && ((letterHeader[lower]->
			      getLetterID()) < p2));
			if (t)
				lower++;
		} while (t);
		do {
			d = strcasecmp(letterHeader[upper]->getSubject(), p);
			t = (d > 0) || (!d && ((letterHeader[upper]->
			      getLetterID()) > p2));
			if (t)
				upper--;
		} while (t);
		if (lower <= upper) {
			if (lower != upper) {
				lhtmp = letterHeader[lower];
				letterHeader[lower] = letterHeader[upper];
				letterHeader[upper] = lhtmp;
			}
			lower++;
			upper--;
		}
	} while (lower < upper);
	if (left < upper)
		lettqsort(left, upper);
	if (lower < right)
		lettqsort(lower, right);
}

/*
void letter_list::sort(int keyord)	// lame, not really impl'd etc...
{
	switch (keyord) {
	case LS_SUBJ:
		lettqsort(0, noOfLetters - 1);
	}
}
*/

int letter_list::noOfLetter()
{
	return noOfLetters;
}

const char *letter_list::getSubject()
{
	return letterHeader[currentLetter]->getSubject();
}

const char *letter_list::getFrom()
{
	return letterHeader[currentLetter]->getFrom();
}

int letter_list::getMsgNum()
{
	return letterHeader[currentLetter]->getMsgNum();
}

const char *letter_list::getTo()
{
	return letterHeader[currentLetter]->getTo();
}

const char *letter_list::getDate()
{
	return letterHeader[currentLetter]->getDate();
}

int letter_list::getReplyTo()
{
	return letterHeader[currentLetter]->getReplyTo();
}

int letter_list::getAreaID()
{
	return letterHeader[currentLetter]->getAreaID();
}

int letter_list::getPrivate()
{
	return letterHeader[currentLetter]->getPrivate();
}

const char *letter_list::getBody()
{
	return (isColl ? driver->getBody(areaNumber, currentLetter) :
		letterHeader[currentLetter]->getBody());
}

int letter_list::getLength()
{
	return letterHeader[currentLetter]->getLength();
}

net_address *letter_list::getNetAddr()
{
	return letterHeader[currentLetter]->getNetAddr();
}

int letter_list::getRead()
{
	return letterHeader[currentLetter]->getRead();
}

void letter_list::setRead()
{
	if (isColl)
		readO->setRead(areaNumber, currentLetter, 1);
	letterHeader[currentLetter]->setRead();
}

int letter_list::getStatus()
{
	return letterHeader[currentLetter]->getStatus();
}

void letter_list::setStatus(int stat)
{
	if (isColl)
		readO->setStatus(areaNumber, currentLetter, stat);
	letterHeader[currentLetter]->setStatus(stat);
}

int letter_list::getCurrent()
{
	return currentLetter;
}

void letter_list::gotoLetter(int newLetter)
{
	if ((newLetter >= 0) && (newLetter < noOfLetters))
		currentLetter = newLetter;
}

void letter_list::rrefresh()
{
	cleanup();
	init();
}
