/*
 * MultiMail offline mail reader
 * area_header and area_list

 Copyright (c) 1996 Toth Istvan <stoty@vma.bme.hu>
 Copyright (c) 1998 William McBrine <wmcbrine@clark.net>

 Distributed under the GNU General Public License.
 For details, see the file COPYING in the parent directory. */

#include "mmail.h"

// ---------------------------------------------------------------------------
// Area header methods
// ---------------------------------------------------------------------------

area_header::area_header(mmail *mmA, int numA, const char *shortNameA,
			const char *nameA, const char *descriptionA,
			const char *areaTypeA, int typeA, int noOfLettersA,
			int noOfPersonalA)
{
	mm = mmA;
	shortName = shortNameA;
	name = nameA;
	description = descriptionA;
	areaType = areaTypeA;
	type = typeA;
	num = numA;
	noOfLetters = noOfLettersA;
	noOfPersonal = noOfPersonalA;

	driver = mm->driverList->getDriver(num);
}

const char *area_header::getName()
{
	return name;
}

const char *area_header::getShortName()
{
	return shortName;
}

const char *area_header::getDescription()
{
	return description;
}

const char *area_header::getAreaType()
{
	return areaType;
}

int area_header::getNoOfLetters()
{
	return noOfLetters;
}

int area_header::getNoOfUnread()
{
	return (isActive() ? (mm->driverList->getReadObject(driver))->
		getNoOfUnread(num - mm->driverList->getOffset(driver)) : 0);
}

int area_header::getNoOfPersonal()
{
	return noOfPersonal;
}

int area_header::getUseAlias()
{
	return type & ALIAS;
}

int area_header::isCollection()
{
	return type & COLLECTION;
}

int area_header::isReplyArea()
{
	return type & REPLYAREA;
}

int area_header::isActive()
{
	return type & ACTIVE;
}

int area_header::isNetmail()
{
	return (type & NETMAIL) && !(type & INTERNET);
}

// ---------------------------------------------------------------------------
// Arealist methods
// ---------------------------------------------------------------------------

area_list::area_list(mmail *mmA)
{
	mm = mmA;
	int c = 0;

	no = 0;

	actLetterList = NULL;
	actDriver = NULL;

	do {
		no += mm->driverList->getDriver(no)->getNoOfAreas();
		c++;
	} while (c < mm->driverList->getNoOfDrivers());

	areaHeader = new area_header *[no];
	activeHeader = new int[no];

	for (c = 0; c < no; c++) {
		actDriver = mm->driverList->getDriver(c);
		areaHeader[c] = actDriver->getNextArea();
	}

	current = shortlist = 0;
	relist();

	// 1. Find out what types of areas we have (i.e. qwk, usenet... ) 
	// 2. Create the appropriate driver objects
	// 3. Find out the number of areas for each type
	// 4. Allocate the memory for the area_header descriptions
	// 5. Fill the area headers
}

area_list::~area_list()
{
	while (no)
		delete areaHeader[--no];
	delete areaHeader;
	delete activeHeader;
}

void area_list::relist()
{
	noActive = 0;
	shortlist = !shortlist;
	for (int c = 0; c < no; c++)
		if (areaHeader[c]->isActive() || !shortlist) {
			activeHeader[noActive] = c;
			noActive++;
		}
}

const char *area_list::getShortName()
{
	return areaHeader[current]->getShortName();
}

const char *area_list::getName()
{
	return areaHeader[current]->getName();
}

const char *area_list::getName(int area)
{
	if ((area < 0) || (area >= no))
		fatalError("Internal error in area_list::getName");
	return areaHeader[area]->getName();
}

const char *area_list::getDescription()
{
	return areaHeader[current]->getDescription();
}

const char *area_list::getDescription(int area)
{
	if ((area < 0) || (area >= no))
		fatalError("Internal error in area_list::getDescription");
	return areaHeader[area]->getDescription();
}

const char *area_list::getAreaType()
{
	return areaHeader[current]->getAreaType();
}

int area_list::getNoOfLetters()
{
	return areaHeader[current]->getNoOfLetters();
}

int area_list::getNoOfUnread()
{
	return areaHeader[current]->getNoOfUnread();
}

int area_list::getNoOfPersonal()
{
	return areaHeader[current]->getNoOfPersonal();
}

letter_list *area_list::getLetterList()
{
	actLetterList = new letter_list(mm, current, isCollection() &&
					!isReplyArea());
	return actLetterList;
}

int area_list::noOfAreas()
{
	return no;
}

int area_list::noOfActive()
{
	return noActive;
}

void area_list::gotoArea(int currentA)
{
	if ((currentA >= 0) && (currentA < no))
		current = currentA;
}

void area_list::gotoActive(int activeA)
{
	if ((activeA >= 0) && (activeA < noActive))
		current = activeHeader[activeA];
}

int area_list::getAreaNo()
{
	return current;
}

int area_list::getActive()
{
	int c;

	for (c = 0; c < noActive; c++)
		if (activeHeader[c] >= current)
			break;
	return c;
}

void area_list::enterLetter(int areaNo, char *from, char *to, char *subject,
			int replyTo, int privat, net_address *netAddress,
			char *filename, int length)
{
	net_address dummy_address;
	letter_header *newLetter;
	reply_driver *replyDriver;

	if (!netAddress) {
		dummy_address.zone = 0;
		netAddress = &dummy_address;
	}

	replyDriver = mm->driverList->getReplyDriver();

	gotoArea(areaNo);
	newLetter = new letter_header(mm, subject, to, from, "", replyTo,
			0, 0, areaNo, privat, 0, replyDriver, netAddress);

	replyDriver->enterLetter(newLetter, filename, length);

	delete newLetter;
	refreshArea();
}

void area_list::killLetter(int letterNo)
{
	mm->driverList->getReplyDriver()->killLetter(letterNo);
	refreshArea();
}

void area_list::makeReply()
{
	mm->driverList->getReplyDriver()->makeReply();
}

void area_list::refreshArea()
{
	delete areaHeader[REPLY_AREA];

	areaHeader[REPLY_AREA] =
		mm->driverList->getReplyDriver()->refreshArea();
	if (current == REPLY_AREA)
		actLetterList->rrefresh();
}

int area_list::getUseAlias()
{
	return areaHeader[current]->getUseAlias();
}

int area_list::isCollection()
{
	return areaHeader[current]->isCollection();
}

int area_list::isReplyArea()
{
	return areaHeader[current]->isReplyArea();
}

int area_list::isNetmail()
{
	return areaHeader[current]->isNetmail();
}
