

                NeOS - Network Enhanced Operating System


ACKNOWLEDGMENTS

Thanks to "DMS Computer Systems" for hardware and software support and
other contributors for their knowledge, time and patience. Thanks to Kent
Freeland for helping us with english version of this manual.

1. INTRODUCTION

Thank you for using (and hopefully buying) the NeOS Network Operating
System.  You have selected the best way to increase the capacity of
your existing equipment with minimum investment. You will see a step
improvement in your overall system performance regardless of the number
of Personal Computers you have connected to NeOS.  In selecting the
NeOS solution, you have stepped into a new era of computer
communications, without which your business cannot succeed today.  The
name of this program package originates from Greek, meaning "new"; the
name wasn't an accident. In addition to the usual LAN features, you
will find some powerful new capabilities which will make using your
computers and network more productive as well as much easier.

                                        Igor Bujanovic
                                        University Computing Centre - Zagreb
                                        e-mail: igor@smile.srce.hr

                                        Vlatko Basic

2. BASIC NETWORK TERMS

This chapter will explain basic terminology which is used in this
manual for installation and configuration of the NeOS Network. If
you are an experienced networker, skip this chapter. The following
terms are used:

* Resources
* Server and Client
* Resource Access and Sharing
* Net LOGIN and LOGOUT
* Network Data Safety


2.1 RESOURCES

In computer terminology, resources refer to computer components (fixed
or "hard" disk drives, RAM, CPU, CD-ROM, etc.).  Only certain resources
can be shared among several computers or users (such as memory or CPU),
while others (such as screen, keyboard, or mouse) cannot.  What do we
mean by "share a resource" on the Network?  For example: your Network
consists of two computers; Computer A and Computer B.  Computer A
allows  access to the hard disk on computer B.  The hard disk on
Computer A is a "shared" resource, which both computers have access to
simultaneously.  The next example shows how, sometimes, that resources
cannot be shared. What would happen, for example, if Computer A allows
access to the video display (monitor) of computer B? The information
which arrives at Computer A would be senseless mixture of information
generated by both computers. The sharing of this resource is possible,
but serves no purpose.

2.2 SERVER and CLIENT

The computers on the network are divided into "SERVER" and "CLIENT" by
all familiar Network Operating Systems (NOS).  The "Server" computer
permits utilization of its resources by another computer.  The "Client"
computer usually does not permit access to its resources, but may use
resources from other computers.  From the previous example, Computer A
is the Server, while computer B is a Client.  For example, if Computer
B wants to read a file from a Network resource (such as a hard disk)
from Computer A, the following procedure should be accomplished:

1. Type the read command on Computer B

2. The Network will redirect the command to Computer A, which receives
   the command

3. Computer A will verify access permission  for Computer B

4. If approved, Computer A may then read data from the file and make it
   available for display and processing on Computer B

Note that the user of Computer B is not aware of the network connection
to Computer A; to the user of Computer B, it merely seems that the file
is available from its own hard disk.

2.3  RESOURCE ACCESS and SHARING

When first installing a network, users are naturally concerned about
sharing their computer resources with other users and the potential for
data loss and other damage.   Users have little to fear, however, as
the Network installation includes rigid control over resource sharing
and access, permitting access to a given computer only by another user
specifically authorized to do so.  Setting up resource access is a
straightforward process using the supervisor program included with the
network; sharable resources, such as hard drives or peripherals like
printers and plotters, may be assigned  for each individual computer
user (the network node) and specific resource within the computer.
Levels of access may be assigned (i.e., read-only, update only, or full
write capability of files or directories), and access may even be
controlled by time.  This capability is one of the greatest advantages
of  an NeOS over native DOS or other single-user operating systems.


2.4 NET LOGIN and  LOGOUT

Before a computer may use network resources, a connection process known
as LOGON is performed to identify the new Client computer to the Server
and permit the supervisory program to determine the resource sharing
and access rights for the particular Client.  This LOGON normally
involves validation of user identity through a name/password matching
prior to connection of the Client machine to the network.  Once
admitted, the user is then free to access whatever resources are
authorized by the NeOS supervisor.

The user utilizes Network resources as if they are located on the local
Client computer, limited only by the level of authorization for each
resource. For instance, if the user of computer B is authorized
read-only access to a  resource on computer A,  activities such as
changing, creating, renaming or erasing new files or directories are
not permitted

Client users should always go through the LOGOUT sequence on their
computer prior to machine power-down, or data loss may result.


2.5 NETWORK DATA SAFETY

Data safety for network users is not limited to protection against
unauthorized file and program changes or tampering; business network
systems provide different ways of protecting users and their data from
unauthorized access to resources. Used correctly, network security and
access control features can insure data safety.  However, some data
protection methods require common sense as well as technology.
Passwords that are easy to guess or too short, computer viruses, and
poor network management and integrity are most often cited as causes of
lost data.

3. NeOS INSTALLATION

NeOS version 1.00 requires the following  minimum configuration for
each Personal Computer to be connected to the system:

*  IBM PC AT/386/486/Pentium or 100% IBM PC Compatible
*  256 KB  of RAM
*  HDD unit (optional for diskless workstations)
*  MS or IBM DOS version 5.0 or higher (DR or NOVELL DOS NOT SUPPORTED!)

3.1 NETWORK ADAPTER INSTALLATION

The NeOS Network Adapter card requires the assignment of an unassigned
hardware interrupt and available memory for I/O addresses in each PC.
The default interrupt set on the NeOS adapter is IRQ3 and I/O address
beginning at 0x300 (300 H).  If there is an interrupt conflict or other
I/O problem, it will be necessary to change the interrupt to another
port code.  Most PC's assign interrupt IRQ3 to COM2, and if you have
two or more serial devices on the host PC, you must select another
port.  Select IRQ5 if you are using only one parallel port (LPT1), or
select one of IRQ10, IRQ11, or IRQ15 if both parallel ports are in use.
It is unlikely that any changes will be required to the I/O address
space; NeOS has been tested with all address combinations with no
faults.  If your Network adapters do not have DIP switch banks, a
software setup diskette has been included with the adapter which will
permit setup.  Consult the instructions included with the network
adapter installation.  We suggest that you write down the settings made
to the adapter card or software.  This will save re-installation and/or
opening the computer case to reverify settings.

The next step is to place the network adapter in one of your open slots
on the motherboard.

NOTE: Be sure to powerdown and disconnect the PC's power cord from AC
power before opening the case and doing any work. Discharge any static
accumulated on your hands by touching a finger to a grounded surface
prior to touching any components inside your PC.

Then, install the board.  Utilize an open 8-bit slot connector if
available, saving 16 bit slots for those boards needing them.  Connect
the coaxial cable to the BNC plug on the network adapter.  Replace
other boards you may have removed to gain access to an open slot, the
close the computer case and reconnect the power cord and other cables.

Next, power the PC back up.  If you notice problems with using other
peripheral ports or other irregularities in the operation of the PC,
you will need to change the interrupt used by the adapter by repeating
the steps above.  If you have a diagnostic software program, such as
Checkit, Norton Utilities SysInfo, or an internal diagnostic program
from your PC manufacturer, run the Interrupt or Port report to check
for available interrupts.

NOTE:  You may wish to obtain professional assistance for complex
installations involving more than 35 PC's and/or involving distances
greater than 500 feet (180 m), to assist you in installing line
boosters and managing a large number of  network nodes.


3.5  NeOS PROGRAM INSTALLATION

Be sure to make a backup copy of your NeOS installation disks prior to
commencing with installation, and perform the installation using the
backup disks.  Insert the NeOS installation diskette into your A: drive
and type:

C:\>A:INSTALL

The installation process is very short (less than one minute).  The
installation program will ask you a few questions.  All blanks should
be filled in to properly register the NeOS installation on the PC.
Enter the selected interrupt code in the "IRQ" window.  The "I/O
address" value should not be changed (the default  is 300H);  incorrect
"IRQ" or "I/O address" data will prevent the card from working properly
on the network.  Enter  "O.K." to confirm the values used for the card.
Another dialogue box will appear; refer to Chapter 6.2 for
explanation of each dialogue field. After confirming entries the
required files will be copied from the installation disk to the
C:\NEOS.NET directory.  The autoexec.bat and config.sys files on your
PC will be updated in order to activate the NeOS Network in the
following manner:

* Add "C:\NEOSNET" to the PATH command in the AUTOEXEC.BAT

* Add "CALL STARNET" command after the last line in the AUTOEXEC.BAT

* The command "LASTDRIVE= " is inserted in the CONFIG.SYS.  DOS will
  determine and insert the value of the last (next) available drive
  during system startup.  This drive letter is your Network "drive".

Please read Chapters 4, 5, and 6 of this manual before using the
network software on your PC.  In the NeOS network all PC workstations
(nodes) can share resources. Resources sharing is executed by a
configuration program.  The NeOS program suite will be described in
the following chapters .

4.   PROGRAM "NeOS"

The program kernel for the NEOS network node is NEOS.COM.  After the
command STARTNET is entered, the following message will be displayed:

Network Enhanced Operating System - Version 1.00
Copyright (c) 1992-1994 by NuNET, Inc. All rights reserved.

Registered to:
     Name
     Company
     ftp - smile.srce.hr

NeOS Network Disk = F:

Checking file consistency ... ok
37725 bytes resident after initialization at 13EC:0000.

When the DOS prompt (C:\ >) appears, the NeOS network is active.

4.1 NeOS REMOVAL FROM MEMORY

NeOS netware can be easily removed from memory with the "-" switch
entered after the NEOS command at the C:\ prompt. (Any other program
using the NeOS interrupt code, however, will not run correctly unless
the NeOS adapter card is set to another interrupt code or physically
removed  from the PC.)


Network Enhanced Operating System - Version 1.00
Copyright (c) 1992-1994 by NuNET, Inc. All rights reserved.

NeOS unloaded!

NeOS netware may be reactivated with the command "STARTNET".


5. THE USE OF THE "CONFIG" AND "NET" PROGRAMS

User access to the NeOS network is controlled through two programs:
CONFIG and NET. We suggest that you start one of these (preferably
CONFIG) and get acquainted with them.

Programs may also be used with a mouse.


5.1 BASIC RULES FOR USE OF A KEYBOARD

Keyboard commands for the programs are as follows:

* F10 returns the user to the Main Menu
* Choices are selected by arrow keys and ENTER.
* ESC cancels previous action
* F1 key returns the HELP facility
* The status line at the bottom of the screen also describes the
  key functions


5.2 BASIC RULES FOR USE OF A MOUSE

A mouse may be used for keyboard functions and selection of options in
dialogues, lists and  menus. Pressing the left mouse button is
equivalent to pressing the "ENTER" key , the middle is equal to the
"INSERT" key and the right button is equal to the "ESC" key.

Remember that "ESC" will, of course, cancel the previous action or
command.

5.3 COMMANDS from a MAIN MENU

The menu bar at the top of the screen in accessed in one of the
following ways:

* Press the ALT  key to display pulldowns and use first (or
  underlined) letter of the command.  Move across menu options with
  LEFT and RIGHT arrow keys.  Press ENTER for selection.

* Press the F10 key to display pulldowns and use the first (or
  underlined) letter of the command.  Move across menu options with
  LEFT and RIGHT arrow keys.  Press ENTER for selection.  3. Press
  F10 and select pulldown options with UP- or DOWN-arrow keys.  Move
  across menu options with LEFT and RIGHT arrow keys.  Press ENTER for
  selection.

* Move cursor with the mouse to desired location on menu, click left
  button once for pulldown, select menu option with left mouse button.
  Or, select options with mouse by "dragging" (hold left button and
  move mouse to desired option), and releasing the left button on the
  desired option.


6. THE "CONFIG" PROGRAM

NeOS netware may be configured by use of the "CONFIG" program to
control the sharing of and access to network resources.  Those
computers which do not require shared resources do not need to run
CONFIG.  Those PC's which will share resources must run CONFIG first
in order to be able to share resources.   Whenever changes to the
netware configuration are made, NeOS should be stopped and restarted,
or the computer rebooted.

CONFIG has the following basic functions:

* Network sharing of  selected local PC node resources;
* User accounting and tracking of resource allocation;
* Node PC configuration (system time sharing , network disk selection
  for network drives

Before setting up any configuration, the network supervisor should:

* Select local resources (directories, drives, printers, etc.) to be
  shared.
* Determine users to be permitted to access each "network" resource

6.1 RESOURCE share

Start the program by entering

C:\>CONFIG

An introduction screen will be displayed.

6.1.1 DETERMINE DISK SHARING

Select "SHARE" from the Main Menu, then select "DISK SHARE" from the
SHARE pull-down menu.  A dialogue box labeled  "SHARING DIRECTORIES"
(fig.1) will be displayed.  Resources down to the directory level;
files cannot be split between network resources in NeOS netware.
Information on the SHARING DIRECTORIES is organized into two columns,
showing the network name for each shared device and the corresponding
real drive/directory name to be shared.  When NeOS is first installed,
the screen will be empty.To add new devices and network names, press
the INSERT key (or center button for MS mouse users).  The SHARING A
DIRECTORY pulldown menu will be displayed.  Enter a network name for
the directory, and press ENTER.  A second screen titled "Sharing
Directories for a Network Name" will be displayed, showing a directory
tree similar to DOS TREE.  Use the Up and Down arrow keys to highlight
the desired directory.  Repeat this for each network drive/directory
name to be assigned.  Selecting a directory will permit files in that
directory and all sub-directories to be shared; selecting the Root
Directory will permit the entire drive to be shared.  Cancel a
selection or the dialogue by pressing the ESC key (right mouse button).

This screen is also utilized to assign network names for sharing of
"virtual" drives by the drive letter assigned by DOS during driver
installation at bootup, including CD-ROM, Tape Backups, Removable Disks
and other devices.  As above, select drive root directory to share the
entire device or directories as appropriate.

Other commands available from DIRECTORY SHARE include:

* ERASE to delete a directory assignment
* EDIT for changing network names
* OK for confirmation of directory share assignment
* CANCEL to cancel last entry and exit the dialogue

6.1.2   SHARING PRINTERS

To designate shared printers, select SHARE from the Main Menu, and
SHARE PRINTERS from the pulldown menu.  A screen similar to the one
shown in figure 3 is displayed.  The left column will show all
available parallel and serial devices connected to the computer.  If
information on a particular device is not available, the device cannot
be shared.  A NETWORK NAME dialogue box will show the network name
under which each device is available for sharing.  The buffer size
should be set to 512 bytes for dot-matrix and other streaming-format
printers, and 2048 bytes for laser printers and other page-format
printers.  The final dialogue box permits banner enable/disable and the
option of accounting for printer usage.  Use the:

* INSERT key to add a new device
* DELETE key to delete a device

6.1.3 NETWORK UTILIZATION ACCOUNTING

User accounting for device utilization should be implemented for
managing network traffic and activity of disks and printer/plotter
devices.  The Accounting dialogue is divided into columns for user
"Nicknames", the Share List and Access Switches for the device name, user
statistics (password, user's name, etc.), and a column to assign Printer
Priority.

USER LIST

This column should show user "Nicknames" for all workstation (node)
resources.  The device authorization.  Use the following commands:

* ADD NEW USER
* DELETE (selected user)
* F3 - COPY NEW USER (To add new user, copying the displayed network
  profile to the new account)

SHARE LIST and ACCESS SWITCHES

Two columns show network device names and the access switches for each.
Use the INSERT and DELETE keys to toggle each Access Switch ("X"
indicates activation).  NeOS offers nine network security levels:

1. Create File
2. Read Only from File
3. Write to File
4. Attribute Change Permission
5. Rename Files
6. Delete Files
7. Execute Program
8. Remove Directories
9. Make Directories

The Access Switches are set for all files and any subdirectories of a
selected directory; Individual files may be protected with DOS
attributes (such as Hidden, Archive, Read-Only, etc.)

USER DATA

The user data (statistics) portion of the screen displays static data
for:

* Full User Name
* Account Expiration Date (Last Date for User Access)
* Password Expiration Date (Last Day Password is Valid)
* Password Renewal Frequency (in days)
* Number of Concurrent Logins (maximum number of simultaneous
  workstation logons) *User Password *Time of Day Login (Access
  Limitations by Time of Day)

PRINTER PRIORITY

Each printer device available is assigned a priority for arbitration of
concurrent access requests from workstations.  Enter a number from 1 to
9; lower number means higher printer access priority.  A blank entry
indicates the printer is not available to this user.


6.2 NeOS CONFIGURATION AND MAINTENANCE

Select Network Administrator (configuration and maintenance) options
from the MISCELLANEOUS pulldown menu, including:

* Local Configuration
* Output Information
* Change Password
* Export Configuration
* Import Configuration
* Merge Configuration

Local Configuration dialogue offers the following choices:

* Station Name: Unit Name for network station (15 characters maximum)

* Network Printers: Actual number of printer/plotter devices to be used
  by the workstation, from 0-5;  Remember each printer connection takes
  1.5 Kbytes of RAM

* Message Beep: Number of beeps to be head when messages "arrive" at
  workstation

* Directories: Total number of network directories shared by all
  workstations.  Memory constraints for this should be considered.  For
  example:

  if 5 PC's are connected as workstations (nodes) on the NeOS network,
  each PC may share 10 directories.  The total directories = (5 x 10) +
  10 = 60 directories.  Each directory occupies 20 bytes of RAM, or 1.2
  Kbytes of RAM.

* Network Disk: NeOS Network Operating System views all shared network
  resources as directories of one (virtual) network disk.  The network
  disk drive may be lettered from D to Z.  Leaving the box blank will
  tell NeOS to assign the next available drive letter to the network
  disk.

* Max Files: Total number of (shared) files which may be open by all
  network users at a given time.  Set this to a number at least 20 more
  than the DOS "FILES =" command for the workstation.

* Network Time:  Number to arbitrate priority, or "time slice" for
  network resource access across the network.  Lower number gives less
  priority and slower performance on network.

* Printer Time: Portion of total workstation network CPU cycles
  dedicated to print sharing requests; "1" is recommended for dot
  matrix/streaming printers, and "3" for lasers and other page-format
  printers.  Stations not permitting printer sharing should be assigned
  "0".

* Station Time: Portion of total network bandwidth allocated to this
  workstation.  Lower number yields slower PC performance (One interval
  = 1/18 second)

* Output Information: Tells NeOS to write configuration information to
  a file in C:\NEOSINFO.  The configuration data may then also be
  printed from this file for system administrator record keeping for
  system restoration requirements.

* Change Password: Assign password for configuration file security.
  (Remember, passwords are case-sensitive).

* Export Configuration: Tells NeOS to write configuration information
  to a user-defined drive and path (other than C:\NEOSINFO).

* Import Configuration: Read export data into workstation.

* Merge Configuration: Permits joining (concatenation) of several
  configurations into one file; used to transfer functionality from one
  workstation to another when files are transferred.

6.3 RELATIONSHIP OF NeOS NETWARE and CONFIGURATION

Whenever a NeOS Configuration File is established or changed NeOS
should be logged off and restarted (by the command "NEOS" at the DOS
prompt), or the host workstation re-booted, for the changes to take
effect.

7.0 NET PROGRAM

The NET command may be entered at the DOS prompt, or from the Main
Menu with a pulldown menu.  The MAIL and MESSAGE functions are only
available from the menu; all other commands are available from both.
Entering "NET ?" at the command line will display a list of parameters.

Example:

C:\>net ?
Usage: NET [ LCD | command argument(s) ]

   HELP        LOGIN          LOGOUT
   PASSWORD    PRINTERS       STATE
   USER        DIRECTORY      ALL

Printer Control:
   PRINTER     CONTINUE  |  STOPNEXT  |  STOP  |  RESTART  |  CANCEL


The LCD switch controls colors for the menu interface. In the menu
system, the following pull-down menus are available:

* Mail - Sending and Viewing of Electronic Mail
* Message - Send and View Messages
* Network - Log onto NeOS, Logoff from NeOS, Change Password
* Information - Active Printers and Devices, Directories, General
  Network Status
* Miscellaneous - Printer Control, Port Status


7.1 NETWORK LOGIN

The NET LOGIN command is unique to the NeOS NOS.  NeOS Netware views
all workstations as equals ("peers").  The best way to understand LOGON
is through the following example:  John Smith, with nickname "Boss" and
password "JS" (passwords are case-sensitive), wants to log into the
NeOS system. He would type:

C:\>net login Boss

The computer will respond with:

Press CTRL-C to exit.
Enter Your Name: John Smith
Enter Your Password:

The remaining logon events are automatically handled by NeOS. The
computer display will show a list of the logon events as they occur.
For users to follow workstation activities in the network, the NeOS
Activity Log for the workstation may be displayed by entering
at the DOS prompt. For example:

C:\>net state
       Action             Station       Time   Result
___________________  ________________ ________ ___________
       Login            486DX2-66     19:39:08 OK
       Login            386SX-33      19:39:08 OK


In the third line a new station is listed.

Example:

C:\>net state
       Action             Station       Time   Result
___________________  ________________ ________ ___________
       Login            486DX2-66     19:39:08 OK
       Login            386SX-33      19:39:08 OK
       Login            286-12.5      19:39:30 Wrong Password


Here the user has attempted LOGON with an incorrect password.

Once successfully logged on, the user may view a list of the network
directories available for shared access.  No user access is permitted
to the network root directory, and the network disk root directory will
always show a size of 0 kB.

For example, enter the DIR command for the network drive at the DOS
prompt:

F:\>dir

 Volume in drive F is NeOS.NET
 Directory of F:\

DOCUMENT     <DIR>         05-16-94   7:37p
GEPCAT       <DIR>         05-16-94   7:37p
RELAX        <DIR>         05-16-94   7:37p
TEMPDIR      <DIR>         05-16-94   7:37p
UTILS        <DIR>         05-16-94   7:37p
	5 file(s)              0 bytes
			       0 bytes free

The volume name for the network drive is NeOS.NET.

If a workstation is powered down (or losses power) without formal
network logout, NeOS will automatically log the workstation off the
network and remove all shared directories.

Example:

C:\>net state
       Action             Station       Time   Result
___________________  ________________ ________ ___________
       Login            486DX2-66     19:39:08 OK
       Login            386SX-33      19:39:08 OK
       Login            286-12.5      19:39:30 Wrong Password
       Logout           286-12.5      19:39:30 Station Disappeared


The last line displays information about the forced logoff for that
workstation.  If the workstation is powered back up, NeOS will
automatically re-establish communication with the workstation, log back
on, and restore shared directory access.


7.2 NETWORK LOGOUT

Logoff the NeOS network using the NET LOGOUT command.  You may then
check the NeOS status by entering the NET STATE command. The following
message will be displayed:


C:\>net state
       Action             Station       Time   Result
___________________  ________________ ________ ___________
       Login            486DX2-66     19:39:08 OK
       Login            386SX-33      19:39:08 OK
       Login            286-12.5      19:39:30 Wrong Password
       Logout           286-12.5      19:40:18 Station Disappeared
       Logout           486DX2-66     19:50:13 OK
       Logout           386SX-33      19:50:13 OK


It is clear that the workstation identified as inactive was not logged
out.


7.3 CHANGING PASSWORD

When you set up the NeOS configuration, you assign a Password renewal
frequency which requires periodic change to user passwords.  This helps
ensure data integrity by reducing proliferation of passwords. Password
renewal is performed as follows:

F:\>NET PASSWORD

F:\>net password
Press CTRL-C to exit.
Enter Old Password :
Enter New Password :
Retype New Password :


The program will prompt you with questions.  The display of the
password text is hidden.  After entering the new password, enter NET
STATE at the DOS prompt:

F:\>net state
       Action             Station       Time   Result
___________________  ________________ ________ ___________
       Login            486DX2-80     19:49:32 OK
       Login            386SX-33      19:49:32 OK
  Change Password       486DX2-80     19:50:33 Change Is Not Allowed
  Change Password       386SX-33      19:50:33 Change Is Not Allowed


The last two lines of the status returned to the display show that
the password change was unsuccessful on all active network nodes because
old password was undefined. Remember, password must be defined with CONFIG
program for all nodes with user account.

Password is not changed for non-active nodes.


7.4 DIRECTORY ORIGIN

Information about the network directory origin may be displayed with
the NET DIRECTORY command. For example:

F:\>net directory DOCUMENT

Home Station of Directory:   386SX-33

Allowed Access:
 - Attribute change.
 - Create files.
 - Delete file.
 - Execute program.
 - Make directory.
 - Read from file.
 - Remove directory.
 - Rename file.
 - Write to file.

7.5 USER CONTROL

Enter the command NET USER to display current on the network.

F:\>net user

 1. Smith is logged on station 486DX2-80 (locally).
 2. Igor is logged on station 386SX-33.


7.6 NETWORK PRINTERS

The NET program controls the network printers; network printer status
may be checked by using the following command:

F:\>net printers

1. PRINTER shared by network station 486DX2-80.

The DOS COPY command is used for printing on network printers.

F:\>COPY C:\AUTOEXEC.BAT PRINTER
1 file(s) copied

The network printer identified by NeOS as "PRINTER" will start printing;
ensure that the destination printer is online and ready to print (paper
loaded, etc.)


7.6.1 PRINTER CONTROL

Network printer control is permitted from the MISCELLANEOUS pulldown
menu, as well as printer status and users.  A list of users may be
displayed by use of the STATE OF PORT command.  Printer control may be
performed with these subcommands:

* CONTINUE
* STOPNEXT terminates printing after current document is finished
* STOP
* RESTART
* CANCEL

NOTE: Printers with buffers will continue to print after STOP command
is given until  buffers memory is cleared.


7.7 MAIL and MESSAGE

NeOS Mail and Message sending and receiving are possible in menu mode
only.


7.7.1 SENDING MESSAGES

Mail may be sent to all active NeOS nodes in a broadcast mode.
Messages, however, may only be sent  to specified user(s) (as described
in the CONFIG section).  The MESSAGE menu has options for message
sending to one or several nodes, or to all active nodes.

Messages should be entered into the box provided  box, then sent by
pressing the F2 key.


7.7.2 MESSAGE RECEIVING

Arrival of a message at the workstation node is signaled by beeps
(previously set in CONFIG).  Mail arrival will not be signaled with
beeps.  The VIEW Command will display contents of new messages and/or
mail.

NOTE: All mail is retained by the workstation.  Messages are only
retained until the workstation user logs off of NeOS.

8. NeOS AND POPULAR PROGRAMS

* Thrid-party Memory Managers
* Non-MS-DOS Operating Systems
* DISK Cache Programs
* Disk Maintenance Utilities
* Computer Games


8.1 MEMORY MANAGERS

Memory managers (QEMM386, EMM386, QMAX) that are correctly installed
should not conflict with the NeOS drivers installed on each
workstation. If there are any conflicts, disable the memory manager
software. You may try loading the NeOS TSR
(Terminate-and-Stay-Resident) driver into High Memory (HMA), however,
it is preferred to load infrequently accessed TSR's into this area
(such as DOS COMMAND.COM and Pop-Up TSR's). If there any conflicts,
you must experiment.

8.2 NON MS-DOS OPERATING SYSTEMS

Windows may only be utilized with NeOS when installed as a
client/server setup. On the network node selected as the server (which
should share the WINDOWS directory ), Windows is installed with
parameter "SETUP/A", which will copy all Windows systems files to the
"server".  On this same node, SMARTDRV /X should be included in the
AUTOEXEC.BAT file.  All other (client) nodes should install Windows
with the SETUP /N switch included, and set the Windows directory as a
shared NeOS directory.

Although not certified for other (non-MS-DOS) PC-compatible Operating
Systems, such as DR-DOS or NOVELL DOS, or DOS emulators running under
OS/2, Windows NT or UNIX, NeOS may run with various results.  All NeOS
features may not be available under these operating systems, or
depending upon the level of binary granularity or BIOS compatibility,
NeOS may not function at all. IBM PC-DOS up through version 6.1 will
run NeOS Netware successfully, but Microsoft and IBM DOS compatibility
is subject to change as of this publication.


8.3 DISK-CACHING PROGRAMS

NeOS uses the Microsoft MS-DOS programs SMARTDRV.SYS  provided with
MS-DOS version 5.0 or SMARTDRV.EXE provided with MS-DOS 6.0 and 6.2).
Other caching programs, such as Norton Disk Cache or PC-Kwik, are not
certified for use with NeOS NOS and may give varying results.

Caching programs may only be installed on PC's with more than 1 Mb RAM;
at least 0.5 Mb is recommended, and usually a 1.5 mB maximum is enough
for most applications.  Disk caching can increase network efficiency up
to 10 times (depending upon the type of workstations connected.
NOTE: If you set your caching program with "delayed writeback" or
"write-behind",  (for SmartDrive, the "/+" switch), ensure that the
cache has completed writing to the target drive before powering down or
re-booting the workstation.


8.4 DISK UTILITIES

NOTE: Disk Optimization, Defragmentation and other maintenance
utilities such as CHKDSK, SPEEDISK, DS (directory sort), or Norton Disk
Doctor should be used when the workstation is logged off  and
disconnected from the NeOS network.

Use of disk compression software such as Stacker, Superstore, or MS-DOS
6.0 DoubleStore is permitted, and NeOS can address these files as
virtual drives.  The compression program will load a device driver to
remap the drive letters, and this will change the drive the network
assigns to the devices on the workstation, as well as the LASTDRIVE=
flag for DOS to assign the network drives.  This advice also applies to
CD-ROM, tape backup devices, and removable disk drives connected to be
shared from any of the network nodes.  The installation programs for
these devices will normally modify your CONFIG.SYS and AUTOEXEC.BAT
files automatically; you may wish to view and edit these files to
ensure that the NeOS network driver loads AFTER other drivers to
recognize all virtual devices with the correct drive letter.

8.5 COMPUTER GAMES

NOTE: Do not load and run any type of computer games during network
activity on the node.   Games are resource-intensive for PC's and, if
run on the workstation assigned the highest network priority (for
allocation of NOS bandwidth and CPU cycles) can slow the overall
network performance substantially.  Games also utilize computer
resources in unpredictable ways, such as switching CPU speed to match
bus speed and occupying areas of memory (especially UMB's) that could
conflict with the NeOS programs.


9.0 WORKING WITH NeOS

A NeOS network node can function in two different ways, as a
single-task or multi-task system.  When multiple users are threading
multiple tasks through the network, workstations, and shared devices,
computing resource contention and arbitration will slow apparent system
performance.  This load is limited not only by the NeOS bandwidth
(which is a fixed resource) but also by each shared device's (disk,
printer, etc.) speed and CPU speed of the network workstations.


9.1 NETWORK SESSION TERMINATION

Before the NeOS Network session is terminated and PC(s) are turned off,
each node should be properly logged off and disconnected from the NeOS
network.

NOTE: never turn off your computer before the node is logged off and
disconnected from the NeOS network.

In the event of AC power loss or accidental PC powerdown, refer to
Section 7.2, "Network Logout".  Remember, there are two preferred ways
of network disconnection:

* NET SHUTDOWN command from command line
* NeOS - as previously described (see 4.1)

9.2 PAUSE KEY

The NeOS node may be "paused", or suspended, by pressing the PAUSE key
once  to pause node operation, and pressing again to resume node
operation.

APPENDIX A. TROUBLESHOOTING

If installation appears to proceed normally but there is a problem in
using NeOS, check the following problems and possible solutions.

1. NeOS does not connect on PC bootup (No "F" or network drive
   available)

* Check network adapter board and hardware installation on your PC
* Check coaxial cable connection to your PC
* Check software installation; reinstall if necessary
* Ensure correct commands have been added to AUTOEXEC.BAT and
  CONFIG.SYS files
* Ensure the "LASTDRIVE=?" statement is included in the CONFIG.SYS
* Reboot computer and watch for aborted CONFIG.SYS or AUTOEXEC.BAT
  statements.  If using MS-DOS 6.x, select the CONFIG and AUTOEXEC
  "walk-through" options and reboot.


2. Network drive is identified, but NeOS does not start on NEOS command

* Check PATH command for NEOS.NET directory or change to NEOS.NET
  directory; enter NEOS command again
* Check software installation; reinstall if necessary
* Incorrect Interrupt assignment; reset DIP switches or change
  interrupt in software as per network adapter manufacturer
  instructions.
* Assignment of invalid address during network adapter initialization.

3. NeOS Network starts, but NET STATE command shows no connection to
   (an)other workstations or query on network drive shows only
   directories from your PC, or shows empty network disk.

* Check network adapter board and hardware installation on other
  network PC(s).
* Check coaxial cable connection to other network PC(s)
* Check your password authorization for the disk or directories on the
  network.
* Increase FILES= statement in CONFIG.SYS file, reboot computer
* Ensure the SHARE statement is included in the AUTOEXEC.BAT file;
  reboot computer

4. Printer performance is poor

* Adjust Printer Priority higher for the printer in NeOS CONFIG menu
* Adjust Printer Time from CONFIG menu
* Increase the buffer size for the printer.

5. One workstation shows poor performance or network performance seems
   poor

* Increase "NETWORK TIME" and "STATION TIME" parameters in CONFIG for
  the node
* Consider moving frequently accessed files or shared devices
  to another, faster PC on the network or spreading these files/devices
  to several other nodes.
