/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       sdm.h
**     SYSTEM   NAME:       BEHOLDER
**     ORIGINAL AUTHOR(S):  Dirk Wisse
**     VERSION  NUMBER:     1.0
**     CREATION DATE:       1991/3/25
**
** DESCRIPTION: 
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision$
** WORKFILE:    $Workfile$
** LOGINFO:     $Log$
*************************************************************************/
#ifndef SDM
#define SDM
#include <dnpap.h>


#define SDM_MASK_SRC    0x01
#define SDM_MASK_DST    0x02
#define SDM_MASK_CONN   0x04


typedef struct _SDM_CONN
{
    int     Host;
    int     Next;
}
    SDM_CONN;

typedef struct _SDM_HOST
{
    int     Conn;
    int     Next;
}
    SDM_HOST;
    
typedef struct _SDM_HASH
{
    int     Host;
    int     Next;
}
    SDM_HASH;    

typedef struct _SDM_CONN_DATA
{
    void    *Conn;
    void    *Src;
    void    *Dst;
}
    SDM_CONN_DATA;    
    
    
typedef struct _SDM_MATRIX
{
    int         AddrSize;
    int         HashCount;
    SDM_HASH    *HashLink;
    int         HashOver;
    int         HashFree;
    int         HostSize;
    int         HostCount;
    SDM_HOST    *HostLink;
    BYTE        *HostData;
    int         HostFree;
    int         HostUsed;
    int         ConnSize;
    int         ConnCount;
    SDM_CONN    *ConnLink;
    BYTE        *ConnData;
    int         ConnFree;
}
    SDM_MATRIX;

SDM_MATRIX *SdmCreate
            (
                WORD AddrSize,
                WORD HostSize,
                WORD ConnSize,
                WORD HostCount,
                WORD ConnCount,
                WORD HashCount,
                WORD HashOver
            );
void SdmRemove(SDM_MATRIX *Matrix);
void SdmClear(SDM_MATRIX *Matrix);
int SdmHash(SDM_MATRIX *Matrix, BYTE *Addr);
void *SdmGetHost(SDM_MATRIX *Matrix, BYTE *Addr);
void *SdmFirstHost(SDM_MATRIX *Matrix);
void *SdmNextHost(SDM_MATRIX *Matrix, BYTE *Addr);
void *SdmCreateHost(SDM_MATRIX *Matrix, BYTE *Addr, int *New);
SDM_CONN_DATA *SdmGetConn(SDM_MATRIX *Matrix, BYTE *SrcAddr, BYTE *DstAddr);
SDM_CONN_DATA *SdmFirstConn(SDM_MATRIX *Matrix);
SDM_CONN_DATA *SdmNextConn(SDM_MATRIX *Matrix, BYTE *SrcAddr, BYTE *DstAddr);
SDM_CONN_DATA *SdmCreateConn(SDM_MATRIX *Matrix, BYTE *SrcAddr, BYTE *DstAddr, int *New);
#endif
