/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       PING.C
**     SYSTEM   NAME:       IP
**     ORIGINAL AUTHOR(S):  Wim van Campen
**     VERSION  NUMBER:     v1.00
**     CREATION DATE:       1990/7/30
**
** DESCRIPTION: DP application file for the Ping implementation
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   PING.C  $
** LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/BAPS/PING/VCS/PING.C_V  $
**              
**                 Rev 1.0   01 Feb 1991 15:11:42   etstjan
**              No explicit note
**              
**                 Rev 1.1   21 Nov 1990 14:56:22   etstjan
**              No explicit note
**              
**                 Rev 1.0   21 Nov 1990 13:06:10   etstjan
**              No explicit note
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header:   I:/ETSTJAN/CPROG/BEHOLDER/BAPS/PING/VCS/PING.C_V   1.0   01 Feb 1991 15:11:42   etstjan  $";
#endif
#include        <stdio.h>           /* for NULL                          */
#include        <string.h>
#include        <ctype.h>           /* isdigit, isalnum                  */
#include        <power3.h>          /* for POWER screen functions        */
#include        <beholder.h>

/* ugly includes needed for prototypes ! */
#include      "..\..\udpip\include\ip.h"      
#include      "..\..\udpip\include\ipcodes.h" 
#include      "..\..\udpip\include\iplib.h"   

/* prototyping of static functions                                          */
static int  ProcessEvents(DPEVENT Event);
static void EverySecond(void);
static void FreeTime(void);
static void PingStart(void);           /* Ping application start            */
static void PingStop(void);            /* Ping application stop             */
static void ProcPingMenu(void);        /* Ping keypressed handler           */
static void InitPing(void);

#define  WAITTIME    15                /* wait up to 15 seconds for resp.   */ 

typedef enum {                         /* Ping application menu state       */
          CLOSED,                      /* menu closed                       */
          MENUWAIT,                    /* waiting in menu                   */
          WAITREPLY,                   /* waiting for reply                 */
          WINWAIT,                     /* waiting with window opened        */
          TIMEDOUT                     /* time out on waiting for reply     */
          } PINGAPPSTATE;

PWWIN *PingWin;                        /* Ping messages window pointer      */
PWWIN *PingMenuWin;                    /* Ping applications menu window     */
PWWIN *PingUserWin;                    /* Ping application window pointer   */ 
PWWIN *PingOptWin;                     /* Ping received options window      */

PINGAPPSTATE  PingAppSt = CLOSED;      /* Ping application state            */

DPAPPS DpaPing = {
    "Send Ping",                            /* Application name             */
    ProcessEvents,                          /* Event processing function    */
    0,                                      /* Status, must be 0            */
    DPE_FREETIME | DPE_EVERYSECOND | DPE_START | DPE_KEYPRESSED |
                   DPE_STOP | DPE_INIT | DPE_RESET,
    DPE_START,
    0,
    -1,
    0,
    0,
    0,
    0,                                      /* Count of active filters      */
    {0}                                     /* List of active Filters       */
    };

static char *PingMenu[] = {
    "0 - dutepp0",
    "1 - dutepp1",
    "2 - dutepp4",
    "3 - dutepp6",
    "4 - dutepp7",
    "5 - dutepp8",
    "6 - dutepp9",
    "7 - dutepp10",
    "8 - dutepp16",
    "9 - hdetud1",
    "A - hdetud11",
    "B - anton",
    "C - dutrsps",
    "D - gatekeeper",
    NULL
    };

static ULONG PingAddresses[] = {
    0x82a19041l,
    0x82a19042l,
    0x82a19045l,
    0x82a190abl,
    0x82a190acl,
    0x82a190adl,
    0x82a190ael,
    0x82a190afl,
    0x82a190b5l,
    0x82a1b409l,
    0x82a19013l,
    0x839b0233l,   
    0x82a1b406l,
    0x10010002l
    };

SOCKET              PingSock;
USHORT              NrElem = sizeof(PingAddresses) / sizeof(ULONG);
USHORT              TimeOut;
BYTE                PingPacket[108];
BYTE                RecPacket[200];
BYTE                OptSpace[40] = "\x07\x27\x04";
int                 OptWinOpen = 0;
struct sockaddr_in  SockAddr = {
                      AF_INET
                      };
USHORT              SeqNr = 0;

/**************************************************************
** NAME:        ProcessEvents
** SYNOPSIS:    static int ProcessEvents(DPEVENTS Event);
**
** DESCRIPTION: Processes dispatcher events.
**
** RETURNS:     0 -->   no error
**              else    error code
**************************************************************/
static int ProcessEvents(DPEVENT Event)
{
    int ret = 0;

    switch (Event)
    {
    case DPE_EVERYSECOND:   EverySecond();    break;
    case DPE_START:         PingStart();      break;
    case DPE_STOP:          PingStop();       break;
    case DPE_FREETIME:      FreeTime();       break;
    case DPE_KEYPRESSED:    ProcPingMenu();   break;
    case DPE_INIT:          InitPing();       break;
    case DPE_RESET:         SeqNr = 0;        break;
    }
    return ret;
}

/**************************************************************
** NAME:        InitPing
** SYNOPSIS:    static void InitPing(void);
**           
** DESCRIPTION: Initializes Ping.
** RETURNS:  
**************************************************************/
static void InitPing(void)
{
  int   i;

  for (i = 8; i < 108; PingPacket[i] = (BYTE)(i++))
    ;
}
                            
/**************************************************************
** NAME:        EverySecond
** SYNOPSIS:    static void EverySecond(void);
**  
** DESCRIPTION: Handles the Dispatcher EverySecond Event.
** RETURNS: 
**************************************************************/
static void EverySecond(void)
{
  if ((PingAppSt == WAITREPLY) && (--TimeOut == 0)) {
    PingAppSt = TIMEDOUT;
    }
  return;
}

/**************************************************************
** NAME:        FreeTime
** SYNOPSIS:    static void FreeTime(void);
** 
** DESCRIPTION: Handles the reception of Ping Reply packets,
**              if waiting for a reply.
** RETURNS:  
**************************************************************/
static void FreeTime(void)
{
  int      RetCode;
  USHORT   OffSet, i, j;

  switch (PingAppSt) {
    case WAITREPLY:
      if ((RetCode = recv(PingSock, RecPacket, 200, 0)) < 0) {
        if (RetCode != NOMESSAGE) {
            pw_cursor(PingUserWin, 4, 0);
            pw_printf(PingUserWin, "Error in receiving packet. Code: %d", RetCode);
          }
        return;
        }
      else {
        OffSet = (*RecPacket & 0x0f) * 4;
        if (*(USHORT *)(RecPacket + OffSet) != 0) {
          pw_cursor(PingUserWin, 4, 0);
          pw_printf(PingUserWin, "Packet with other Type / Code: 0x%02x / 0x%02x.",
                                 (int)*(RecPacket + OffSet),
                                 (int)*(RecPacket + 1 + OffSet));
          return;
          }
        else {
          if (*(USHORT *)(RecPacket + 6 + OffSet) != htons(SeqNr)) {
            pw_cursor(PingUserWin, 1, 0);
            pw_printf(PingUserWin, "\nPacket with wrong Sequence Number.");
            }
          else {
            if (memcmp(RecPacket + 8 + OffSet, PingPacket + 8, 100)) {
              pw_cursor(PingUserWin, 1, 0);
              pw_printf(PingUserWin, "\nPacket with wrong Data.");
              }
            else {
              pw_cursor(PingUserWin, 1, 0);
              pw_printf(PingUserWin, "Response Received!. Sequence Number: %u",
                                      SeqNr);
              pw_printf(PingUserWin, "\nPacket Length: %d bytes                 ",
                                      RetCode);
              pw_printf(PingUserWin, "\nDelay time: %lu mSec.              ",
                                      TimeMilSec() - *(ULONG *)(RecPacket + 8 + OffSet));
              if ((PingOptWin = pw_open(12, 31, 5, 46, "Recorded Route",
                                        PWM_DEFAULT, PWW_DATA)) != NULL) {
                OptWinOpen = 1;
                if ((OffSet > 20) && (RecPacket[20] == 0x7)) {
                  for (i = 23, j = 0; i < (20u + RecPacket[21]); i += 4, j++) {
                    pw_cursor(PingOptWin, j / 2, (j % 2) * 23);
                    pw_puts(PingOptWin, inet_ntoa(*(ULONG *)(RecPacket + i)));
                    }
                  }
                }
              }
            }
          }
        }
      pw_cursor(PingUserWin, 5, 0);
      pw_printf(PingUserWin, "Press key to continue....");
      PingAppSt = WINWAIT;
      break;

    case TIMEDOUT:
      pw_cursor(PingUserWin, 1, 0);
      pw_printf(PingUserWin, "Response time exceeded.          ");
      pw_cursor(PingUserWin, 5, 0);
      pw_printf(PingUserWin, "Press key to continue....");
      PingAppSt = WINWAIT;
      break;
    }
}

/**************************************************************
** NAME:        PingStart
** SYNOPSIS:    static void PingStart(void);
**           
** DESCRIPTION: Presents a Ping Selection Menu to the user.
** RETURNS:  
**************************************************************/
static void PingStart(void)
{
  int   i;

  if (PingAppSt == CLOSED) {
    if ((PingMenuWin = pw_open(4, 30, NrElem, 15, "Ping Choices",
                               PWM_DEFAULT, PWW_MENU)) == NULL) {
      return;
      }
    for (i = 0; PingMenu[i] != NULL; i++) {
      pw_cursor(PingMenuWin, i, 0);
      pw_putcell(PingMenuWin, PingMenu[i][0], PWT_HIGHLIGHT);
      pw_puts(PingMenuWin, PingMenu[i] + 1);
      }
    pw_keyinfo(PingMenuWin, " TAB  -->  Select Input Window",
                            "Choose Highlighted Item ");      
    PingAppSt = MENUWAIT;
    }
}

/**************************************************************
** NAME:        PingStop
** SYNOPSIS:    static void PingStop(void);
**           
** DESCRIPTION: Removes the Ping Selection Menu.
** RETURNS:  
**************************************************************/
static void PingStop(void)
{
  switch (PingAppSt) {
    case WAITREPLY:
      closesocket(PingSock);
    case WINWAIT:
      pw_close(PingUserWin);
      if (OptWinOpen) {
        pw_close(PingOptWin);
        OptWinOpen = 0;
        }
    case MENUWAIT:
      pw_close(PingMenuWin);
      PingAppSt = CLOSED;
      }
}

/**************************************************************
** NAME:        ProcPingMenu
** SYNOPSIS:    static void ProcPingMenu(void);
** 
** DESCRIPTION: Handles the Ping keypressed event.
** RETURNS:     
**************************************************************/
static void ProcPingMenu(void)
{
  PWKEY       InKey;
  ULONG   DestinAdd;
  int         RetCode;
  int         OptLen = 39;

  InKey = DpGetKey();

  switch (PingAppSt) {
    case CLOSED:
      break;

    case MENUWAIT :
      if (isdigit(InKey)) 
        InKey -= '0';
      else
        if (isalnum(InKey)) {
          InKey = toupper(InKey);
          InKey -= ('A' - 10);
          }
        else
          break;

      if ((InKey >= 0) && (InKey <= (NrElem - 1))) {
        DestinAdd = htonl(PingAddresses[InKey]);
        if ((PingUserWin = pw_open(5, 31, 6, 46, "Ping Request",
                                   PWM_DEFAULT, PWW_DATA)) == NULL) {
          return;
          }
        pw_printf(PingUserWin, "Ping to: %s  (", PingMenu[InKey] + 4);
        pw_puts(PingUserWin, inet_ntoa(DestinAdd));
        pw_printf(PingUserWin, ")");
        if ((PingSock = socket(AF_INET, SOCK_RAW, 0)) == NULL) {
          pw_printf(PingUserWin, "\nError in opening socket.");
          pw_cursor(PingUserWin, 5, 0);
          pw_printf(PingUserWin, "Press key to continue....");
          PingAppSt = WINWAIT;
          return;
          }
        if (setsockopt(PingSock, 0, IP_OPTIONS, OptSpace, OptLen) != NOERR) {
          pw_printf(PingUserWin, "\nError in setsockopt.");
          pw_cursor(PingUserWin, 5, 0);
          pw_printf(PingUserWin, "Press key to continue....");
          PingAppSt = WINWAIT;
          return;
          }
        SockAddr.sin_port = htons(ICMP);
        SockAddr.sin_addr.s_addr = INADDR_ANY;
        if ((RetCode = bind(PingSock, (struct sockaddr *)&SockAddr,
                            sizeof(SockAddr))) != NOERR) {
          pw_printf(PingUserWin, "\nError in binding socket. Code: %d", RetCode);
          pw_cursor(PingUserWin, 5, 0);
          pw_printf(PingUserWin, "Press key to continue....");
          PingAppSt = WINWAIT;
          return;
          }
        SockAddr.sin_port = htons(ICMP);
        SockAddr.sin_addr.s_addr = DestinAdd;
        if ((RetCode = connect(PingSock, (struct sockaddr *)&SockAddr,
                               sizeof(SockAddr))) != NOERR) {
          pw_printf(PingUserWin, "\nError in connecting socket. Code: %d", RetCode);
          pw_cursor(PingUserWin, 5, 0);
          pw_printf(PingUserWin, "Press key to continue....");
          PingAppSt = WINWAIT;
          return;
          }
        PingPacket[0] = 8;                    /* echo request         */
        PingPacket[1] = 0;                    /* code = 0             */
        *(USHORT *)(PingPacket + 2) = 0;      /* clear checksum space */
        *(USHORT *)(PingPacket + 4) = 0;      /* identifier = 0       */
                                              /* set sequence number  */
        *(USHORT *)(PingPacket + 6) = htons(++SeqNr);
        *(ULONG *)(PingPacket + 8) = TimeMilSec();
        *(USHORT *)(PingPacket + 2) = CompCheck(PingPacket, 108);
        if ((RetCode = send(PingSock, PingPacket, 108, 0)) != NOERR) {
          pw_printf(PingUserWin, "\nError in sending packet. Code: %d", RetCode);
          pw_cursor(PingUserWin, 5, 0);
          pw_printf(PingUserWin, "Press key to continue....");
          PingAppSt = WINWAIT;
          return;
          }
        pw_printf(PingUserWin, "\nWaiting... (<Q> for quit)");
        TimeOut = WAITTIME;
        PingAppSt = WAITREPLY;
        };
      break;

    case WINWAIT:
      pw_close(PingUserWin);
      if (OptWinOpen) {
        pw_close(PingOptWin);
        OptWinOpen = 0;
        }
      if (PingSock != NULL) {
        closesocket(PingSock);
        }
      PingAppSt = MENUWAIT;
      break;

    case WAITREPLY:
      if ((InKey == 'Q') || (InKey == 'q')) {
        pw_close(PingUserWin);
        closesocket(PingSock);
        PingAppSt = MENUWAIT;
        }
      break;
    }
}

