/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       disp.c
**     SYSTEM   NAME:       BEHOLDER
**     ORIGINAL AUTHOR(S):  Dirk Wisse
**     VERSION  NUMBER:     1
**     CREATION DATE:       1991/1/14
**
** DESCRIPTION: 
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   DISP.C  $
** LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/BAPS/DISP/VCS/DISP.C_V  $
**              
**                 Rev 1.0   31 Jan 1991 16:47:02   etstjan
**              No explicit note
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header:   I:/ETSTJAN/CPROG/BEHOLDER/BAPS/DISP/VCS/DISP.C_V   1.0   31 Jan 1991 16:47:02   etstjan  $";
#endif

#define IPS_DOS

#include <stdlib.h>
#include <stdio.h>
#include <beholder.h>
#include <power3.h>
#include <bufm.h>
#include <snmp.h>
#include <mib2.h>
#include <dp.h>
#include <futil.h>
#include <ml.h>
#include <mat.h>      
#include <error.h>


#define DISPGETHOST       1,3,6,1,4,1,99,2,4,1
#define DISPGETHOSTLEN    10 
#define DISPGETCONN       1,3,6,1,4,1,99,2,5,1
#define DISPGETCONNLEN    10 
#define DISPSETOJI        1,3,6,1,4,1,99,2,6,0
#define DISPSETOJILEN     9 


typedef struct _DISP_DATA
{
    MAT_HOST        *Src;
    MAT_HOST        *Dst;
    MAT_CONN        *Conn;
    unsigned long    Promille;
    unsigned         Next;
}   DISP_DATA;
#define DISP_LEN 10   


static int  ProcessEvent (DPEVENT Event);
static void Init (void);
static void ReceivePkt (void);
static void Reset (void);
static void Start (void);
static void Stop (void);
static void FreeTime (void);
static void Show (void);
static void Hide (void);
static void KeyPressed (void);
static void Timer (void);

static unsigned DispGetConn(pkt_obj *Obj, void *Arg);
static unsigned DispNxtConn(pkt_obj *Obj, void *Arg);
static unsigned DispGetHost(pkt_obj *Obj, void *Arg);
static unsigned DispNxtHost(pkt_obj *Obj, void *Arg);
static unsigned DispSet(pkt_obj *Obj, void *Arg);

static int              DispInit=0;
static int              DispVisible=0;
static int              DispDevFocus=0;
static unsigned         DispDevCount;
static unsigned         DispApps;
PWWIN                   *DispWinTop;


DPAPPS DpaDisp = {
    "Display",
    ProcessEvent,
    0,                                     
    DPE_START | DPE_STOP | DPE_RESET | DPE_SHOW | DPE_HIDE | DPE_KEYPRESSED | DPE_INIT,
    DPE_START | DPE_SHOW,
    DPE_RESET,
    5000,
    0,
    0,
    0,
    0,                                      /* Count of active filters      */
    {0}                                     /* List of active Filters       */
};



static int ProcessEvent (DPEVENT Event)
{
    switch (Event)
    {
        case DPE_INIT:          Init ();        break;
        case DPE_RESET:         Reset ();       break;
        case DPE_START:         Start ();       break;
        case DPE_STOP:          Stop ();        break;
        case DPE_SHOW:          Show ();        break;
        case DPE_HIDE:          Hide ();        break;
        case DPE_KEYPRESSED:    KeyPressed ();  break;
    }
    return 0;
}



static void KeyPressed (void)
{
    unsigned Dev = DpGetKey () - '0';

    if (Dev >= (unsigned) DispDevCount)
        return;
    if (MatSdm[Dev]==NULL)
        return;
    DispDevFocus = Dev;
    if (!DispVisible)
        return;
    Hide ();
    Show ();
}

static void Show (void)
{
    if (!DispVisible)
    {
        DispWinTop = pw_open (2, 1, DISP_LEN, 41, "Hall of Fame", PWM_NOSHADE, PWW_NORMAL);
        pw_printfat (DispWinTop, DISP_LEN, 0, "");
        pw_printfat (DispWinTop, -1      , 0, "SourceDestinationPerc");
        DispVisible=1;                                          
    }
    return;
}

static void Hide (void)
{
    if (DispVisible)
    {
        pw_close(DispWinTop);
        DispVisible=0;
    }
    return;
}


static void Reset (void)
{
    int             Ind, Lin, First, *Ptr;
    DISP_DATA       Top[DISP_LEN];
    SDM_CONN_DATA   *Conn;
    MAT_CONN        *Data;
    unsigned long   Bits, Promille;
    BYTE            *Src, *Dst;
    unsigned long   Time;

    if (MatSdm[DispDevFocus]==NULL)
        return;
    if (!DispVisible)
        return;
    First=0;
    for (Ind=0;Ind<DISP_LEN;Ind++)
    {
        Top[Ind].Promille=0;
        Top[Ind].Next=Ind+1;
    }
    Top[DISP_LEN-1].Next=-1;
    Time=DpAppsGetTimer(DispApps);
    if ((Conn=SdmFirstConn(MatSdm[DispDevFocus]))!=NULL)
    {
        while (Conn!=NULL)
        {
            Data=(MAT_CONN *)(Conn->Conn);
            Src=(BYTE *)(Conn->Src);
            Dst=(BYTE *)(Conn->Dst);
            Bits=Data->Packets*96 + Data->Bytes*8;
            Promille=(Bits-Data->Bits)/Time;
            Data->Bits=Bits;
            if (Promille>Top[First].Promille)
            {
                Top[First].Promille=Promille;
                Top[First].Conn=Conn->Conn;
                Top[First].Src=Conn->Src;
                Top[First].Dst=Conn->Dst;
                Ptr=&(Top[First].Next);
                while (*Ptr>=0)
                {
                    if (Promille<Top[*Ptr].Promille)
                        break;
                    Ptr=&(Top[*Ptr].Next);
                }
                if (Ptr!=&(Top[First].Next))
                {
                    Ind=First;
                    First=Top[Ind].Next;
                    Top[Ind].Next=*Ptr;
                    *Ptr=Ind;
                }
            }
            Conn=SdmNextConn(MatSdm[DispDevFocus],Conn->Src,Conn->Dst);
        }
    }
    Ind=First;
    for (Lin=DISP_LEN-1;Lin>=0;Lin--)
    {
        Src=(BYTE *)(Top[Ind].Src);
        Dst=(BYTE *)(Top[Ind].Dst);
        Data=Top[Ind].Conn;
        Promille=Top[Ind].Promille;
        if (Promille)
        {
            pw_printfat(DispWinTop,Lin,0,"%02x:%02x:%02x:%02x:%02x:%02x%02x:%02x:%02x:%02x:%02x:%02x",
            Src[0],Src[1],Src[2],Src[3],Src[4],Src[5],
            Dst[0],Dst[1],Dst[2],Dst[3],Dst[4],Dst[5]);
            pw_printfat(DispWinTop,Lin,35,"%2lu.%02lu",Promille/100, Promille%100);
        }
        else
        {
            pw_printfat(DispWinTop,Lin,0,"                                       ");
        }
        Ind=Top[Ind].Next;
    }
}


static void Init (void)
{
    DispDevCount = DpDevGetCount();
    DispApps = DpAppsGetApps("Display");
}

static void Start (void)
{
    return;
}

static void Stop (void)
{
    return;
}



