     NAME DOS_DRV
     PAGE 55,80
     TITLE DOS_DRV.ASM      Assembly interface for a 'C' device driver

;--------------------------------------------------------------
; An assembly interface between the MS-DOS device driver system
; and a C code device driver (see DOS_DEV.C for skeleton code)
;
; $Revision:   1.1  $
; $Author:   Phlash  $
; $Date:   07 Oct 1994 20:58:12  $
;
; C code routines must conform to this calling interface:
;
; int near function(void);
;
; return value is a status word (eg: 0x8003 = unknown command)
;
; The data segment contains two pointers, one to the device
; header, the other to the request header from DOS
;--------------------------------------------------------------

; Some miscellaneous constants

MaxCmd     equ 14              ;DOS 3.0 compatible driver

; Fudge for Microsoft C

__acrtused equ 0
public __acrtused

; Group assertion

DGROUP     GROUP _DATA,CONST,_BSS

; The code segment for C code

_TEXT      SEGMENT WORD PUBLIC 'CODE'

           ASSUME CS:_TEXT,DS:DGROUP,ES:NOTHING

; Start at offset zero in this segment.
           ORG 0h

; First thing in a DOS device driver must be the device header.
DHdr   dd    -1         ;link to next device driver
       dw    0C800h     ;character device with open/close/ioctl support
       dw    Strat      ;strategy routine entry point
       dw    Intr       ;interrupt routine entry point
       db    'DOS_DRV ' ;logical device name (Init() should set this)

;External 'C' function jump table
JumpTab:
       extrn _Init:near
       dw    _Init       ;0 = Initialize driver
       extrn _MediaChk:near
       dw    _MediaChk   ;1 = Media check
       extrn _BuildBPB:near
       dw    _BuildBPB   ;2 = Build BPB
       extrn _IoctlRd:near
       dw    _IoctlRd    ;3 = IOCTL Read
       extrn _Read:near
       dw    _Read       ;4 = Read device
       extrn _NdRead:near
       dw    _NdRead     ;5 = Non-destructive read from device
       extrn _InpStat:near
       dw    _InpStat    ;6 = Input status
       extrn _InpFlush:near
       dw    _InpFlush   ;7 = Flush input buffers
       extrn _Write:near
       dw    _Write      ;8 = Write device
       extrn _WriteVfy:near
       dw    _WriteVfy   ;9 = Write with verify
       extrn _OutStat:near
       dw    _OutStat    ;10 = Output status
       extrn _OutFlush:near
       dw    _OutFlush   ;11 = Flush output buffers
       extrn _IoctlWt:near
       dw    _IoctlWt    ;12 = IOCTL Write
       extrn _DevOpen:near
       dw    _DevOpen    ;13 = Device Open
       extrn _DevClose:near
       dw    _DevClose   ;14 = Device Close

       extrn _Unknown:near ;Handler for unknown command codes

;-------------------------------------------------------------
; Set up DS = DGROUP
;-------------------------------------------------------------
public _SetDS
_SetDS    proc   near
          push ax
          push cx
          pushf
          mov ax,offset _TEXT:Ident
          mov cx,4
          shr ax,cl
          mov cx,cs
          add ax,cx
          mov ds,ax
          popf
          pop cx
          pop ax
          ret
_SetDS    endp

;-------------------------------------------------------------
; Driver Strategy routine, stores request for later
;-------------------------------------------------------------

Strat  proc  far        ;device driver strategy routine,
                        ;called by MS-DOS with
                        ;ES:BX = address of request header

       push  ds         ;set DS = DGROUP 
       call  _SetDS

       mov   word ptr [_RHPtr],bx    ;save the request header
       mov   word ptr [_RHPtr+2],es

       mov   word ptr [_DHPtr],offset DHdr  ;save the device header
       mov   word ptr [_DHPtr+2],cs

       pop   ds
       ret

Strat  endp


;-------------------------------------------------------------
; Driver Interrupt routine, implements request
;-------------------------------------------------------------

Intr   proc  far        ;device driver interrupt routine,
                        ;called by MS-DOS after strategy routine

                        ;save general registers
       push  ax
       push  bx
       push  cx
       push  dx
       push  ds
       push  es
       push  di
       push  si
       push  bp
       pushf

       call  _SetDS     ;set DS = DGROUP for 'C' code

                        ;obtain saved request header pointer
       les   di,[_RHPtr]
       push  es         ;save on stack as C parameter
       push  di

                        ;get BX = command code
       mov   bl,es:[di+2]
       xor   bh,bh
       cmp   bx,MaxCmd  ;is this a legal command ??
       jle   Intr1      ;jump if OK
       call  _Unknown   ;Ook! Invoke unknown command handler
       add   sp,4       ;remove 'C' argument from stack
       jmp   Intr2

Intr1: shl   bx,1       ;form index into dispatch table..
                        ;and call appropriate routine
       call  word ptr cs:[bx+JumpTab]
       add   sp,4       ;remove 'C' argument from stack

Intr2: les   di,[_RHPtr] ;re-load address of request header
       or    ax,0100h   ;set done bit in status

                        ;store status in header
       mov   es:[di+3],ax

                        ;restore general registers
       popf
       pop   bp
       pop   si
       pop   di
       pop   es
       pop   ds
       pop   dx
       pop   cx
       pop   bx
       pop   ax

                        ;back to DOS
       ret

Intr      endp

;-------------------------------------------------------------
; Display a character on the screen using the BIOS
;-------------------------------------------------------------

public _BIOSChr
_BIOSChr  proc near

          push bp
          mov  bp,sp
          mov  ah,0Eh
          mov  al,[bp+04]
          xor  bh,bh
          mov  bl,08
          int  10h
          pop  bp
          ret

_BIOSChr  endp

_TEXT     ENDS

; The data segment for C code

_DATA      SEGMENT PARA PUBLIC 'DATA'

           ASSUME CS:_TEXT,DS:DGROUP,ES:NOTHING

; A PVCS Identification string (also marks the beginning of the segment)

Ident  db    'DOS_DRV.ASM $Revision:   1.1  $ - (c) ASHBYSOFT 1994'

; The device driver & request header pointers, saved by Strat routine

_DHPtr  dd    ?
public _DHPtr
_RHPtr  dd    ?
public _RHPtr

_DATA      ENDS

CONST      SEGMENT WORD PUBLIC 'DATA'
CONST      ENDS

_BSS       SEGMENT WORD PUBLIC 'DATA'
_BSS       ENDS

END

; End of DOS_DRV.ASM
