;**************************************************************************
;*     PIPELINE vers 1.0, DOS                                             *
;*     Connects COM1 and COM2 in software.                                *
;*     6/1/90                                                             *
;*     by James W. Birdsall                                               *
;*                                                                        *
;*     assembles under Turbo Assembler 1.0, 2.0                           *
;*                                                                        *
;*     requires DOS 2.0 or higher                                         *
;*                                                                        *
;*   This program is a small TSR that connects COM1 and COM2 in software. *
;*   It is run from the command line with no arguments. After             *
;*   installation, setup and activation is performed with the program     *
;*   VALVE.                                                               *
;*                                                                        *
;*   This program can share an interrupt vector. It can be set to chain   *
;*   to the previous interrupt handler if examination of the serial port  *
;*   shows that no interrupt is pending.                                  *
;*                                                                        *
;**************************************************************************

LOCALS
.MODEL tiny


ENVOFFSET	EQU	2Ch

INTERFACEINT	EQU	0F1h


; TO CHANGE FROM COM1 OR COM2, CHANGE THE FOLLOWING INTERRUPT AND PORT
; VALUES.
COM1INT		EQU	0Ch
COM2INT		EQU	0Bh

COM1BASE	EQU	3F8h
COM1IER		EQU	3F9h
COM1IIR		EQU	3FAh
COM1LSR		EQU	3FDh

COM2BASE	EQU	2F8h
COM2IER		EQU	2F9h
COM2IIR		EQU	2FAh
COM2LSR		EQU	2FDh
; END OF INTERRUPT AND PORT VALUES


EOI		EQU	20h
EOIPORT		EQU	20h

OVERRUNMASK	EQU	02h
INTPENDMASK	EQU	01h
THREMASK	EQU	20h


.CODE
	ORG	100h
start:
	jmp	Install			; jump to installation code

; DATA AREA

errors		dw	0
int_B		dd	0
old_int_B	dd	0
int_C		dd	0
old_int_C	dd	0
PSPseg		dw	0
old_interface	dd	0
enabled         db      0
chain		db	0


; HANDLER FOR COM1 INTERRUPTS

Com1handler:
	sti				; enable interrupts
        push	ax			; preserve
        push	bx
        push	dx
	mov	dx, COM1LSR		; check for overruns
        in	al, dx			; read LSR
        test	al, OVERRUNMASK
        jz	@@NoOverrun		; if zero, OK
        inc	cs:errors
@@NoOverrun:
        mov	dx, COM1IIR
        in	al, dx			; read interrupt identification
        test	al, INTPENDMASK
        jnz	@@NotOurs
        mov	dx, COM1BASE		; read character
        in	al, dx
        mov	bl, al			; put in BL for safekeeping
        mov	dx, COM2LSR		; check COM2 transmit status
        in	al, dx
        test	al, THREMASK		; check for transmit buffer empty
        jz	@@NoSend		; if nonzero, can't transmit
        mov	dx, COM2BASE		; otherwise send char
        mov	al, bl			; put char back in AL
        out	dx, al
@@NotOurs:
	test	cs:chain, 0FFh		; is chain zero?
        jz	@@SendEOI		; if so, return normally
        pushf				; otherwise call old ISR
        call	cs:old_int_C
        jmp	@@Final			; since old ISR sent EOI, don't resend
@@NoSend:
	inc	cs:errors		; increment errors
@@SendEOI:
	mov	al, EOI			; send EOI
        out	EOIPORT, al
@@Final:
        pop	dx			; restore
        pop	bx
        pop	ax
        iret				; return


; HANDLER FOR COM2 INTERRUPTS

Com2handler:
	sti				; enable interrupts
        push	ax			; preserve
        push	bx
        push	dx
	mov	dx, COM2LSR		; check for overruns
        in	al, dx			; read LSR
        test	al, OVERRUNMASK
        jz	@@NoOverrun		; if zero, OK
        inc	cs:errors
@@NoOverrun:
        mov	dx, COM2IIR
        in	al, dx			; read interrupt identification
        test	al, INTPENDMASK
        jnz	@@NotOurs
        mov	dx, COM2BASE		; read character
        in	al, dx
        mov	bl, al			; put in BL for safekeeping
        mov	dx, COM1LSR		; check COM2 transmit status
        in	al, dx
        test	al, THREMASK		; check for transmit buffer empty
        jz	@@NoSend		; if nonzero, can't transmit
        mov	dx, COM1BASE		; otherwise send char
        mov	al, bl			; put char back in AL
        out	dx, al
@@NotOurs:
	test	cs:chain, 0FFh		; is chain zero?
        jz	@@SendEOI		; if so, return normally
        pushf				; otherwise call old ISR
        call	cs:old_int_B
        jmp	@@Final			; since old ISR sent EOI, don't resend
@@NoSend:
	inc	cs:errors		; increment errors
@@SendEOI:
	mov	al, EOI			; send EOI
        out	EOIPORT, al
@@Final:
        pop	dx			; restore
        pop	bx
        pop	ax
        iret				; return


; SIGNATURE USED FOR INSTALLATION CHECK

signature	db	'JWBP10'


; INTERFACE INTERRUPT HANDLER -- RETURNS POINTER TO DATA AREA

Interface:
	mov	ax, cs			; put segment in AX
        mov	bx, offset errors	; put offset in BX
        iret				; and return


; INSTALLATION CODE -- IS DISCARDED AFTER INSTALLATION

Last_byte:

OKmessage	db	'PIPELINE installed OK.',0Dh,0Ah,'$'
FAILmessage	db	'PIPELINE installation error.',0Dh,0Ah,'$'
COPYRIGHT	db	'Copyright (c) 1990 James W. Birdsall.'
COPYRIGHT2	db	'All Rights Reserved.'

Install:
        mov	bx, es			; copy PSP segment from ES into BX
        mov	PSPseg, bx		; put into storage
        mov	si, ENVOFFSET
        mov	ax, es:si		; move environment segment into AX
        or	ax, ax			; check it
        jz	Continue		; if zero, no environment
        mov	es, ax			; put env seg in ES
        mov	ah, 49h			; free block
        int	21h
        jc	Fail			; if carry set, error
Continue:
					; put far ptrs to handlers in storage
	mov	WORD PTR [int_B], offset Com2handler
        mov	WORD PTR [int_C], offset Com1handler
        mov	ax, cs
        mov	WORD PTR [int_B+2], ax
        mov	WORD PTR [int_C+2], ax

        mov	ah, 35h				; get old int 0Bh vector
        mov	al, 0Bh
        int	21h
        mov	WORD PTR [old_int_B], bx	; and put in old_int_B
        mov	bx, es
        mov	WORD PTR [old_int_B+2], bx

        mov	ah, 35h				; get old int 0Ch vector
        mov	al, 0Ch
        int	21h
        mov	WORD PTR [old_int_C], bx	; and put in old_int_C
        mov	bx, es
        mov	WORD PTR [old_int_C+2], bx

        mov	ah, 35h				; get old interface vector
        mov	al, INTERFACEINT
        int	21h
        mov	WORD PTR [old_interface], bx	; and put in old_interface
        mov	bx, es
        mov	WORD PTR [old_interface+2], bx
        mov	ah, 25h				; set up interface
        mov	al, INTERFACEINT
        mov	dx, offset Interface
        int	21h

        mov	ah, 09h				; print OK message
        mov	dx, offset OKmessage
        int	21h

        mov	dx, offset Last_byte		; go resident with code 0
        add	dx, 15
        mov	cl, 4
        shr	dx, cl
        mov	ah, 31h
        xor	al, al
        int	21h
Fail:
	mov	ah, 09h				; print FAIL message
        mov	dx, offset FAILmessage
        int	21h

	mov	ah, 4Ch				; exit with code 3
        mov	al, 3
        int	21h
        END 	start
END
