


     HELP(1)                  MS-DOS utilities                  HELP(1)



     NAME
          HELP - obtain help on DOS commands

     SYNOPSIS
          help [ -1facpbqhP ] [ -i[n] ] [ -k|K keyword ...] [keyword
          ... ]

     DESCRIPTION
          Help is a program to retrieve and display entries from a
          help file. It can operate in a full screen interactive
          browsing mode, or a command line mode which writes only to
          standard output and should work on generic MSDOS computers.
          The helpfiles are pure ascii and can easily be edited and
          extended for local variations in commands.

     INTERACTIVE HELP
          If help is entered without any commands specified, it enters
          a full screen interactive help browsing mode.  A window is
          placed on the screen with a sorted list of all available
          help entries.  There is always one entry highlighted, and
          pressing <return> will retrieve help entry for this item.
          If environment variable PAGER is defined, it is assumed to
          be a program to be used for displaying the help entry,
          otherwise the entry is copied directly to the screen.
          Options allow the action to be customised for you favourite
          pager.  A program used for the PAGER must be able to read
          from a pipe.  Selection from the list continues until <ESC>
          is pressed.

          NOTE:  use of a PAGER variable may slow the response.  This
          can be helped by placing the PAGER program in a RAM disk,
          and the path set to include this. The command processor
          (COMMAND.COM or other) is not used for this (PAGER is
          executed directly) When interactive mode is used, the screen
          will be saved and restored after use.  In addition, the
          temporary file necessary for this operation may be placed in
          a RAM disk by setting variable TMPDIR or TMP to a suitable
          location.

          The following keys are recognised in interactive mode:

          <return>
               select the current item <space>

          <up>
               move current line up or down, scrolling as needed
               <down>

          <home>
               jump to beginning and end of list, respectively <end>

          <pageup> <pagedown>
               scroll the list one window at a time


     Page 1                                           (printed 2/15/91)






     HELP(1)                  MS-DOS utilities                  HELP(1)


          A-Z
               alphabetic keys will scroll the list to the first entry
               beginning with the letter you type, or the following
               entry if none matches

          F1
               pop up a help window describing key actions

          F2

               toggle between displaying name, or full synopsis line

          F3
               toggle synopsis line on current item only

          F4
               extract a list of cross references from the current
               item, and open a new selection window.  This can be
               used recursively

          F10
               window goes into move/resize mode.  Use arrow keys to
               move it, shift-arrows to resize left and bottom edges,
               <esc> or F10 to continue (see below)

          <ESC>
               Exit the program and restore screen

          Moving/Resizing the Window:
          The window containing the list of keywords can be moved or
          resized by pressing F10.  This ability is for the benefit of
          other programs that call help as a child process, with a
          custom help file.  The window can be moved and resized with
          the following keys:

          arrow keys:
               move window 1 space at a time in the appropriate
               direction

          control-arrow keys:
               move window to extreme edge of screen in the
               appropriate direction

          shift-arrow keys
               resize by dragging right and bottom edges of the window

          control-shift-arrow keys
               resize by moving right and bottom edges maximum
               possible distance

          <ESC>
               redraw window in the current position and continue with
               program

          F10


     Page 2                                           (printed 2/15/91)






     HELP(1)                  MS-DOS utilities                  HELP(1)


               redraw window in the current position and continue with
               program, but attempt to "lock" window position so that
               a subsequent call to this program will use the new
               window position.  This function uses the
               "Interapplication Communication Area" (ICA) in the BIOS
               data block. If any other program is also using the ICA,
               help will NOT overwrite it's contents.  The ICA may
               contain garbage when the machine is first booted, so a
               small program (clearica.com) is provided to fill the
               ICA with zeroes.  The ICA is not documented in the PS/2
               BIOS and this function may not work.  Using F10 should
               not cause problems with the PS/2, but clearica may
               cause problems.  The sub-windows use with the F4 (cross
               reference) command may be moved but not locked.

     OPTIONS (apply to interactive mode only)

          -c
               screen clear between each display.  Use this if you
               specify a pager which does not clear the screen before
               starting.

          -K key key ...
               apropos keyword (see below) with interactive browsing.
               The list displayed for selection contains only those
               items which contain one of the keywords in the
               synopsis.

          -p
               pauses after each display. Use this if you specify a
               pager that does not pause at the end of the file (e.g.
               DOS MORE)

          -q
               quiet mode - flash instead of beeping

          -b
               bios used for screen output instead of directvideo (use
               if compatiblity problems arise with default action)

     COMMAND LINE HELP
          If the format help command is used, then the helpfile is
          searched for "command", and if found, it is printed to
          standard output (or piped through program %PAGER). Multiple
          commands may be listed and they will be searched for in
          order.

          If the format help -k keyword is used, the 1-line synopses
          for each help entry are searched for "keyword" and all those
          that match are copied to standard output.

          The command line help uses pure DOS i/o and should work on
          any generic MS-DOS machine, including non-IBM compatibles.



     Page 3                                           (printed 2/15/91)






     HELP(1)                  MS-DOS utilities                  HELP(1)


     OPTIONS (apply to non-interactive mode)

          -i
               Print index of entries in help file.  If followed by a
               number <n>, print <n> keywords per line (default 5).

          -1
               Print single file index of entries in help file, with
               no header

          -k key key ...
               Print synopsis of all entries related to <keyword>. All
               command line arguments after -k are taken to be
               keywords for synopsis search rather than entries to
               display full text for.  The synopsis search is
               simpleminded, no regular expressions or boolean
               combinations of keywords.

          -P
               Pipe output through program %PAGER if defined.  This is
               always used for interactive selection, and may be
               applied to command line arguments with the -P option.
               This is equivalent to "help command | %PAGER"

          -f
               Force rebuild of index files

          -h
               Print 1 page summary of program

          -a
               Ansi_mode.  Do NOT enter interactive mode if no
               commands are listed (for use on machines for which this
               causes trouble).  If no commands are listed, then
               "HELP" is looked up instead.

     DESCRIPTION of HELPFILES
          The helpfile consists of one or more ascii files, with the
          index words (and aliases) marked as explaied below.  The
          files are treated effectively as though concatenated.  An
          index is built and stored in a separate file whenever help
          detects that the index is out of date with respect to the
          helpfile.  The helpfile may be edited with any text editor.
          The file supplied has brief descriptions of most of the
          MSDOS 4.01 and earlier commands.  A 1-line description of
          every help entry is also stored in the index file. This may
          be searched for keywords by using the "apropos" command:
          help -k keyword

          The commands and keywords are not case sensitive.  All
          output is to standard output which may be redirected to a
          file or printer.  Some of the longer entries exceed one
          screen and may be piped through "more" or any other pager.



     Page 4                                           (printed 2/15/91)






     HELP(1)                  MS-DOS utilities                  HELP(1)


          The default directory for the help file is the directory in
          which the executable (help.exe) is located.  This may be
          overridden by setting the environment variable HELPDIR

          The default name for the help file is "helpfile".  This may
          be overridden by setting the environment variable HELPFILE.
          HELPFILE may contain a list of file names separated by ";"
          and HELP will cycle through each in turn. This allows help
          files for different types of programs to be maintained in
          logical groupings, but searched as if they were a single
          file.  They must all reside in the same directory.  If any
          files are not present, a diagnostic will be displayed but
          the others will be processed.

          The index file for each help file is created by appending
          .idx to the data file name.  The data file should therefore
          have no extension.

          The format for the help files is:
          keyword [,alias ,alias ...] [#xref #xref ...]
          keyword - 1 line description to be used by the -k option
          ...
          any number of lines of text, up to EOF or next # at start of
          line ...


          keyword
               - primary index for this help entry

          alias
               - alternate index terms for this help entry

          #xref
               - keywords prepended by "#" are cross-references used
               by the F4 command in interactive mode. All items on the
               index line are space or comma delimited, and the line
               may be up to 134 characters.

          In all of the descriptions of command usage:

          [brackets]
               indicates optional items.

               indicates that the previous parameter may be repeated.

          d:
               represents a valid drive letter (with colon)

          path
               represents a directory path

          filename
               is a DOS filename (with extension)



     Page 5                                           (printed 2/15/91)






     HELP(1)                  MS-DOS utilities                  HELP(1)


          filespec
               is a DOS filename optionally with "*" and "?" wildcards

          nnn
               is generally a numeric parameter to be supplied

          The help files use the format in the MKS toolkit help, of
          which this was originally a clone.  See the documentation
          file for more information

     FILES
          helpfile default datafile containing help info
          helpfile.idx default index file
          HELPDIR Environment variable - directory for helpfile
          HELPFILE Environment variable - alternate name(s) for
          helpfile
          PAGER Program to use for displaying help entries
          HELP If set, is parsed as a command line argument before the
          other arguments.  This allows setting of default options.
          COLOR Environment variable - if set, is parsed as for the
          4DOS COLOR command and used to set the screen colours for
          the interactive selection windows.  The syntax is "fg ON bg"
          where fg and bg are foreground and background colours taken
          from the from the list "BLACK BLUE GREEN CYAN RED MAGENTA
          YELLOW GRAY".  For example, COLOR=BLUE ON YELLOW

     BUGS
          It would be useful if the last help entry viewed were to
          remain on the screen at exit.  Since the help program has no
          control over which pager is used, this is not always
          possible.  It is also not possible to preserve the screen
          when recursive calls are made to the cross-reference
          feature.  In general, for any given pager, the best
          combination of -c and -p options will need to be determined
          empirically.

     AUTHORS
          Original Author:  uwmacc!harvard!killer!wnp (Wolf Paul)
          Environment variable handling by:  plocher@uwspan.uucp (John
          Plocher)
          Addition of all -options, interactive mode, multiple
          helpfiles and pretty much rewrote everything.
          richard@calvin.ee.cornell.edu

          (Richard Brittain) School of Electrical Engineering,
          Engineering and Theory Center, Cornell University, Ithaca NY
          14853

          Code for the popen/pclose routines was taken from a BBS and
          it bears no author name.

          Permission is granted to copy and use the compiled program
          and documentation for any non-commercial use, provided all
          copyright information is retained.


     Page 6                                           (printed 2/15/91)






     HELP(1)                  MS-DOS utilities                  HELP(1)


                       Copyright 1990 by Richard Brittain



























































