/*
 *	mkegacol.c  --  rgb and palette for ega graphics.
 *
 *	28 june 1989  Olle Olsson
 */

#include <stdlib.h>
#include "egargb.h"

/* number of color intensitys */
#define NINTENS	4

/* color values for ega */
#define R0	000
#define R1	040
#define R2	004
#define R3	044
#define G0	000
#define G1	020
#define G2	002
#define G3	022
#define B0	000
#define B1	010
#define B2	001
#define B3	011
/*#define	BLACK	(R0+G0+B0)*/

/* select pattern (blue only) */
#define EGACB(n) (((n) == 1) ? B1 : (((n) == 2) ? B2 : ((n) == 3) ? B3 : B0))

int mkegacolor( cl )
rgb *cl;
{
int c;

/* make an ega color from (r, g, b) */
c = EGACB( cl -> r ) << 2;
c |= EGACB( cl -> g ) << 1;
c |= EGACB( cl -> b );
return (c);
}

void randrgb( cp )
rgb *cp;
{
cp -> r = rand() % 4;
cp -> g = rand() % 4;
cp -> b = rand() % 4;
}

void rgbtopal( clr, nclr, pal )
rgb clr[];			/* colors (bg is the first) */
int nclr;			/* number of colors */
struct palettetype *pal;	/* return values here */
{
register int i;
register rgb *fcp;

/* check size */
if (nclr > MAXCOLORS + 1) nclr = MAXCOLORS + 1;

pal -> size = nclr;

for (i = 0, fcp = clr; i < nclr; ++i, ++fcp)
	pal -> colors[i] = mkegacolor( fcp );
}


void r_incdec( rgb *cp, int incr )
{
/* red increment/decrement */

if (incr)
	{
	if (++cp -> r >= NINTENS) cp -> r = 0;
	}
else
	{
	if (--cp -> r < 0) cp -> r = NINTENS - 1;
	}
}

void g_incdec( rgb *cp, int incr )
{
/* green increment/decrement */

if (incr)
	{
	if (++cp -> g >= NINTENS) cp -> g = 0;
	}
else
	{
	if (--cp -> g < 0) cp -> g = NINTENS - 1;
	}
}

void b_incdec( rgb *cp, int incr )
{
/* blue increment/decrement */

if (incr)
	{
	if (++cp -> b >= NINTENS) cp -> b = 0;
	}
else
	{
	if (--cp -> b < 0) cp -> b = NINTENS - 1;
	}
}


