/*
 *	ifsrand.c  --  generate a random ifs.
 *
 *	4 june 1989  Olle Olsson
 */

#include <stdlib.h>
#include <math.h>
#include "ifs.h"

static double dbrand( double sup );

static double dbrand( sup )
double sup;		/* supremum */
{
return ((sup * rand()) / MAXRAND);
}

int ifsrand( dp, minsize, maxsize, show )
ifsdes *dp;		/* empty descriptor */
int minsize;		/* min size of the transform */
int maxsize;		/* max size of the transform */
int show;		/* trace flag */
{
area *ap = &dp -> area;		/* area */
transform *tp = dp -> tp;	/* empty transform */
rgb *rp;			/* tmp */
int ntr;			/* number of transforms */
int i;
double da;

/* return value is actual number of transforms */

/* set a suitable area */
ap -> xlow = -1;
ap -> xlen = 2;
ap -> ylow = -1;
ap -> ylen = 2;

/* select count */
if (minsize >= maxsize)
	ntr = maxsize;
else 	ntr = rand() % (1 + maxsize - minsize) + minsize;

/* make transforms */
/* check that it is contractive  (det( A ) < 1) */
/* check that it isn't too contractive (det( A ) > 0) */
for (i = 0; i < ntr; ++i, ++tp) do
	{
	tp -> a11 = dbrand( 2 ) - 1;
	tp -> a12 = dbrand( 2 ) - 1;
	tp -> a21 = dbrand( 2 ) - 1;
	tp -> a22 = dbrand( 2 ) - 1;
	tp -> b1  = dbrand( 1 ) - .5;
	tp -> b2  = dbrand( 1 ) - .5;
	tp -> prob = dbrand( 1 ) + .1;

	/* take a nice color, but not black since the background is black */
	tp -> color = i % (dp -> clrsize - 1) + 1;
	rp = &dp -> colors[tp -> color];
	do randrgb( rp );
	while (rp -> r == 0 && rp -> g == 0 && rp -> b == 0);

	/* use group 0 only */
	tp -> group = 0;
	
	da = dett( tp );
	/* */
	if (show) printf( "tr %d det %g\n", i, da );
	/* */
	} while (da >= .5 || da < .05);

return (ntr);
}
