/*
 *	findtrans.c  --  search function for edtrans().
 *
 *	9 july 1989  Olle Olsson.
 */

#include <math.h>
#include "edtrans.h"

int findtrans( tp, size, ap, screenx, screeny )
transform *tp;		/* the transforms to search among */
int size;		/* number of transforms */
area *ap;		/* limiting area */
int screenx;		/* screen x */
int screeny;		/* screen y */
{
double dis, l;		/* distance */
int selt;		/* the index of the selected transform */
int i;
double x, y;		/* real coordinates of screenx, screeny */

/* find the (transformed) origin that is closest the screen point */
/* (you could take the middle point or check if it is inside or ...) */

/* negative means "not found" */
if (size <= 0)
	return (-1);

/* compute the real coordinates  (y is upside down) */
x = ap -> xlow + screenx * ap -> xlen / MAX_COL;
y = ap -> ylow + (MAX_ROW - screeny) * ap -> ylen / MAX_ROW;

for (i = selt = 0, dis = 1e20; i < size; ++i, ++tp)
	{
	l = sqrt( (x - tp -> b1) * (x - tp -> b1) +
		  (y - tp -> b2) * (y - tp -> b2) );

	if (l < dis)
		{
		dis = l;
		selt = i;
		}
	}

return (selt);
}


