;****************************************************************************
;*
;* $ vfhnd.asm 27/07/99 19:05 $
;* VFlat exeption handlers. Revision 1.01
;*
;* Copyright (C) 1999  Dmitry Uvarov <mit@pc2o205a.pnpi.spb.ru>
;*
;* This program is free software; you can redistribute it and/or modify
;* it under the terms of the GNU General Public License as published by
;* the Free Software Foundation; either version 2 of the License, or
;* (at your option) any later version.
;*
;* This program is distributed in the hope that it will be useful,
;* but WITHOUT ANY WARRANTY; without even the implied warranty of
;* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;* GNU General Public License for more details.
;*
;* You should have received a copy of the GNU General Public License
;* along with this program; if not, write to the Free Software
;* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;*
;**************************************************************************
; Int10h VFlat page handler for 64K bank.
PROC VF_handler64k_Int10h FAR
      push    edx

      mov     edx,cr2                 ; load page fault address from CR2
      ; check if fault was in our vflat surface
      cmp     edx,VFLAT_START
      jb      @@CallOldHandler
      cmp     edx,VFLAT_END
      jae     @@CallOldHandler

      ; now we know that this is our page fault, so handle it...
      pushad               ; save all dwords registers

      ; calculate bank number we need to swich to
      mov     eax,edx         ; edx=linear address of page fault
      shr     edx,16          ; edx=bank number
      shr     eax,10          ; calculate page number in eax
      and     edx,0FFh        ; mask bank number to 0-255
      and     eax,03FC0h      ; eax=page number aligned on bank boundary
                              ;    and multiplyed by four.
                              ;    i.e. eax=starting page offset in page table

      ; because we running in flat model and exeption was in our program,
      ; we can be sure that DS register is already loaded with program's
      ; data selector, so we can freely access our data

      mov     edi,[VFlatPageTablePtr]  ; load pointer to our page table
      mov     esi,[LastPage]
      add     edi,eax                  ; edi=absolute address of pages that
                                       ;     must be enabled
      ; disable old pages
offs = 0
REPT    16
         and  [DWORD esi+offs],00FFFFFFFEh     ; disable old pages
offs = offs+4
ENDM
      ; now enable new pages
offs = 0
REPT    16
          or  [DWORD edi+offs],0000000001h ; enable pages
offs = offs+4
ENDM
      mov     [LastPage],edi              ; store pointer to last mapped pages

      ; because we modify page table we must flush page cache
      mov     eax,cr3
      mov     cr3,eax    ; flush TLB cache

      ; swich bank using int10h. Under VBE 1.2 there is no other way
      ; of swiching banks.
      ; FIXME: Try to use 386 to 286 call to directly call bank swiching
      ;        function
      ; Int10h Input:   BX = window number ( always use window 0 )
      ;                 DX = bank number   ( already calculated )
      ;                 AX = function nuber ( function 04F05h - bank swich )
      xor     ebx,ebx          ; window 0
      mov     eax,vbeBankSwich ; VESA bank swich function
      int     10h

      popad              ; restore all dword registers
      pop     edx        ; pop saved edx from stack
      add     esp,4      ; pop error code from stack, other registers stay
                         ;   unmodifyed
      iretd              ; interrupt return

@@CallOldHandler:
      pop     edx        ; remove edx from stack
      jmp     [Int14CallGate] ; chain to old handler throught 386 callgate.
                              ; Leaving all parameters in stack

ENDP VF_handler64k_Int10h


;****************************************************************************;
;****************************************************************************;
;****************************************************************************;
;****************************************************************************;
;****************************************************************************;

; Int10h VFlat page handler for 4K bank.
PROC VF_handler4k_Int10h FAR

      push    edx

      mov     edx,cr2                 ; load page fault address from CR2
      ; check if fault was in our vflat surface
      sub     edx,VFLAT_START
      jl      @@CallOldHandler
      cmp     edx,VFLAT_END - VFLAT_START
      jae     @@CallOldHandler

      ; now we know that this is our page fault, so handle it...
      pushad               ; save all dwords registers

      ; calculate bank number we need to swich to
      shr     edx,12          ; edx = bank number

      ; because we running in flat model and exeption was in our program,
      ; we can be sure that DS register is already loaded with program's
      ; data selector, so we can freely access our data

      mov     edi,[VFlatPageTablePtr]  ; load pointer to our page table
      mov     esi,[LastPage]           ; load pointer to last mapped page
      lea     edi,[edi+edx*4]          ; edi=absolute address of page that
                                       ;     must be enabled

      and  [DWORD esi],00FFFFFFFEh     ; disable old page
      or   [DWORD edi],0000000001h     ; enable new page

      mov     [LastPage],edi              ; store pointer to last mapped page

      ; because we modify page table we must flush page cache
      mov     eax,cr3
      mov     cr3,eax    ; flush TLB cache

      ; swich bank using int10h. Under VBE 1.2 there is no other way
      ; of swiching banks.
      ; FIXME: Try to use 386 to 286 call to directly call bank swiching
      ;        function
      ; Int10h Input:   BX = window number ( always use window 0 )
      ;                 DX = bank number   ( already calculated )
      ;                 AX = function nuber ( function 04F05h - bank swich )
      xor     ebx,ebx          ; window 0
      mov     eax,vbeBankSwich ; VESA bank swich function
      int     10h

      popad              ; restore all dword registers
      pop     edx        ; pop saved edx from stack
      add     esp,4      ; pop error code from stack, other registers stay
                         ;   unmodifyed
      iretd              ; interrupt return

@@CallOldHandler:
      pop     edx        ; remove edx from stack
      jmp     [Int14CallGate] ; chain to old handler throught 386 callgate.
                              ; Leaving all parameters in stack

ENDP VF_handler4k_Int10h
