/* $ pmode.cpp 29/06/99 21:24 $
 * Protected mode DPMI functions. Revision 1.0
 *
 * Copyright (C) 1999  Dmitry Uvarov <mit@pc2o205a.pnpi.spb.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <i86.h>
#include "..\include\pmode.h"

ibool PM_AllocateDOSMemory(int size, word *sel, word *seg)
  {
    union REGS r;
    r.w.ax = 0x100;
    r.w.bx =  (word) ((size + 0xF)>>4);  // calculate size in paragraphs
    int386(PM_INT,&r,&r);
    *sel = r.w.dx;
    *seg = r.w.ax;
    return !r.x.cflag;
  }
ibool PM_FreeDOSMemory(int sel)
  {
    union REGS r;
    r.w.ax = 0x101;
    r.w.dx = sel;
    int386(PM_INT,&r,&r);
    return !r.x.cflag;
  }

ibool PM_RealModeInt(int num, RMREGS *rm)
  {
    union REGS r;
    struct SREGS sr;

    r.w.ax = 0x0300;
    r.w.bx = num & 0xFF;
    r.w.cx = 0;
    r.x.edi = (unsigned)rm;
    segread(&sr);
    sr.es = sr.ds;

    int386x(PM_INT,&r,&r,&sr);
    return !r.x.cflag;
  }

word  PM_AllocateDescriptors(int num)
  {
    union REGS r;

    r.w.ax = 0x0000;
    r.w.cx = num;

    int386(PM_INT,&r,&r);
    return (!r.x.cflag) ? r.w.ax : 0xFF;
  }

ibool PM_FreeSelector(word sel)
  {
    union REGS r;
    r.w.ax = 0x0001;
    r.w.bx = sel;
    int386(PM_INT,&r,&r);
    return !r.x.cflag;
  }

ibool PM_SetSelectorBase(word sel, dword base)
  {
    union REGS r;
    r.w.ax = 0x0007;
    r.w.bx = sel;
    r.w.dx = base & 0xFFFF;
    r.w.cx = base >> 16;
    int386(PM_INT,&r,&r);
    return !r.x.cflag;
  }

ibool PM_SetSelectorLimit(word sel, dword limit)
  {
    union REGS r;
    r.w.ax = 0x0008;
    r.w.bx = sel;
    r.w.dx = limit & 0xFFFF;
    r.w.cx = limit >> 16;
    int386(PM_INT,&r,&r);
    return !r.x.cflag;
  }

ibool PM_CreateSelector(dword base, dword limit)
  {
    word sel = PM_AllocateDescriptors(1);
    if (!sel) return FALSE;
    PM_SetSelectorBase(sel,base);
    PM_SetSelectorLimit(sel,limit);
    return TRUE;
  }

dword PM_MapPhysicalToLinear(dword base, dword limit)
  {
    union REGS r;
    r.w.ax = 0x0800;
    r.w.cx = base & 0xFFFF;
    r.w.bx = base >> 16;
    r.w.di = limit & 0xFFFF;
    r.w.si = limit >> 16;
    int386(PM_INT,&r,&r);
    return r.x.cflag == 0 ? (r.w.cx | (r.w.bx<<16)) : 0;
  }

ibool PM_FreePhysicalMapping(dword base)
  {
    union REGS r;
    r.w.ax = 0x0801;
    r.w.cx = base & 0xFFFF;
    r.w.bx = base >> 16;
    int386(PM_INT,&r,&r);
    return !r.x.cflag;
  }

ibool PM_LockLinearRegion(dword base, dword size)
  {
    union REGS r;
    r.w.ax = 0x0600;
    r.w.cx = base & 0xFFFF;
    r.w.bx = base >> 16;
    r.w.di = size & 0xFFFF;
    r.w.si = size >> 16;
    int386(PM_INT,&r,&r);
    return !r.x.cflag;
  }

ibool PM_UnLockLinearRegion(dword base, dword size)
  {
    union REGS r;
    r.w.ax = 0x0601;
    r.w.cx = base & 0xFFFF;
    r.w.bx = base >> 16;
    r.w.di = size & 0xFFFF;
    r.w.si = size >> 16;
    int386(PM_INT,&r,&r);
    return !r.x.cflag;
  }

ibool PM_CallRealModeFAR(RMREGS *regs)
  {
    union REGS r;
    SREGS sr;
    segread(&sr);
    r.w.ax = 0x301;
    r.w.bx = 0;
    r.w.cx = 0; /* number of words to copy to real mode stack */
    sr.es = sr.ds;
    r.x.edi = (dword)regs;
    int386x(PM_INT,&r,&r,&sr);
    return !r.x.cflag;
  }

ibool PM_GetFreeMemInfo(PM_freeMemInfo *memInfo)
  {
    union REGS r;
    SREGS sr;
    segread(&sr);
    sr.es = sr.ds;
    r.w.ax = 0x500;
    r.x.edi = (dword)memInfo;
    int386x(PM_INT,&r,&r,&sr);
    return !r.x.cflag;
  }