#include <stdio.h>
#include <string.h>

#define XMAX 1024
#define YMAX 1024

#define delimiter '\\'

typedef
unsigned char   byte;

#define BUFFER_SIZE (20000)

byte            image_buffer[BUFFER_SIZE][3];

#define STRING_MAX 64
char            progname[STRING_MAX];

FILE           *inimage, *outimage;

byte
read_byte()
{
  char            data;

  if (fread(&data, 1, 1, inimage) != 1)
  {
    fprintf(stdout, "ERROR: premature EOF\n");
    exit(1);
  }
  return ((byte) data);
}

main(argc, argv)
  int             argc;
  char           *argv[];

{
  register int    y;
  int             xsize, ysize, size;
  char            infile[STRING_MAX], outfile[STRING_MAX];

  if (strrchr(argv[0], delimiter) == 0)
    strcpy(progname, argv[0]);
  else
    strcpy(progname, strrchr(argv[0], delimiter) + 1);

  if (argc != 2)
  {
    fprintf(stdout, "PIC to Alchemy RAW converter\n");
    fprintf(stdout, "ERROR: usage is '%s image (.PIC)'\n", progname);
    exit(1);
  }

  sprintf(infile, "%s.pic", argv[1]);

  if ((inimage = fopen(infile, "rb")) == NULL)
  {
    fprintf(stdout, "ERROR: cannot read %s\n", infile);
    exit(1);
  }

  sprintf(outfile, "%s.raw", argv[1]);

  if ((outimage = fopen(outfile, "wb")) == NULL)
  {
    fprintf(stdout, "ERROR: cannot write %s\n", outfile);
    exit(1);
  }

  fprintf(stdout, "PIC to Alchemy RAW converter\n");
  fprintf(stdout, "Reading PIC %s\n", infile);
  fprintf(stdout, "Writing RAW %s\n", outfile);

  xsize = (int) read_byte();
  xsize += (int) read_byte() << 8;

  ysize = (int) read_byte();
  ysize += (int) read_byte() << 8;

  fputs("mhwanh", outimage);
  putc(0, outimage);
  putc(4, outimage);
  putc(xsize >> 8, outimage);
  putc(xsize & 255, outimage);
  putc(ysize >> 8, outimage);
  putc(ysize & 255, outimage);
  for (y = 0; y < 20; y++)
    putc(0, outimage);

  size = (int) (((long int) ysize * (long int) xsize) / BUFFER_SIZE);

  for (y = 1; y <= size; y++)
  {
    fread((char *) image_buffer, 1, 3 * BUFFER_SIZE, inimage);
    fwrite((char *) image_buffer, 1, 3 * BUFFER_SIZE, outimage);
  }

  size = (int) ((long int) ysize * (long int) xsize -
		(long int) size * BUFFER_SIZE);

  fread((char *) image_buffer, 1, 3 * size, inimage);
  fwrite((char *) image_buffer, 1, 3 * size, outimage);

  fclose(inimage);
  fclose(outimage);

  exit(0);
}
