VERSION=8.0.0

CC=hc386 -HVp -f387 -486 -Hon=Quiet
LINK=386link -pack -486
AR=ar
RM=del /q

BINDIR=.
DEFS=-Ddos
CFLAGS=$(DEFS) -w -O2
CFLAGS2=$(DEFS) -w
LDFLAGS=-lib c:\highc\small\hcc -stack 262144

HDR=config.h defs.h dos.h extern.h general.h hpux.h mac.h\
 nmalloc.h patch.h pp.h pp_ext.h textrace.h transp.h vms.h
SRC=alias.c box.c cone.c csg.c data.c enclose.c etc.c\
 intersec.c light.c list.c main.c nmalloc.c noise.c object.c\
 params.c patch.c patch1.c picture.c polygon.c pqueue.c\
 scene.c shade.c shadligh.c shadmod1.c shadmod2.c shadtext.c\
 sphere.c surface.c texture.c triangle.c text.c textrace.c 
OBJ=alias.obj box.obj cone.obj csg.obj data.obj enclose.obj etc.obj\
 intersec.obj light.obj list.obj main.obj nmalloc.obj noise.obj object.obj\
 params.obj patch.obj patch1.obj picture.obj polygon.obj pqueue.obj\
 scene.obj shade.obj shadligh.obj shadmod1.obj shadmod2.obj shadtext.obj\
 sphere.obj surface.obj texture.obj triangle.obj text.obj textrace.obj
EXEC=rtrace

all:		exec

logo:
	@echo RTrace version $(VERSION) / VMS-UNIX-DOS
	@echo Copyright (C) 1988, 1992 Antonio Costa / INESC-Norte

$(SRC):		$(HDR)

.c.obj:
	$(CC) $(CFLAGS) -c $*.c

scene.obj:	 scene.c
	$(CC) $(CFLAGS2) -c $*.c

csg.obj:		 csg.c
	$(CC) $(CFLAGS2) -c $*.c

params.obj:	 params.c
	$(CC) $(CFLAGS2) -c $*.c

exec:		logo $(OBJ)
	$(LINK) $(LDFLAGS) -EXE $(BINDIR)\$(EXEC) @link.hc
	@echo Compilation done.

clean:		logo
	@echo Removing...
	@$(RM) *.obj >nul
	@$(RM) l? >nul
	@echo Clean done.

cleanall:	logo clean $(SRCS) $(HDRS) $(DOCS)
	@echo Removing all...
	@$(RM) *.h >nul
	@$(RM) *.c >nul
	@echo Clean all done.

archive:	logo
	@echo Archiving...
	@if exist $(EXEC).arj $(RM) $(EXEC).arj
	@arj a $(EXEC) *.h *.c *.man sff *.dj *.hc *.unx
	@echo Archival done.

extract:	logo $(EXEC).arj
	@echo Extracting...
	@arj x $(EXEC)
	@echo Extraction done.
