/***************************************************************************/
/*            Window.Hpp : Contains the class for window object            */
/*                         The Window supports only child windows          */
/*                         & buttons. Addition of any more object          */
/*                         is very simple, so that won't be a problem.     */
/*                                                                         */
/*            By : Nikhil V.                    Dt. : 9/23/1997.           */
/***************************************************************************/
#ifndef WINDOW
#define WINDOW

#include "utils.h"
#include "button.hpp"

class Window {
	int minx, miny, maxx, maxy;        // Dimensions.
	Color fore, back;                  // Store the colors.
	Window *children; 	int wincount;  // Array to hold child windows
	Button *Butts;      int buttcount; // Array to hold buttons
	struct viewporttype viewinfo;      // Used in activating & deactivating.
	public:
		Window() {
			wincount = buttcount = 0;
			}
		Window(int x1, int y1, int x2, int y2, Color f, Color b) {
			minx = x1; miny = y1;
			maxx = x2; maxy = y2;
			fore = f; back = b;
			children = new Window[10]; // Initialize the arrays.
			Butts = new Button[10];
			wincount = buttcount = 0;
			}
		Window operator =(Window &arg) {
			minx = arg.minx; miny = arg.miny;
			maxx = arg.maxx; maxy = arg.maxy;
			fore = arg.fore; back = arg.back;
			wincount = buttcount = 0;
			return *this;
			}
		Window operator << (Window &arg) {   // Inserting a child window
			children[wincount] = arg;       // into the array.
			wincount++;
			return *this;
			}
		Window operator << (Button &arg) {   // Inserting a button into
			Butts[buttcount] = arg;         // the window.
			buttcount++;
			return *this;
			}
		void show();
		void activate(){                     // Simply set the viewport to
			getviewsettings(&viewinfo);     // window dimensions.
			setviewport(minx, miny, maxx, maxy, 1);
			}
		void deactivate(){                   // Reset the viewport.
			setviewport(viewinfo.left, viewinfo.top, viewinfo.right,
					  viewinfo.bottom, viewinfo.clip);
			}
	};

void Window::show() {
	int poly[8] = {minx, miny, maxx, miny, maxx, maxy, minx, maxy};
	savestate();
	setfillstyle(SOLID_FILL, back);
	setcolor(back);
	fillpoly(4, poly);                    // Show itself.
	setcolor(fore);                       // Now, show the children.
	for(int i = 0; i < wincount; i++) children[i].show();
	for(i = 0; i < buttcount; i++) Butts[i].show();
	restorestate();
	}

#endif
/***************************************************************************/
