/*
   lfn.h: Long filename functions for WRen.

   Jason Hood, 14 June, 2000 & 25 November, 2002.

   v1.01 - 6 April, 2003:
     Win32 port.
*/

#ifndef _LFN_H
#define _LFN_H

#ifdef _WIN32

#include <io.h>

#define use_lfn 1
#define init_lfn()
#define my_ffblk _finddata_t
#define my_rename rename
#define file_exists( name ) (access( name, 0 ) == 0)

#define FA_HIDDEN _A_HIDDEN
#define FA_SYSTEM _A_SYSTEM
#define FA_DIREC  _A_SUBDIR

#else // DOS

#include <dir.h>

typedef unsigned long DWORD;	// 32 bits

struct lfn_ffblk
{
  DWORD attrib;
  DWORD cr_time[2];
  DWORD ac_time[2];
  DWORD mo_time[2];
  DWORD size_hi;
  DWORD size;
  char  resv[8];
  char  fname[260];
  char  sname[14];

  int   handle;
};

struct my_ffblk
{
  char* name;
  union
  {
    struct     ffblk df;
    struct lfn_ffblk lf;
  } ff;
};

extern int use_lfn;

int init_lfn( void );
int lfn_findfirst( const char*, struct lfn_ffblk*, int );
int lfn_findnext( struct lfn_ffblk* );
int my_rename( const char*, const char* );
int file_exists( const char* );

#endif // ?_WIN32

int my_findfirst( const char*, struct my_ffblk*, int );
int my_findnext( struct my_ffblk* );

#endif
