/*
 * addpath.c
 *
 * Returned status:
 *	0	OK (including case where nothing needs to be done)
 *	1	bad arguments
 *
 */
#include <io.h>
#include <string.h>
#include <stdlib.h>

void exit(int status) { _exit(status); }

#define writes(s,i)  write(i,s,strlen(s));

main(int argc, char *argv[])
{
	int len;
	char *path, *newdir, *p;

	if( argc != 2)	{
		writes("Usage: addpath pathname\n",2);
		exit(1);
	} else {
		newdir = strupr(argv[1]);
		len = strlen(newdir);
		/* strip off a trailing ";" and upper-case */
		if( *(newdir+len-1) == ';') *(newdir+len-1) = '\0';
		path = getenv("PATH");

		writes(path,1);
		if ((p = strstr(path,newdir)) == NULL) {
			/* not in path already - add it */
			writes(";",1);
			writes(newdir,1);
		} else {
			/* we found it, but it may be a partial match */
			if (    ((p == path) || (p != path && *(p-1) == ';'))
				 && (*(p+len) == ';' || *(p+len) == '\0') ) {
				/* already in path */
			} else {
				/* it was a bogus match - add the new one */
				writes(";",1);
				writes(newdir,1);
			}

		}
	}
	return(0);
}


