#ifndef LISTNODE_H
#define LISTNODE_H

#include <iostream.h>
#include "error.h"

template <class T>
class List ;

template <class T>
class ListNode
{

	friend class List<T> ;
   friend void sortList(List<T>&, bool (*compare)(const T&, const T&));

	
private:

//
// Constructor
//

	ListNode ( T t, ListNode<T>* n )
	{
		item = t ;
		next = n ;
	}

//
// Member functions
//

	void insertAfter ( T item )
	{
		ListNode<T>* next ;
		next = new ListNode<T> ( item, this -> next ) ;
		this -> next = next ;
	}

	void deleteAfter ()
	{
		if ( this -> next == NULL )
		{
			error ( "no node to delete" ) ;
		}
		else
		{
			ListNode<T>* old = this -> next ;
			this -> next = old -> next ;
			delete old ;
		}
	}
		
//        
// Data representation
//

	T				item ;
	ListNode<T>*	next ;
	
};

#endif
