/****************************************************************************
 *
 *      Program name : CAMPB.C
 *
 *      This is the actual minimization algorithm. Variation from the actual
 *	CAMP algorithm is as follows:
 *	    1.	Minterms with adjacency 0 or 1 is minimised first
 *	    2.	Select next minterm in increasing order of adjacency
 *	    3.	To shrink the CPT, select an adjacent term, mi that has the
 *	    	largest wi AND is already covered
 *
 * --------------------------------------------------------------------------
 *	Copyright (c) 1992. All Rights Reserved. Nanyang Technological
 *	University.
 *
 *	You are free to use, copy and distribute this software and its
 *	documentation providing that:
 *
 *		NO FEE IS CHARGED FOR USE, COPYING OR DISTRIBUTION.
 *
 *		IT IS NOT MODIFIED IN ANY WAY.
 *
 *		THE COPYRIGHT NOTICE APPEAR IN ALL COPIES.
 *
 *	This program is provided "AS IS" without any warranty, expressed or
 *	implied, including but not limited to fitness for any particular
 *	purpose.
 *
 *	If you find NTUMIN fast, easy, and useful, a note or comment would be
 *	appreciated. Please send to:
 *
 *		Boon-Tiong Tan or Othman Bin Ahmad
 *		School of EEE
 *		Nanyang Technological University
 *		Nanyang Avenue
 *		Singapore 2263
 *		Republic of Singapore
 *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#define mask8 255

unsigned char   *campb(a, b)              /* pointer to a & b array passed */
unsigned char   *a, *b;

{
   unsigned short   pterm, ma, mb, *pm, pos;
   unsigned  long   m, k, topow();
   register  long   i, wo, wi;
   register  char   j;
	     char   test;
   unsigned  char   *c, *d, *e, *s, *temp, count, limit, adj0, adji;
   unsigned  char   n, adj, adjacency(), nspm, cover;
   unsigned  char   *adjacent(), *reduce(), *cpt(), *ssm(), adj_of_mi();


   mb = *(b+2)<<8 | *(b+1);            /* no. of minterms in b-array */

   n    = *a;                          /* no. of variables */
   nspm = *(a+3);                      /* no. of bytes/minterm */
   ma = *(a+2)<<8 | *(a+1);            /* no. of minterms in a-array */

   temp = (unsigned char *) malloc(nspm+1);        /* temporary storage */
   if (temp == 0)
      {
	 printf("Out of memory -- CAMPB, *temp\n");
	 printf("Program terminated - 1\n");
	 exit(0);
      }

   s = (unsigned char *) malloc(4);                /* header of s-array */
   if (s == 0)
      {
	 printf("Out of memory -- CAMPB, *s\n");
	 printf("Program terminated - 2\n");
	 exit(0);
      }

   pterm = 0;                                /* no. of product term */

   /***
    ***  MINIMIZE ALL MINTERMS WITH ADJACENCY OF 0 & 1 FIRST
    ***/

   for (i=0; i<mb; i++)                      /* for adj = 0 or 1 */
      {
	 *b = n;                             /* assign back to n */

	 memcpy(temp, (b+4+nspm*i), nspm);   /* pick a minterm from b-array */
	 c = adjacent(temp, a, 1);           /* obtain the adjacent terms */
	 adj = *(c+1);                       /* adjacency of minterm */

	 if (adj <= 1)                       /* adjacency 0 or 1 */
	    {
	       d = cpt(c);                   /* generate CPT */

	       s = (unsigned char *) realloc(s,4+n*(pterm+1));   /* more space */
	       if (s == 0)
		  {
		     printf("Out of memory -- CAMPB, *s\n");
		     printf("Program terminated - 3\n");
		     exit(0);
		  }
	       memcpy ((s+4+n*pterm),d,n);   /* add CPT to soln array */
	       pterm++;                      /* product term count */

	       b = reduce(c,b,i);            /* remove minterms covered from b-array */
	       i = (char) *b;                /* index pointer of b-array */
	       mb = *(b+2)<<8 | *(b+1);      /* value of mb altered in b-array */

	       free(d);       		     /* free pointer */
	    }
	 free(c);                            /* free pointer */
      }

   /***
    ***  MINIMIZE MINTERMS WITH INCREASING ADJACENCY GREATER THAN 1
    ***/

   limit = 2;                               /* next adjacency limit */

   while (mb > 0)                           /* not all minterms covered */
      {
	 for (i=0; i<mb; i++)               /* remaining minterms in b-array */
	    {
	       *b = n;                      /* assign back to n */

	       memcpy(temp, (b+4+nspm*i), nspm);   /* pick a minterm from b-array */
	       c = adjacent(temp, a, limit);       /* obtain the adjacent terms */
	       adj = *(c+1);                       /* adjacency of minterm */

	       if (adj == limit)                   /* next adjacency limit */
		  {
		     /***
		      ***  GENERATE SSM AND TEST FOR COVERAGE BY FUNCTION
		      ***/

		     d = cpt(c);                   /* generate CPT */
		     e = ssm(d);                   /* generate SSM */
		     m = topow(*(e+1));            /* no. of SSM terms */

		     for (j=0; j<m; j++)            /* check for SSM coverage */
			{
			   memcpy (temp, (e+4+nspm*j), nspm);  /* pick SSM term */
			   test = exist (temp, a, ma);
			   if (test == -1)           /* SSM term not in a-array */
			      break;
			}

		     /***
		      ***  ALL SSM COVERED BY THE FUNCTION, SELECT CPT AS PRODUCT TERM
		      ***/

		     if (test == 0)                 /* all SSM's covered by fn */
			{
			   if (m > 65536)                  /* too many SSM terms */
			      {
				 printf("Product Term Too Huge \n");
				 printf("Program terminated \n");
				 exit(0);
			      }
			   *(e+1) = (m-1) & mask8;         /* no. of SSM terms minus 1 */
			   *(e+2) = (m-1)>>8 & mask8;
			   b = reduce(e,b,i);        /* remove minterms covered from b-array */
			   i = (char) *b;            /* update pointer to b-array */
			   mb = *(b+2)<<8 | *(b+1);  /* no. of minterms in b-array */

			   s = (unsigned char *) realloc(s, 4+n*(pterm+1)); /* more space */
			   if (s == 0)
			      {
				 printf("Out of memory -- CAMPB, *s\n");
				 printf("Program terminated - 4\n");
				 exit(0);
			      }
			   memcpy((s+4+n*pterm),d,n);     /* add CPT to soln array */
			   pterm++;                       /* no. of product terms */

			   free(d);                       /* free pointers */
			   free(e);
			}
		     else
			{
			   /***
			    ***  SSM NOT COVERED BY THE FUNCTION
			    ***/

			   free(d);                       /* free pointer */
			   cover =0;                      /* coverage status */

			   while (!cover)        /* do until shrinked SSM is covered */
			      {
				 /***
				  ***  OBTAIN AN ARRAY, PM OF POSITIONS OF ADJACENT TERMS,
				  ***  MI WITH THE LARGEST WI
				  ***/

				 wo = -1;                        /* initial value */
				 for (j=0; j<adj; j++)           /* do for all adjacent terms */
				    {
				       memcpy(temp,(c+4+nspm*(j+1)),nspm); /* pick adjacent term */

				       wi = adj_of_mi(temp,e,a);           /* obtain wi */
				       if (wi>wo)
					  {
					     if (wo != -1)                 /* not the first */
						free(pm);
					     wo = wi;                      /* new lowest value */
					     count = 1;                    /* reset count to 1 */

					     pm = (unsigned short *) malloc(2);  /* space for pm */
					     if (pm==0)
						{
						   printf("Out of memory -- CAMPB, *pm\n");
						   printf("Program terminated - 5\n");
						   exit(0);
						}
					     *pm = j;                      /* first element */
					  }
				       else if (wi==wo)                    /* wi as large */
					  {
					     count++;                      /* no. of element in pm-array */

					     pm = (unsigned short *) realloc (pm, 2*count);  /* more space */
					     if (pm==0)
						{
						   printf("Out of memory -- CAMPB, *pm\n");
						   printf("Program terminated - 6\n");
						   exit(0);
						}
					     *(pm+count-1) = j;            /* elements of pm-array */
					  }
				    }
				 free(e);

				 /***
				  ***  SELECT FROM PM-ARRAY, AN ADJACENT TERM THAT HAS ALREADY BEEN COVERED
				  ***/

				 for (j=0; j<count; j++)              /* do for all element in pm-array */
				    {
				       memcpy(temp, (c+4+nspm*(1+ *(pm+j))), nspm);    /* pick adj term */
				       test = exist(temp,b,mb);
				       if (test == -1)                               /* already covered */
					  break;
				    }

				 if (j==count)                     /* select the 1st if all not covered */
				    j = 0;

				 adj--;                            /* no. of adj terms in c-array */
				 *(c+1) = adj;                     /* adjacency after shrinking CPT */
				 pos = *(pm+j);                    /* required position of adj term */

				 free(pm);                         /* free pointer */

				 /***
				  ***  SHRINK CPT (REMOVE 1 ADJACENT TERM FROM C-ARRAY), GENERATE NEW CPT, SSM
				  ***  AND TEST FOR COVERAGE BY FUNCTION
				  ***/

				 memcpy((c+4+nspm*(1+pos)), (c+4+nspm*(2+pos)), nspm*(adj-pos));  /* shrink CPT */

				 c = (unsigned char*) realloc(c, 4+nspm*(1+adj));   /* reduce space */
				 if (c==0)
				    {
				       printf("Out of memory -- CAMPC, *c\n");
				       printf("Program terminated - 7\n");
				       exit(0);
				    }

				 d = cpt(c);                  /* generate CPT */
				 e = ssm(d);                  /* generate SSM */
				 m = topow(*(e+1));           /* no. of SSM terms */

				 for (k=0; k<m; k++)          /* check SSM coverage by function */
				    {
				       memcpy(temp, (e+4+nspm*k), nspm);  /* pick SSM term */
				       test = exist(temp,a,ma);
				       if (test == -1)                    /* SSM term not covered */
					  break;
				    }

				 /***
				  ***  SHRINKED SSM COVERED BY FUNCTION, REDUCE B-ARRAY
				  ***  AND SELECT SHRINKED CPT AS PRODUCT TERM
				  ***/

				 if (test==0)                   /* SSM covered */
				    {
				       if (m > 65536)                  /* too many SSM terms */
					  {
					     printf("Product Term Too Huge \n");
					     printf("Program terminated \n");
					     exit(0);
					  }
				       *(e+1) = (m-1) & mask8;         /* no. of SSM terms minus 1 */
				       *(e+2) = (m-1)>>8 & mask8;
				       b = reduce(e, b, i);     /* remove minterms covered from b-array */
				       i = (char) *b;           /* update pointer to b-array */
				       mb = *(b+2)<<8 | *(b+1); /* no. of minterms in b-array */

				       s = (unsigned char *) realloc(s, 4+n*(pterm+1));  /* more space */
				       if (s==0)
					  {
					     printf("Out of memory -- CAMPC, *s\n");
					     printf("Program terminated - 8\n");
					     exit(0);
					  }
				       memcpy ((s+4+n*pterm), d, n);      /* add shrinked CPT to soln array */
				       pterm++;                           /* no. of product terms */

				       cover = 1;                         /* coverage status */
				       free(e);                           /* free pointer */
				    }
				 free (d);                      /* free pointer */
			      }
			}
		  }
	       free(c);                     /* free pointer */
	    }
	 limit++;
      }
   *s = n;                           /* no. of variables */
   *(s+1) = pterm & mask8;           /* no. of product terms in 2 bytes */
   *(s+2) = pterm>>8 & mask8;

   free(temp);                       /* free pointer */
   free(a);
   free(b);

   return(s);                        /* return solution array */
}


