#include "pt.h"
#include "string.h"

static unsigned char originalFromString[STRINGSIZE+1];
static unsigned char fromString[STRINGSIZE+1];
static unsigned char originalToString[STRINGSIZE+1];
static unsigned char toString[STRINGSIZE+1];

void pascal
/* XTAG:replaceText */
replaceText(w)
	struct window *w;
{
	extern struct window *selWindow;
	extern long selBegin, selEnd;
	extern int selMode;
	extern unsigned char msgBuffer[];
	extern unsigned char textBuffer[];
	extern int ignoreCase;
	extern int topOnFind;
	extern long addPosition;
	extern int nextChange;
	extern struct changeItem *change;
	extern unsigned int bytesLeft;
	extern unsigned char *userMessages[];
	extern unsigned int piecesLeft;
	extern int debug;
	extern struct openFile *files;

	struct window *saveSelWindow;
	long saveSelBegin, saveSelEnd, repEnd;
	int n, fileId, fromLength;
	int nLines, verify, replace, nReplaces;
	int inSelection, diffLengths;
	int saveIgnoreCase;
	long cp, toLength, fSize;
	unsigned char ch, *s;
	struct piece *tempPP, *newPP;
	struct changeItem *thisChange;

	fileId = w->fileId;
	fSize = fileSize(fileId);
	nReplaces = 0;
	
	/* check if this is a readOnly file */
	if( files[fileId].readOnly ) {
		sprintf(msgBuffer, userMessages[READONLYFILE],
			files[fileId].origName);
		msg(msgBuffer, 1);
		return;
	}

	/* get the string to search for */
	s = getInput("String to replace: ", originalFromString, 0);
	/* ESCape or empty string cancels the replace */
	if( s == NULL || s[0] == '\0' )
		goto cancelReplace;
	strncpy(originalFromString, s, STRINGSIZE+1);
	s = originalFromString;

	/* process the string to handle the newline, CR, and LF escapes */
	n = 0;
	saveIgnoreCase = ignoreCase;
	while( 1 ) {
		ch = *s;
		if( isupper(ch) && ignoreCase /* case insensitive */)
			ch = tolower(ch);
		switch( ch ) {
		case '\\':
			ch = *++s;
			if( ch == 'r' )
				ch = '\r';
			else if( ch == 'N' )
				ch = '\n';
			else if( ch == 'n' ) {
				fromString[n++] = '\r';
				ch = '\n';
			}
			break;
		default:
			break;
		}
		fromString[n++] = ch;
		if( ch == '\0' )
			break;
		++s;
		if( n >= STRINGSIZE )
			--n;
	}

	/* get the replacment string */
	sprintf(msgBuffer, "Replace `%s' with: ", originalFromString);
	s = getInput(msgBuffer, originalToString, 0);
	if( s == NULL )
		goto cancelReplace;
	strncpy(originalToString, s, STRINGSIZE);
	s = originalToString;
	/* process the replacement string for escapes */
	n = 0;
	while( 1 ) {
		ch = *s++;
		switch( ch ) {
		case '\\':
			ch = *s++;
			if( ch == 'r' )
				ch = '\r';
			else if( ch == 'N' )
				ch = '\n';
			else if( ch == 'n' ) {
				toString[n++] = '\r';
				ch = '\n';
			}
			break;
		default:
			break;
		}
		toString[n++] = ch;
		if( ch == '\0' )
			break;
	}
	
	/* replace in the selection only? */
	s = getInput("Globally (g) or Within Selection (s): ", "g", 1);
	if( s == NULL )
		goto cancelReplace;
	else if( tolower(s[0]) == 'g' || s[0] == 'y' )
		/* the getInput will return a 'y' of the left mouse button */
		/* is clicked. Construe that as a 'g' and RMB ar an 's' */
		inSelection = 0;
	else
		inSelection = 1;

	/* verify each replacement? */
	s = getInput("Verify each change? (y or n): ", "y", 1);
	if( s == NULL ) {
cancelReplace:
		msg("Replace cancelled", 1);
		ignoreCase = saveIgnoreCase;
		return;
	}
	/* save the verify boolean for later use */
	verify = !(tolower(s[0]) == 'n');

	/* Create a piece for the replacement string and record it in */
	/* the piece buffer.  This makes it easy to insert the replace */
	/* string by copying this piece */
	toLength = strlen(toString);
	tempPP = getFreePiece();

	tempPP->file = ADDFILE;
	tempPP->position = addPosition;
	for(n = 0; n < (int)toLength; n++ )
		writeChar(toString[n], addPosition++);
	tempPP->length = toLength;

	/* start from the selection or the beginning */
	if( inSelection ) {
		cp = selBegin;
		repEnd = selEnd;
		w = selWindow;
	} else {
		if( w == selWindow )
			cp = selBegin;
		else
			cp = 0;
		repEnd = fSize;
	}
	
	/* How will the replace change character counts? */
	/* we need to adjust repEnd after each replace */
	diffLengths = strlen(toString) - strlen(fromString);

	/* set things up so the line counts will be right */
	if( readChar(fileId, cp) == '\n' )
		nLines = 1;
	else
		nLines = 0;

	/* save the location of the current selection */
	if( !verify ) {
		saveSelWindow = selWindow;
		saveSelBegin = selBegin;
		saveSelEnd = selEnd;
	}
	
	fromLength = strlen(fromString);

/* while loop to repeat the replace */
while( 1 ) {

	if( !verify ) {
		sprintf(msgBuffer, "Replace is %d%% completed",
			(int)((100*cp)/fSize));
		msg(msgBuffer, 1);
	}

	/* find the string */
	cp = searchSpans(fileId, cp, repEnd, fromString, fromLength, &n);
	nLines += n;
	if( cp == (long)(-1) )
		break;
	if( selWindow != w ) {
		eraseSelection();
		selWindow = w;
	}
	selBegin = cp;
	selEnd = selBegin + fromLength - 1;
	selMode = SELCHAR;

	/* remember where we came from */
	selWindow->rowLastline = selWindow->numTopline;
	
	/* replace? */
	if( verify ) {
		/* put the selection on the third line */
		if( selBegin >= selWindow->posBotline 
		 || selBegin < selWindow->posTopline ) {
			n = 3;
			selWindow->posTopline = prevLine(fileId, selBegin, &n);
			selWindow->numTopline += nLines - n;
		}
		(void)indentToShowSelection(-1);
		/* show the string we found */
		if( topOnFind )
			topWindow(selWindow);
		redrawWindow(selWindow);
		sprintf(msgBuffer,
"[At %d%% of file] Replace this one? (y or n -- Esc to cancel) ",
			(int)((100*cp)/fSize) );
		s = getInput(msgBuffer, "y", 1);
		if( s == NULL )
			goto notFound;
		replace = tolower(s[0])=='y';
	} else
		replace = 1;
	
	/* do the replace */
	if( replace ) {
		deleteChars(selWindow->fileId, NOUPDATE, 0);
		
		/* record in the change history */
		IncrementNextChange();
		thisChange = &change[nextChange];
		thisChange->type = CINSERT;
		thisChange->position = selBegin;
		thisChange->length = toLength;
		thisChange->fileId = selWindow->fileId;
		newPP = getFreePiece();
		newPP->file = ADDFILE;
		newPP->position = tempPP->position;
		newPP->length = toLength;
		thisChange->firstPiece = newPP;
		
		copyPieces(tempPP, selWindow, selBegin, toLength, verify);
		cp = selBegin;
		/* as we change the length of the text in the file with */
		/* a replacement, we have to adjust repEnd so that we  */
		/* will not quit early */
		repEnd += diffLengths;

		if( inSelection ) {
			/* if we are not verifying, we want the final */
			/* selection to be the same as the original */
			/* selection even though we are replaceing */
			/* inside it.  This makes the adjustment */
			if( !verify )
				saveSelEnd += diffLengths;
		}
		++nReplaces;
		/* see if we are running out of space */
		if( (bytesLeft < SPACELOW)  && (piecesLeft <= 10) ) {
			msg(userMessages[LOWSPACEMSG], 3);
			goto notFound;
		}
	} else
		cp = selBegin + 1;
}

notFound:
	/* free the temp piece */
	freePieces(tempPP);

	/* restore the previous selection */
	if( !verify ) {
		selWindow = saveSelWindow;
		selBegin = saveSelBegin;
		selEnd = saveSelEnd;
		redrawWindow(selWindow);
	}
	sprintf(msgBuffer, "Made %d replacement%s", nReplaces,
		nReplaces==1?"":"s");
	msg(msgBuffer, 1);
	ignoreCase = saveIgnoreCase;
}

static unsigned char originalSearchString[STRINGSIZE+1];
static unsigned char searchString[STRINGSIZE+1];
static long foundCp;	/* used to return cp in on-interactive search */

long pascal
/* XTAG:searchExternal */
searchExternal(s, w, newSearchMode, newIgnoreCase)
	unsigned char *s;
	struct window *w;
	int newSearchMode, newIgnoreCase;
{
	extern int ignoreCase;
	extern int searchMode;

	int saveSearchMode, saveIgnoreCase;

	/* save and change the search mode state */
	saveSearchMode = searchMode;
	searchMode = newSearchMode;
	saveIgnoreCase = ignoreCase;
	ignoreCase = newIgnoreCase;

	strncpy(originalSearchString, s, STRINGSIZE+1);
	searchFor(3, w);	/* 3 means non-interactive */

	/* restore the old search mode state */
	searchMode = saveSearchMode;
	ignoreCase = saveIgnoreCase;

	return foundCp;
}

int pascal
/* XTAG:searchFor */
searchFor(repeatLast, w)
	int repeatLast;
	struct window *w;
{
	extern struct window *selWindow;
	extern long selBegin, selEnd;
	extern int selMode;
	extern unsigned char msgBuffer[];
	extern unsigned char textBuffer[];
	extern int ignoreCase;
	extern int searchMode;
	extern int realSearchMode;
	extern int topOnFind;
	extern int linesOverFind;
	extern int pathNames;
	extern struct openFile *files;
	extern int debug;
	extern int reSearch;
	extern int reLength;
	extern char reIn[];

	int n, i, linesFromTop, fileId, fid2, nLines;
	int patLength;
	int saveIgnoreCase, wrappedAround = 0;
	long cp, cp2, startCp, stopCp;
	unsigned char ch, *p, *s;

	fileId = w->fileId;
	saveIgnoreCase = ignoreCase;

	switch( repeatLast ) {

	case 0:		/* ask for the search string */
		/* get the string to search for */
		s = getInput("Search string: ", originalSearchString, 0);
		if( s == NULL ) {
			msg("Search for string cancelled", 1);
			return 1;
		}
		/* first make a copy of the search string */
		strncpy(originalSearchString, s, STRINGSIZE+1);
		if( reSearch ) {
			strcpy(searchString, originalSearchString);
			RETableSetup();
			strcpy(reIn, originalSearchString);
			if( !RECompile() ) {
				return 1;
			}
			break;
		}
	processString:
		/* then get a pointer to it that we can change */
		s = originalSearchString;
		if( s[0] != '\0' ) {	/* non-empty string? */
			p = searchString;
			while( 1 ) {
				ch = *s;
				/* case insensitive search? */
				if( isupper(ch) && ignoreCase )
					ch = tolower(ch);
				switch( ch ) {
				case '\\':
					ch = *++s;
					if( ch == 'r' )
						ch = '\r';
					else if( ch == 'N' )
						ch = '\n';
					else if( ch == 'n' ) {
						*p++ = '\r';
						ch = '\n';
					}
					break;
				default:
					break;
				}
				*p = ch;
				if( *p++ == '\0' )
					break;
				++s;
				if( p-searchString >= STRINGSIZE ) {
					*--p = '\0';
					*--s = '\0';
					break;
				}
			}
		}
		/* else if string is empty, reuse the last string entered */
		break;

	case 1:		/* use the selection as a search string */
		/* we will make an original copy and a processed copy */
		s = originalSearchString;
		p = searchString;
		cp = selBegin;
		fid2 = selWindow->fileId;
		while( cp <= selEnd ) {
			ch = readChar(fid2, cp++);
			*s++ = ch;	/* original copy */
			/* case insensitive search? */
			if( isupper(ch) && ignoreCase )
				ch = tolower(ch);
			*p++ = ch;	/* processed copy */
			if( (p-searchString) >= STRINGSIZE ) {
				/* truncate long search strings */
				--p;
				--s;
				break;
			}
		}
		*p = '\0';
		*s = '\0';
		if( reSearch ) {
			strcpy(searchString, originalSearchString);
			RETableSetup();
			strcpy(reIn, originalSearchString);
			if( !RECompile() ) {
				return 1;
			}
			break;
		}
		break;

	case 2:		/* use the last entered string */
	case 3:
		goto processString;
	}
	/* do not allow searching for the empty string */
	if( searchString[0] == '\0' ) {
		sprintf(msgBuffer, "Search string is empty");
		goto errorExit;
	}

	switch( searchMode ) {
	case 0:
		s = "forwards";
		break;
	case 1:
		s = "backwards";
		break;
	case 2:
		s = "circularly";
		break;
	case 3:
		n = (pathNames ? 0 : w->nameOffset);
		s = &((files[w->fileId].origName)[n]);
		break;
	}
	if( repeatLast != 3 ) {
		sprintf(msgBuffer, "Searching %s for `%s'", s,
			originalSearchString);
		msg(msgBuffer, 1);
	}
	patLength = strlen(searchString);
	n = -1;
	if( readChar(fileId, cp) == '\n' )
		nLines = 1;
	else
		nLines = 0;
	cp = fileSize(w->fileId);
	if( searchMode == 1 ) {
		startCp = 0;
		if( w == selWindow )
			stopCp = selBegin - 1;
		else
			stopCp = cp - 1;
	} else {	/* seachMode == 0 or == 2 */
		stopCp = cp;
		if( w == selWindow ) {
			startCp = selBegin + 1;
			if( startCp >= stopCp ) {	/* already done? */
				if( searchMode == 0 || searchMode == 3 )
					goto notFound;
				else	/* searchMode==2 */
					startCp = 0;
			}
		} else
			startCp = 0;
	}
	linesFromTop = 0;
	/* adjust the line number */
	/* just put in the two while loops and forget the IF test */
	/* at most one of the WHILE loops will actually loop */
	/* adjust for backwards searching */
	cp2 = w->posTopline;
	if( searchMode == 1 ) {
		cp = stopCp + 1;
		if( cp > fileSize(w->fileId) )
			--cp;
	} else {
		cp = startCp - 1;
		if( cp < 0 )
			cp = 0;
	}
	/* normalize cp to the beginning of its line */
	i = -1;
	cp = prevLine(fileId, cp, &i);
	while( cp2 < cp ) {
		++linesFromTop;
		i = 1;
		cp2 = nextLine(fileId, cp2, &i);
	}
	while( cp2 > cp ) {
		--linesFromTop;
		i = 1;
		cp2 = prevLine(fileId, cp2, &i);
	}

	switch( searchMode ) {
	default:
	case 3:
	case 0:
		if( reSearch )
			cp = reSpans(fileId, startCp, stopCp,
				&patLength, &n);
		else
			cp = searchSpans(fileId, startCp, stopCp,
				searchString, patLength, &n);
		nLines += n;
		break;
	case 1:
		cp = searchReverseSpans(fileId, startCp, stopCp,
				searchString, patLength, &n);
		nLines -= n;
		/* a fix so that backwards search from the backwards */
		/* search command is circular if the normal search */
		/* mode is circular */
/********************* DO NOT DO THIS YET ************
 THE PROBLEM IS GETTING THE LINE NUMBERS TO WORK OUT
 FINISH IT LATER
		if( cp == -1 && realSearchMode == 2 ) {
			wrappedAround = 1;
			cp = searchReverseSpans(fileId, stopCp,
				fileSize(w->fileId) - patLength,
				searchString, patLength, &n);
			nLines = n;
			linesFromTop = -(selWindow->numTopline);
		}
*******************************************************/
		break;
	case 2:
		if( reSearch )
			cp = reSpans(fileId, startCp, stopCp,
				&patLength, &n);
		else
			cp = searchSpans(fileId, startCp, stopCp,
				searchString, patLength, &n);
		nLines += n;
		if( cp == -1 ) {
			wrappedAround = 1;
			if( reSearch )
				cp = reSpans(fileId, 0L, startCp,
					&patLength, &n);
			else
				cp = searchSpans(fileId, 0L, startCp,
					searchString, patLength, &n);
			nLines = n;
			linesFromTop = -(selWindow->numTopline);
		}
		break;
	}

	if( repeatLast == 3 ) {
		foundCp = cp;
		return 0;
	}

	if( cp != -1 ) {
		if( selWindow != w ) {
			eraseSelection();
			selWindow = w;
		}
		selBegin = cp;
		selEnd = selBegin + patLength - 1;
		selMode = SELCHAR;
	} else
		goto notFound;

	if( selBegin >= selWindow->posBotline 
	 || selBegin < selWindow->posTopline ) {
		/* remember where we came from */
		selWindow->rowLastline = selWindow->numTopline;
	 	n = -1;
		cp2 = prevLine(fileId, selBegin, &n);
		/* find the number of lines in the window */
		n = selWindow->row2 - selWindow->row1 - 2;
		if( linesOverFind > n )
			/* if linesOverFind would place it outside the */
			/* window then put it in the middle of the window */
			n >>= 1;
		else
			/* otherwise put it linesOverFind lines down */
			n = linesOverFind;
		selWindow->posTopline = prevLine(fileId, cp2, &n);
		selWindow->numTopline += linesFromTop + nLines - n;
	}
	(void)indentToShowSelection(-1);
	if( topOnFind )
		topWindow(selWindow);
	redrawWindow(selWindow);
	/* this will erase the "Searching for..." msg in the case where */
	/* the selWindow does not extend to the bottom line */
	if( wrappedAround )
		msg( "Circular search has wrapped around"
			" the beginning of the file", 1);
	else
		msg("", 1);
	ignoreCase = saveIgnoreCase;
	return 1;
notFound:
	sprintf(msgBuffer, "String `%s' not found.", searchString);
errorExit:
	msg(msgBuffer, 1);
	ignoreCase = saveIgnoreCase;
	return 0;
}

extern unsigned	char *
	match1dn( unsigned char far *, int, unsigned char, unsigned char );
extern unsigned char *
	match2dn( unsigned char far *, int, unsigned char );
extern int countnl( unsigned char far *, int );

long pascal
/* XTAG:searchSpans */
searchSpans(fileId, startCp, stopCp, patString, patLength, linesPassed)
	int fileId, patLength, *linesPassed;
	long startCp, stopCp;
	unsigned char *patString;
{
	extern unsigned char msgBuffer[];
	extern int ignoreCase;
	extern int findWholeWords;
	extern int debug;

	unsigned char *pat;
	unsigned char far *firstChar;
	unsigned char far *lastChar;
	unsigned char *p;
	unsigned char ch1, ch2, ch3;
	int matched, len, nLines;
	long cp, longPatLength;

	/* find the upper and lower case character */
	ch1 = *patString;
	if( !ignoreCase )
		ch2 = ch1;
	else if( 'a' <= ch1 && ch1 <= 'z' )
		ch2 = ch1 - 'a' + 'A';
	else if( 'A' <= ch1 && ch1 <= 'Z' )
		ch2 = ch1 - 'A' + 'a';
	else
		ch2 = ch1;

	/* set up a long version of patLength-1 for comparisons */
	longPatLength = (long)(patLength - 1);
	
	nLines = 0;
	
	/* set things up so getSpan is called right away */
	firstChar = (unsigned char far *)1;
	lastChar = (unsigned char far *)0;

	/* each iteration of this loop scans one span */
	while( 1 ) {
		/* see if there are enough characters left in the */
		/* area we are searching to match the pattern */
		if( (stopCp - startCp) < longPatLength )
			break;

		/* find the first character of the string */
		if( firstChar > lastChar ) {
			if(getSpan(fileId,startCp,&firstChar,&lastChar,0))
				/* getSpan says startCp at EOF */
				break;
			/* check to see if the span is longer than the */
			/* area we are supposed to search */
			if( (long)(lastChar-firstChar) > (stopCp-startCp) ) {
				/* if it is too long then adjust lastChar */
				lastChar = firstChar + (stopCp - startCp);
			}
		}
		len = (int)(lastChar - firstChar) + 1;
		if( ch1 == ch2 )
			p = match2dn(firstChar, len, ch1);
		else
			p = match1dn(firstChar, len, ch1, ch2);
		if( p == (unsigned char *)0xFFFE ) {
			startCp += len;
			nLines += countnl(firstChar, len);
			firstChar = (unsigned char far *)1;
			lastChar = (unsigned char far *)0;
			continue;
		}
		/* move startCp up past the matched character */
		len = p - (unsigned char *)(FP_OFF(firstChar));
		nLines += countnl(firstChar, len);
		startCp += len;
		
		/* change the offset of firstChar, segment not changed */
		*( (unsigned char **)(&firstChar) ) = p;

		/* start looking at the second character of the pattern */
		pat = patString + 1;
		matched = 1;	/* 1 character matched so far */
		
		/* search for a match at startCp */
		cp = startCp;
		while( matched < patLength ) {
			/* see if we are still in the span */
			if( firstChar > lastChar )
				getSpan(fileId, cp, &firstChar, &lastChar, 0);
			/* stop at a mismatch */
			ch3 = *firstChar++;
			++cp;
			if( ignoreCase && 'A' <= ch3 && ch3 <= 'Z' )
				ch3 = ch3 - 'A' + 'a';
			if( *pat++ != ch3 )
				break;
			if( ch3 == '\n' )
				++nLines;
			++matched;
		}
		if( matched == patLength ) {
			/* we found the string */
			/* now does it have to be a whole word? */
			if( findWholeWords ) {
				/* make sure the character before it is */
				/* not alphanumeric or "_" */
				ch3 = readChar(fileId, startCp-2);
				matched = !isalnum(ch3) && ch3 != '_';
				if( matched ) {
					/* and the char after it also */
					ch3 = readChar(fileId,
						startCp+patLength-1);
					matched =
						!isalnum(ch3) && ch3 != '_';
				}
			} else
				matched = 1;
			if( matched ) {
				*linesPassed = nLines;
				return startCp - 1;
			}
		}
		firstChar = (unsigned char far *)1;
		lastChar = (unsigned char far *)0;
	}
	*linesPassed = nLines;
	return (long)(-1);
}

extern unsigned char *
	match1up( unsigned char far *, int, unsigned char, unsigned char );

long pascal
/* XTAG:searchReverseSpans */
searchReverseSpans(fileId, startCp, stopCp, patString, patLength, linesPassed)
	int fileId, patLength, *linesPassed;
	long startCp, stopCp;
	unsigned char *patString;
{
	extern unsigned char msgBuffer[];
	extern int ignoreCase;
	extern int debug;
	extern int findWholeWords;

	unsigned char *pat;
	unsigned char far *firstChar;
	unsigned char far *lastChar;
	unsigned char *p;
	unsigned char ch1, ch2, ch3;
	int matched, len, nLines;
	long cp;

	/* find the upper and lower case character */
	ch1 = *patString;
	if( !ignoreCase )
		ch2 = ch1;
	else if( 'a' <= ch1 && ch1 <= 'z' )
		ch2 = ch1 - 'a' + 'A';
	else if( 'A' <= ch1 && ch1 <= 'Z' )
		ch2 = ch1 - 'A' + 'a';
	else
		ch2 = ch1;

	/* set up nLines correctly */
	nLines = 0;
	len = patLength - 1;

	/* set things up so getSpan is called right away */
	firstChar = (unsigned char far *)1;
	lastChar = (unsigned char far *)0;

	/* each iteration of this loop scans one span */
	while( stopCp >= startCp ) {

		/* find the first character of the string */
		if( firstChar > lastChar ) {
			/* '1' (last argument) means get a reversed span */
			getSpan(fileId, stopCp, &firstChar, &lastChar, 1);
		}
		len = (int)(lastChar - firstChar) + 1;
		p = match1up(lastChar, len, ch1, ch2);
		if( p == (unsigned char *)0xFFFE ) {
			stopCp -= len;
			nLines += countnl(firstChar, len);
			firstChar = (unsigned char far *)1;
			lastChar = (unsigned char far *)0;
			continue;
		}
		/* move stopCp up past the matched character */
		/* (remember that match1up returns a pointer to the */
		/* character BEFORE the one matched) */
		len = FP_OFF(lastChar) - (unsigned)p;
		stopCp -= len;
		/* Special case: If the character was found in position */
		/* 0 then match1up returns -1 (0xFFFF) to p.  The len */
		/* calculation above works but this makeFarPointer will */
		/* not so we change it to 0 so the line count is okay. */
		if( (unsigned)p == 0xFFFF )
			p = 0;
		firstChar = makeFarPointer((unsigned int)p, FP_SEG(lastChar));
		nLines += countnl(firstChar, len);
		firstChar = (unsigned char far *)1;
		lastChar = (unsigned char far *)0;

		/* start looking at the second character of the pattern */
		pat = patString + 1;
		matched = 1;	/* 1 matched character so far */
		
		/* search for a match at startCp */
		cp = stopCp + 2;
		while( matched < patLength ) {
			/* see if we are still in the span */
			if( firstChar > lastChar ) {
				getSpan(fileId, cp, &firstChar, &lastChar, 0);
			}
			/* stop at a mismatch */
			ch3 = *firstChar++;
			++cp;
			if( ignoreCase && 'A' <= ch3 && ch3 <= 'Z' )
				ch3 = ch3 - 'A' + 'a';
			if( *pat++ != ch3 )
				break;
			++matched;
		}
		if( matched == patLength ) {
			/* we found the string */
			/* now does it have to be a whole word? */
			if( findWholeWords ) {
				/* make sure the character before it is */
				/* not alphanumeric or "_" */
				ch3 = readChar(fileId, stopCp);
				matched = !isalnum(ch3) && ch3 != '_';
				if( matched ) {
					/* and the char after it also */
					ch3 = readChar(fileId,
						stopCp+patLength+1);
					matched =
						!isalnum(ch3) && ch3 != '_';
				}
			} else
				matched = 1;
			if( matched ) {
				*linesPassed = nLines;
				return stopCp + 1;
			}
		}
		firstChar = (unsigned char far *)1;
		lastChar = (unsigned char far *)0;
	}
	*linesPassed = nLines;
	return (long)(-1);
}
