{  paint a screen of "cells" of shades.
   The cells correspond to print positions, so the screen
   can be printed on a line printer (Low-res graphics)
}

{$V-}    (* Allow small strings to be passed to procedures *)

const  RIGHT = 75;     (* "effective" right edge of screen, 80 for good mon *)
       WinWidth = 20;
       WinHite = 19;   (* height of menu window *)
       MAXBRUSH = 15;
type   MenuItem = string [WinWidth];
       prompt = array [1..5] of MenuItem;
       filename = string [14];
       WinID = 1..2;
       PagArr = array [0..80, 0..70] of byte;
       palette = string [MAXBRUSH];
const  OldXlate : palette = ' .oXM';
                       (* translate from brush code to old character *)
       PXlate : palette = ' .:XM    |-+\/X';  (* print translation *)
       SXlate : palette = '123456789|-+\/X';  (* SFile translation *)
       FilMsg1 : prompt = ('fill to','Darker or Lighter','edge?','','');
var    line,page : integer;   (* columns & rows on print page *)
       xcell,ycell: integer;  (* # of pixels in a cell *)
       brush : integer;       (* code for painting a cell *)
                              (*  0 - no permanent effect
                                  1-5 progressively heavier tones
                                  6-9 currently unassigned
                                  10-15 = | - + \ / X
                              *)
       FillFlag : integer;    (* used to indicate the nature of the fill *)
       ErrMsg : MenuItem;
       fname, pname : filename;   (* file name & print device name *)
       x,y : integer;         (* col,row position of cursor *)
       bkgnd, inchar : char;
       screen : PagArr;       (* array of brush values *)
       linecount : array [1..2] of integer;
                              (* line counters for windows *)

procedure blink; forward;


{$I pixel.pas }
{$i ptutils.pas }
{$I ptfile.pas }



procedure blink;   {  blinks the cursor until key is pressed  }
    var   curs : integer;
    begin
        ResetWin (2);
        window (2, ErrMsg); (* print the most recent error message *)
        curs := 5;
        while not KeyPressed do   (* blink until next keystroke *)
        begin
            if curs=5 then curs:=1  else curs:=5;
            dab (x,y, curs);
            delay (60);
        end;
        ErrMsg := '                    ';
    end;

{$I ptfancy.pas }

procedure MenuDisp;  { displays the menu of commands }
    var    line : integer;
    begin
        linecount[1]:=4;   (* start menu on fourth line *)
        window (1, 'COMMANDS');
        window (1, ' ');
        window (1, 'Quit');
        window (1, 'Save');
        window (1, 'Load');
        window (1, 'Print');
        window (1, 'Mirror');
        window (1, 'Fill');
        window (1, 'Restore screen');
    end;

procedure RestorScr;
    var    i,j : integer;
    begin
        HiRes;
        if bkgnd='W' then wpage (xcell*line, ycell*page)
        else            boxpage (xcell*line, ycell*page);
        MenuDisp;
        brush:=0;       (* start with dry brush *)

        for j:=0 to (page-1) do
            for i:=0 to (line-1) do
                if screen [i,j]>1 then dab (i,j, screen [i,j]);
    end;

begin
{ initialize parameters for the program }
    line:=79;
    page:=66;
    brush:=0;
    bkgnd:='B';
    ErrMsg:='                    ';
    linecount[2] := WinHite + 1;
    fname:='';  pname:='CON:';

    xcell:=4; ycell:=3;
    for x:=0 to line do for y:=0 to page do  screen [x,y] := 1;
    x:=line div 2;  (* start in the middle of page *)
    y:=page div 2;

    RestorScr;

{ MAIN WORKING LOOP }
    repeat
        blink;
        read (kbd, inchar);
        case  inchar of
        ^[:  begin   (* ESC is cursor control *)
             if brush>0 then  screen[x,y] := brush;
             dab (x,y, screen[x,y]);   (* paint cell before leaving *)
             read (kbd, inchar);
             case inchar of
             'G':  (* up & left *)
                  if (x-1>=0) and (y-1>=0) then
                  begin  x := x-1;  y := y-1; end;
             'H':  (* up *)
                  if y-1>=0 then
                  y := y-1;
             'I':  (* up & right *)
                  if (x+1<line) and (y-1>=0) then
                  begin  x := x+1;  y := y-1;  end;
             'M':  (* right *)
                  if x+1<line then
                  x := x+1;
             'Q':  (* down & right *)
                  if (x+1<line) and (y+1<page) then
                  begin  x := x+1;  y := y+1;  end;
             'P':  (* down *)
                  if y+1<page then
                  y := y+1;
             'O':  (* down & left *)
                  if (x-1>=0) and (y+1<page) then
                  begin  x := x-1;  y := y+1;  end;
             'K':  (* left *)
                  if x-1>=0 then
                  x := x-1;
             end;
                inchar := ' ';   (* kill for Quit check *)
                if brush>0 then  screen[x,y] := brush;
             end;

        '0':         (* turn off the brush *)
             brush := 0;

        '1'..'9','|','-','+','\','/','X':  (* change the brush *)
             begin
                 brush := pos (inchar, SXlate);
                 screen [x,y] := brush;
             end;

         'l','L':   (* load a file from disk *)
             if verify ('LOAD?') then
             begin
                 load (fname, screen, SXlate);
                 RestorScr;
             end;

         's','S':   (* save in a file *)
             if verify ('SAVE?') then
             begin
                 fname := getname(fname, 0);
                 save (fname, screen, SXlate);
             end;

         'p','P':   (* print on the line printer *)
             if verify ('PRINT?') then
             begin
                 pname := getname(pname, 0);
                 save (pname, screen, PXlate);
                 if pname='CON:' then  RestorScr;
             end;

         'r','R':   (* restore a corrupted screen image *)
             RestorScr;

         'm','M':   (* mirror the screen about an axis *)
             if verify ('MIRROR?') then
             begin
                 mirror;
             end;

         'f','F':   (* fill an area *)
             if verify ('FILL?') then
             begin
                 ClrWin (2);
                 window (2, 'BRUSH value is');
                 window (2, SXlate [brush] );
                 window (2, 'OK?  (Y/N)');
                 read (kbd, inchar);
                 if (inchar='y') or (inchar='Y') then
                 begin
                     inchar := getchar (FilMsg1);

                     case inchar of
                      'd','D': FillFlag := 4;
                      'l','L': FillFlag := 3;
                      else  FillFlag := 5;  (* assure that fill never starts *)
                     end;

                     if FillFlag<5 then  fill (x,y);
                 end;
                 ClrWin (2);
             end;

       { ADD NEW COMMANDS HERE }

         'q','Q':   (* looks like QUIT, but let's check *)
             if not (verify ('QUIT???')) then inchar := ' ';

         else  ErrMsg:= concat(inchar,': NO SUCH COMMAND');
         end;

    until (inchar='Q') or (inchar='q');

    Alfa;
