REM file: DTA.TXT
REM -- describes Data Transfer Area structure

TYPE RegTypeX
 AX AS INTEGER
 BX AS INTEGER
 CX AS INTEGER
 DX AS INTEGER
 BP AS INTEGER
 SI AS INTEGER
 DI AS INTEGER
 Flags AS INTEGER
 DS AS INTEGER
 ES AS INTEGER
END TYPE

DECLARE SUB InterruptX(N AS INTEGER,I AS RegTypeX,O AS RegTypeX)

DIM InregsX AS RegTypeX, OutregsX AS RegTypeX

TYPE DTAtype
 Drive AS STRING * 1
 SearchTemplate AS STRING * 11
 SearchAttr AS STRING * 1
 EntryCount AS STRING * 2
 ClusterNumber AS STRING * 2
 Reserved AS STRING * 4
 FileAttr AS STRING * 1
 FileTime AS STRING * 2
 FileDate AS STRING * 2
 FileSize AS STRING * 4
 ASCIZfilename AS STRING * 13
END TYPE

 ' store basic dta
 InregsX.AX = &H2F00
 CALL InterruptX(&H21, InregsX, OutregsX)
 BASIC.DTA.SEG = OutregsX.ES
 BASIC.DTA.OFF = OutregsX.BX

 ' declare structures
 DIM ParseDTA AS DTAtype
 DIM ASCIZ AS STRING *260

 ' reset search dta
 InregsX.AX = &H1A00
 InregsX.DS = VARSEG(ParseDTA)
 InregsX.DX = VARPTR(ParseDTA)
 CALL InterruptX(&H21, InregsX, OutregsX)

 ' find first filename
 ASCIZ = "FILENAME.EXT" + CHR$(0)
 InregsX.AX = &H4E00
 InregsX.CX = &H27
 InregsX.DS = VARSEG(ASCIZ)
 InregsX.DX = VARPTR(ASCIZ)
 CALL InterruptX(&H21, InregsX, OutregsX)

 ' check findfirst error
 IF (OutregsX.Flags AND &H1) = &H0 THEN
    ' store file attribute
    Attribute% = ASC(ParseDTA.FileAttr)
    IF (Attribute% AND &H1) = &H1 THEN
       PRINT "Read-only"
    END IF
    IF (Attribute% AND &H2) = &H2 THEN
       PRINT "Hidden"
    END IF
    IF (Attribute% AND &H4) = &H4 THEN
       PRINT "System"
    END IF
    IF (Attribute% AND &H10) = &H10 THEN
       PRINT "Directory"
    END IF
    IF (Attribute% AND &H20) = &H20 THEN
       PRINT "Archive"
    END IF
 END IF

 ' restore basic dta
 InregsX.AX = &H1A00
 InregsX.DS = BASIC.DTA.SEG
 InregsX.DX = BASIC.DTA.OFF
 CALL InterruptX(&H21, InregsX, OutregsX)
