rem ----------2167-------------------------------
rem INT 21 - DOS 3.3+ - SET HANDLE COUNT
rem     AH = 67h
rem     BX = size of new file handle table for process
rem Return: CF clear if successful
rem     CF set on error
rem     AX = error code (see AH=59h)
rem Notes: If BX <= 20, no action is taken if the handle limit has not yet
rem     been increased, and the table is copied back into the PSP if the
rem     limit is currently > 20 handles. For for file handle tables of > 20
rem     handles, DOS 3.30 never reuses the  same memory block, even if the
rem     limit is being reduced; this can lead to memory fragmentation as a
rem     new block is allocated and the existing one freed. Only the first 20
rem     handles are copied to child processes in DOS 3.3.
rem BUG:  The original release of DOS 3.30 allocates a full 64K for the handle
rem       table on requests for an even number of handles

 DefInt A-Z
 Rem $Include: 'qbx.bi'
 Dim Inregs As RegType, OutRegs As RegType

 Print "Note:"
 Print "   This utility will not actually increase the number of file handles"
 Print "   beyond the amount specified in the FILES= statement in CONFIG.SYS."
 Print "   DOS itself uses 4 file handles for standard devices. The increased"
 Print "   file handles are only allocated for the program calling the handle"
 Print "   interrupt then they are released after program termination."
 Print

 On Error Goto 103
 Do
    FileName$="Tempfile.Dat"
    Close
 101
    Temp=1
    Do
       Open FileName$ For Random Shared As Temp
       Temp=Temp+1
    Loop
 102
    Close
    Print "Free file handles(plus DOS devices):";(Temp+4)
    Print "Increase file handles(y/n)?";
    Do
       I$=Inkey$
       While I$=""
          I$=Inkey$
       Wend
       If Lcase$(I$)="y" Then
          Print "y"
          Print "Set to <20 for default,"
          Print "then >20 to increase."
          Print "Enter number of handles";
          Input Var
          Print "Setting file handle count to";Var
          Inregs.AX=&H6700
          Inregs.BX=Var
          Call Interrupt(&H21,Inregs,Outregs)
          If (Outregs.Flags And &H1)=&H1 Then
             Print "Error:"+Str$(Outregs.AX)
          Endif
          Exit Do
       Endif
       If Lcase$(I$)="n" Then
          Print "n"
          End
       Endif
    Loop
 Loop
 End

103
 If Erl=101 Then
    Resume 102
 Endif
 Stop
