/* STRUTILS.H - Library code for string routines.             Revision 1.02
   Copyright (c) 1995 Robert B. Clark <rclark@iquest.net>
   ------------------------------------------------------------------------
   HISTORY:
   --------
   Rev 1.00   3 Jul 96   Cleaned up header and added to MYLIB.LIB
   Rev 1.01  18 Jul 96   Added iDecimal() function.
   Rev 1.02  22 Jul 96   Optimized Expand().
   ------------------------------------------------------------------------
   FUNCTION LIST:

   =================================================================
   char * iDecimal(float num, const char *fmt, const char * decimal)
   =================================================================
   Converts a float 'num' to a string and replaces the char '.' with the
   '*decimal' character.  The string will be formatted using '*fmt' as a
   sprintf() template.  If '*decimal' is NULL, then the decimal point
   character for the country detected at runtime will be used instead.

   The maximum length of the converted string is DECNUM_LEN.

   RETURNS: Char pointer to converted string or NULL if error.

   ==================================================
   char * Expand(unsigned long num, const char * sep)
   ==================================================
   Converts long int 'num' to a string and inserts the '*sep' character
   every three digits (commatize number).  If '*sep' is NULL, then the
   thousands' separator character for the country detected at runtime will
   be used instead.

   The maximum length of the converted string is EXPNUM_LEN.

   RETURNS: Char pointer to expanded string or NULL if error.
   ------------------------------------------------------------------------
*/
#ifndef __STRUTILS_H
#define __STRUTILS_H

#include <stdio.h>      /* For perror() */
#include <stdlib.h>     /* For ultoa(), malloc() */
#include <string.h>     /* For strcpy() */
#include <ctype.h>      /* For tolower() & toupper() */
#include <dos.h>        /* For country struct */
#include <values.h>     /* For HIBITL */
/* --------------------------------------------------------------------- */
/* Defines */

#undef MODULE_NAME
#undef MODULE_VERSION

#define MODULE_NAME        "STRUTILS"
#define MODULE_VERSION     "1.02"

#ifdef __TURBOC__                /* TC forgot to append a L to constant */

#ifdef HIBITL                    
#undef HIBITL
#endif

#endif   /* __TURBOC__ */

#define HIBITL             0x80000000L

#define EXPNUM_LEN         15    /* Max length of expanded number string */
#define DECNUM_LEN         15    /* Max length of decimal number string */
/* --------------------------------------------------------------------- */
/* Prototypes */

char * iDecimal(float num, const char *fmt, const char *decimal);
char * Expand(unsigned long num, const char *thsep);

#endif   /* __STRUTILS_H */
