;----------------------------------------------------------------------------
; Module:	justone.asm
; Author:	David Sparks
; Revision:	07/15/91	Version 2.0
; Description:
;
; This program is a DESQView Shared Program to prevent multiple
; instances of the same program from running simultaneously.
;
; (c) Copyright 1991 Heartsong Productions
;----------------------------------------------------------------------------

	INCLUDE	DVAPI.INC

	.MODEL	TINY

	assume	ds:NOTHING,es:NOTHING,ss:NOTHING

DV_LEVEL	EQU	0200h		;Ver 2.00

	.CODE
	ORG	0
;----------------------------------------------------------------------------
; Common jump for entry and exit code
;----------------------------------------------------------------------------

JustOne		PROC	FAR
	jcxz	Entry

;----------------------------------------------------------------------------
; This is the exit code
;----------------------------------------------------------------------------

	ret

;----------------------------------------------------------------------------
; This is the entry code
;----------------------------------------------------------------------------

Entry:
	cld				;direction flag forward
	mov	bp,sp			;set up stack frame

;----------------------------------------------------------------------------
; check DESQView API level
;----------------------------------------------------------------------------

	mov	bx,DV_LEVEL		;set API level
	@CALL	APILEVEL

;----------------------------------------------------------------------------
; calculate the length of the shared program data
;----------------------------------------------------------------------------

	les	di,8[bp]		;get pointer to data
	xor	al,al			;check for null
	mov	cx,4[bp]		;max. data length

	repnz	scasb			;scan for zero
	mov	bx,4[bp]		;get data length
	dec	bx			;-1
	sub	bx,cx			;calculate length
	jz	BadSemaphore

;----------------------------------------------------------------------------
; check the semaphore
;----------------------------------------------------------------------------

	mov	di,8[bp]		;get pointer
	mov	cx,bx			;length to cx
	@CALL	FINDMAIL		;find mailbox
	test	bx,bx			;check status
	jnz	OnlyOne			;already exists

;----------------------------------------------------------------------------
; set our mailbox name to the semaphore name
;----------------------------------------------------------------------------

	push	es			;pointer to semaphore name
	push	di
	xor	dx,dx
	push	dx			;length
	push	cx
	@SEND	SETNAME,MAILME

;----------------------------------------------------------------------------
; everything is OK.
;----------------------------------------------------------------------------

	mov	sp,bp			;restore stack ptr
	clc				;clear carry flag
	ret	12

;----------------------------------------------------------------------------
; OnlyOne
;----------------------------------------------------------------------------

OnlyOne:
	lea	di,OnlyOneMsg		;point to error message
	mov	bx,OnlyOneMsgSize	;get size of message
	call	DispError		;display message

;----------------------------------------------------------------------------
; Be sure that this task continues to run
;----------------------------------------------------------------------------

	mov	[MgrCtrl],87h		;allow to run in background
	lea	di,MgrStream		;point to stream
	push	cs			;save ptr on stack
	push	di
	xor	dx,dx			;MSB of length
	push	dx
        mov     cx,MgrStreamLen		;LSB of length
	push	cx
        @SEND	WRITE,ME		;send message to this window

;----------------------------------------------------------------------------
; Move original instance to foreground
;----------------------------------------------------------------------------

	mov	[MgrCtrl],0c1h		;move to foreground
	push	cs			;save ptr on stack
	push	di
	push	dx			;save length on stack
	push	cx
	xor	si,si
	@SEND	WRITE,DSSI		;send to original task
	jmp	ErrorExit

;----------------------------------------------------------------------------
; No semaphore name
;----------------------------------------------------------------------------

BadSemaphore:
	lea	di,NoSema4Msg		;point to error message
	mov	bx,NoSema4MsgSize	;get size of message
	call	DispError		;display error message
	mov	sp,bp			;restore stack

ErrorExit:
	xor	ax,ax			;tell DV not to display message
	stc				;indicate failure
	ret	12
JustOne		ENDP


;----------------------------------------------------------------------------
; DispError
;
; Entry:
;	DI -> error message
;	DX = message length
;----------------------------------------------------------------------------

DispError	PROC	NEAR
	mov	ax,cs			;get code seg
	mov	es,ax			;point to code seg
	mov	dx,ss			;get target handle
	xor	cx,cx			;let DV decide window size
	@CALL	DISPEROR
	ret
DispError	ENDP

;----------------------------------------------------------------------------
; Data
;----------------------------------------------------------------------------

NoSema4Msg	db	"Semaphore name required in shared data field"
NoSema4MsgSize	equ	$-NoSema4Msg
OnlyOneMsg	db	"Only one instance of this program allowed.  Switching to original instance..."
OnlyOneMsgSize	equ	$-OnlyOneMsg
MgrStream	db	1Bh,10h,1,0	;stream header
MgrCtrl		db	0		;command byte goes here
MgrStreamLen equ        $-MgrStream

	END

