;************************************************************************
;*									*
;*	DV-GLUE		DESQview and DESQview/X Function Library	*
;*			(c) Copyright 1993 Ralf Brown			*
;*			All Rights Reserved.				*
;*									*
;*	File DVINIT.ASM		Initialize DV-GLUE system		*
;*									*
;************************************************************************
;LastEdit: 1/13/93

	INCLUDE API.INC
	$DVG$MIN_VER equ 0200h

	Header@

MAX_EXITFUNCS equ 20

;========================================================================

DSeg@
bad_version_msg db "This program requires DESQview v"
major_version	db "2"
		db "."
minor_version	db "00"
		db " or higher.",13,10
		db "Press a key....",13,10
bad_version_msg_len equ $-bad_version_msg

initialized	db 0
exited		db 0
num_exitfuncs	db 0

PubSym@ DVSEND_ERROR_RECOVERY,<db 0>,__PASCAL__

ExtSym@ _dvversion,WORD,__CDECL__
DSegEnd@

;========================================================================

BSeg@
public __tvversion
__tvversion label word
PubSym@ _tvminor,<DB ?>,__CDECL__
PubSym@ _tvmajor,<DB ?>,__CDECL__

dv_exitfuncs db MAX_EXITFUNCS*cPtrSize

BSegEnd@

;========================================================================

VerStartSeg@
start_version_list label byte
VerStartEnd@

VerLastSeg@
end_version_list label byte
VerLastEnd@

;========================================================================

CSeg@

ExtProc@ DVVER,__PASCAL__
ExtProc@ atexit,__CDECL__

;------------------------------------------------------------------------

determine_req_version proc near
	mov	cx,REQUIRED_DV_VERSION
	mov	bx,offset DGROUP:start_version_list
drv_loop:
	cmp	bx,offset DGROUP:end_version_list
	jae	got_req_version
	cmp	cx,[bx]
	jae	drv_loopend
	mov	cx,[bx]
drv_loopend:
	jmp	drv_loop
determine_req_version endp

PubProc@ DVINIT,__PASCAL__
@req_ver = word ptr [bp+Overhead]
	@Enter
	mov	al,1
	xchg	al,DGROUP:initialized
	or	al,al
	jnz	DVinit_done
	mov	ax,1022h		; get TopView version
	xor	bx,bx
	int	15h
	xchg	bh,bl			; major version returned in low byte
	mov	__tvversion,bx		; store TopView version
	call	DVVER@
	;
	; verify that we are running under a correct version of DESQview
	;
	mov	cx,@req_ver
	jcxz	determine_req_version
got_req_version:
	cmp	cx,ax			; AX still actual version, CX = req ver
	jbe	version_OK
bad_version:
	add	ah,'0'
	mov	major_version,ah
	aam
	add	ax,'00'
	mov	word ptr minor_version,ax
	mov	ah,40h			; write to file handle
	mov	bx,2			; stderr
	mov	cx,bad_version_msg_len
	mov	dx,offset DGROUP:bad_version_msg
	int	21h
	mov	ax,0C08h		; clear keyboard buffer and get key
	int	21h
	mov	ax,4CFFh		; terminate program
	int	21h
	int	20h			; just in case someone tries it under DOS 1.x

version_OK:
	mov	bx,ax
	mov	ax,110Bh		; set API level to required version
	int	15h
	cmp	ax,2			; very early 2.00?
	jne	no_workaround
	mov	bx,2			; yes, so use (erroneous) swapped bytes
	mov	ax,110Bh
	int	15h
no_workaround:
	mov	ax,__dvversion
	cmp	ax,0232h		; v2.50+ ?
	jb	no_error_recovery
	mov	DVSEND_ERROR_RECOVERY@,1
no_error_recovery:
	cmp	ax,0201h		; v2.01+ ?
	jb	no_CSTYLE
	mov	ax,1112h
	mov	bx,1			; enable C-style interp of control codes
	int	15h
no_CSTYLE:
	mov	ax,offset __TEXT:DVEXIT@
	PUSHCPTR cs,ax
	call	atexit@
	add	sp,cPtrSize
DVinit_done:
	mov	ax,__dvversion
	@Exit
	ret	2
EndProc@ DVINIT,__PASCAL__

;------------------------------------------------------------------------

PubProc@ DVEXIT,__PASCAL__
	SET_DS
	cmp	initialized,0
	je	DVexit_done
	mov	al,1
	xchg	al,DGROUP:exited
	or	al,al
	jnz	DVexit_done
	mov	al,num_exitfuncs
	mov	ah,cPtrSize
	mul	ah
	push	di
	mov	di,ax
exitfunc_loop:
	or	di,di
	jz	exitfuncs_done
	call	CPTR_ dv_exitfuncs[di-cPtrSize]
	sub	di,cPtrSize
	jmp	exitfunc_loop
exitfuncs_done:
	pop	di
DVexit_done:
	RESTORE_DS
	ret
EndProc@ DVEXIT,__PASCAL__

;------------------------------------------------------------------------

PubProc@ DVATEXIT,__PASCAL__
@func = CPTR_ [bp+Overhead]
	@Enter
	mov	ah,cPtrSize
	mov	al,num_exitfuncs
	cmp	al,MAX_EXITFUNCS
	jae	atexit_done
	mul	ah
	mov	bx,ax
	COPYDPTR dv_exitfuncs[bx],@func,ax
	inc	num_exitfuncs
	xor	ax,ax			; successful
atexit_done:
	@Exit
	ret	cPtrSize
EndProc@ DVATEXIT,__PASCAL__

CSegEnd@

	END
