/******************************************************************************
* Module    :   UU Decode header file.
*
* Author    :   John W. Stevens
******************************************************************************/

#if ! defined(UU_DECODE_HEADER)
#define UU_DECODE_HEADER

#include    "segment.h"

/*  Return value for UU line checking.  */
typedef enum    {
    UU_TYPE_NOT_SET,
    NOT_UU_LINE,
    IS_UU_LINE,
    UU_SPACE,
    UU_BEGIN,
    UU_END
} CHK_UU_ENC;

/*  Function prototypes.    */
extern
CHK_UU_ENC  ChkUULine(char  *Line,
                      char  ***RetStrs,
                      int   *EncLen);
extern
CHK_UU_ENC  DecUULine(char  *Line,
                      int   *Len,
                      BYTE  *Bfr);
extern
void        DecTruncUULn(char   *Line,
                         int    *Len,
                         BYTE   *Bfr);

#endif
