/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

/*
    REFS.H: struct-Definitionen fuer REFERENCES 3.6
    weitere struct-Definitionen in ABSTR.H und FD.H
*/


#ifndef REFS_H
#define REFS_H

#define ANSI_FARBCODE_LEN 100

#define WRTXTBU_LEN            2048

#define DOSDATEINAME_LEN         12
#define DOSDATEIVORNAME_LEN       8
#define MAXFELD_LEN             255


#define AUTORZEILE_LEN    (size_t) 32000L
#define SHOWREC_LEN       (size_t) 32000L
#define MAX_N_AUTHORS                 999
#define AUSGABEZEILE_LEN  (size_t) 32000L
#define SCREENLINE_LEN    78
#define DESC_ZEILE_LEN    (size_t) 32000L
#define MAX_N_DESC                    999


#define PFAD_LEN         150
#define PFAD_DOS_LEN     127

#define KENNZIFFER_LEN     12
#define TITEL_LEN         255
#define KUERZEL_LEN         4
#define JAHRGANG_LEN        4
#define MONAT_LEN           2
#define TAG_LEN             2
#define ISSUE_NUMMER_LEN    8
#define BAND_LEN           20
#define SEITE_VON_LEN      10
#define SEITE_BIS_LEN      10
#define REFTYP_LEN          2
#define STATUS_LEN         12
#define STICHW_LEN        140
  /* STICHW_LEN wird entbehrlich */


/* JOURNAL.DAT */
typedef struct
{
  short int in_use;
  char kennziffer[KENNZIFFER_LEN + 1];
  char titel[TITEL_LEN +1];
  char kuerzel[KUERZEL_LEN + 1];
  char jahrgang[JAHRGANG_LEN +1];
  char monat[MONAT_LEN + 1];
  char tag[TAG_LEN + 1];
  char band[BAND_LEN + 1];
  char issue_nummer[ISSUE_NUMMER_LEN + 1];
  char seite_von[SEITE_VON_LEN + 1];
  char seite_bis[SEITE_BIS_LEN + 1];
  char reftyp[REFTYP_LEN + 1];
  char status[STATUS_LEN + 1];
} journal_rec;
/*  journal_rec ist 462 Bytes lang */


/* JOURNAL.IX */
typedef struct
{
  char kennziffer[KENNZIFFER_LEN + 1];
  long journal_rptr;
  long buch_rptr;
  long autorjl_rptr;
  long autorbu_rptr;
  long desc_rptr;
} refspix_rec;


#define KEYWORDS_LEN       45

/* DESC.DAT */
typedef struct
{
  short int in_use;
  short int desc_i;
  short int desc_n;
  char kennziffer[KENNZIFFER_LEN + 1];
  char keywordsfield[KEYWORDS_LEN + 1];
} desc_rec;


#define AUKENNZIFFER_LEN   12
#define AUNAME_LEN         26
#define AUVORNAMEN_LEN      6

/* AUTORJL.DAT AUTORBO.DAT */
typedef struct
{
   short int in_use_au;
   short int au_i;
   short int au_n;
   char au_kennziffer[AUKENNZIFFER_LEN +1];
   char au_nachname[AUNAME_LEN +1];
   char au_vornamen[AUVORNAMEN_LEN + 1];
} author_rec;



#define QUELLKUERZEL_LEN            4
#define ZEITSCHRIFT_LEN            80
#define KURZFORM_LEN               60
#define ISSN_LEN                   14

/* SOURCE.DAT */
typedef struct
{
   short int in_use_quell;
   char quell_kuerzel[QUELLKUERZEL_LEN + 1];
   char quell_zeitschrift[ZEITSCHRIFT_LEN + 1];
   char quell_kurzform[KURZFORM_LEN + 1];
   char quell_issn[ISSN_LEN +1];
} quell_rec;


/* SOURCE.IX */
typedef struct
{
  char quell_kuerzel[QUELLKUERZEL_LEN + 1];
  long quell_rptr;
} quellpix_rec;
/* Indexdatei fuer Zeitschriftennamen */



#define TITELBUCH_LEN                   255
#define PUBLORT_LEN                     255
#define VERLAG_LEN                      140
#define ISBN_LEN                        14

/* BOOK.DAT */
typedef struct
{
  short int in_use_bu;
  char kennziffer[KENNZIFFER_LEN + 1];
  char titel_bu[TITELBUCH_LEN + 1];
  char publ_ort[PUBLORT_LEN + 1];
  char verlag[VERLAG_LEN + 1];
  char isbn[ISBN_LEN + 1];
} buch_rec;


/* KEYW.DAT */
typedef struct
{
   short int in_use;
   char keywordsfield[KEYWORDS_LEN + 1];
} keylist_rec;


/* KEYW.DAT */
typedef struct
{
   char keywordsfield[KEYWORDS_LEN + 1];
   long keywords_rptr;
} keylistpix_rec;

/* Indexdatei fuer Keywords */


#define SORTIERFELD_LEN AUNAME_LEN + AUVORNAMEN_LEN + JAHRGANG_LEN

/* .BBT */
typedef struct
{
    char kennziffer[KENNZIFFER_LEN + 1];
    char sortierfeld[SORTIERFELD_LEN + 1];
} bbatchtable_rec;



/*
   In diese Struktur werden die Daten der
   Konfigurationsdatei eingelesen:
*/
typedef struct
{
   char text_editor[PFAD_LEN + 1];
   char text_pager[PFAD_LEN + 1];
   char call_editor_command_file[PFAD_LEN + 1];
   char help_path[PFAD_LEN + 1];
   char copy_command[PFAD_LEN + 1];
   int colors;
   int sl;                   /* screen lines */
   int insert_mode;
   int delay_list_write;
   int delay_struct_write;
} config_set;


#if defined(MIT_ANSI_SYS)

typedef struct
{
   char farbe_norm[ANSI_FARBCODE_LEN + 1];
   char farbe_inv[ANSI_FARBCODE_LEN + 1];
   char farbe_e_zle[ANSI_FARBCODE_LEN + 1];
} ansi_farben_set;

#elif defined(__DJGPP__)

typedef struct
{
   int farbe_norm_v; /* Vordergrund */
   int farbe_norm_h; /* Hintergrund */
   int farbe_inv_v;
   int farbe_inv_h;
   int farbe_e_zle_v;
   int farbe_e_zle_h;
} ansi_farben_set;

#elif defined(__EMX__)

typedef struct
{
   int farbe_norm;
   int farbe_inv;
   int farbe_e_zle;
} ansi_farben_set;

#endif

#endif
