#ifndef __SHOW_TEXT_H_
#define __SHOW_TEXT_H_


#include "ljfonts.h"
#include <alloc.h>
#include <string.h>

class ShowText
    {
    protected:
	char* buffer;     // work buffer
	ljfont* fnt;
    public:
	ShowText()
	    {
	    buffer = NULL; fnt = NULL;
	    }
	~ShowText() { delete buffer; buffer = NULL; delete fnt; fnt = NULL; }

	void loadFont(char* fontName = "hv08a.sfp");
	void unLoadFont()
	    { delete buffer; buffer = NULL; delete fnt; fnt = NULL; }
	void show(loc pos,                  // left-top of viewport
		  char* string,
		  loc scale = loc(1, 1), int interval = 15,
		  int direction = HORIZ_DIR, int mode = COPY_PUT);
    };

#endif __SHOW_TEXT_H_