#include <stdlib.h>
#include "print.h"
#include "simple.h"
#include <bios.h>
#include <dos.h>
#include <conio.h>

/*
#include <stdio.h>
#include <io.h>
#include <fcntl.h>



#include <string.h>

#include <assert.h>


*/
// #include "filter.h"   // XXX

FILE * nonstdprn;
int dcounter;

#define p_char(c) biosprint(_PRINTER_WRITE, c, 0)

void PrintManager::draw_string(char* str)
    {
    for(int i = 0; str[i]; i++)
	p_char(str[i]);
    }
//////////////////////
void PrintManager::init_printer(int size, int sh)
    {
    switch(printer_type)
	{
	case EPSON9:
	case EPSON24:
	    p_char(27); p_char('$'); p_char(left % 256);
			p_char(left / 256);        // set left margine
	    p_char(27); p_char('3'); p_char(sh);   // sh/216
	    int n1 = (size) % 256;
	    int n2 = (size) / 256;
	    p_char(27);                          // Set graphics line length n1 + 256 * n2
	    if(printer_type == EPSON9)
		p_char(density == DD ? 'L' : 'Z');
	    else
		{
		p_char('*');
		p_char(density == DD ? 33 : 39);
		}
	    p_char(n1); p_char(n2);
	    break;
	case LASERJET_II:
	    p_char(27); p_char(42); p_char(98);  // transfer
	    char str[10];
	    draw_string(itoa(size, str, 10));	p_char(87);
	    break;
	}
    }
//////////////////////////
void PrintManager::draw_pages(GrafBuffer* buf, char* work_name, int maxpage)
    {
    maxpage = maxpage / 8 * 8;
    if(((buf->bound_size).Y = ((buf->bound_size).Y / parity) * parity) != 0
	&& maxpage >= buf->buf_dim.X)
	draw_buffer(buf);
    else
	{
	buf->bound_size.Y = buf->image->ymax + 1;
	for(int page = 0; page < (buf->bound_size).X / maxpage + 1; page++)
	    {
	    int right = (maxpage * (page + 1) - 1 < buf->buf_dim.X - 1)
			? maxpage * (page + 1) - 1
			: buf->buf_dim.X / 8 * 8 - 1;
	    print_part(rect(maxpage * page, 0, right,
			     (buf->buf_dim).Y - 1), buf, work_name);
	    sound(200); delay(300); nosound();
	    if(getch() == 27)
		break;
	    }
	}
    }
//////////////////////////
void PrintManager::print_part(rect src, GrafBuffer* buf, char* work_name)
    {
    buf->buffer_disk(src, work_name);

    loc res_buf = buf->buf_dim;
    loc res_bound = buf->bound_size;
    char* res_file_name = buf->file_name;

    buf->b_close();

    (buf->buf_dim).Y = src.height();
    (buf->bound_size).X = (buf->buf_dim).X = src.width();
    (buf->bound_size).Y =
	(BOUND_SIZE / image_size(buf->bound_size.X, 1, 1, 4))
	    / parity * parity;
    if(buf->bound_size.Y > buf->buf_dim.Y)
	buf->bound_size.Y = buf->buf_dim.Y;

    buf->file_name = work_name;

    buf->b_open();

    draw_buffer(buf);
    buf->b_close();

    buf->buf_dim = res_buf;
    buf->bound_size = res_bound;
    buf->file_name = res_file_name;

    buf->b_open();
    }
//////////////////////////
void PrintManager::draw_buffer(GrafBuffer* buf) // prints buffer
    {
    int reserv_size = (buf->bound_size).Y;
    int num_bounds = (buf->buf_dim).Y / (buf->bound_size).Y + 1;

    (buf->bound_size).Y =
	(BOUND_SIZE / (image_size(buf->bound_size.X, 1, 1, 4)))
	    / parity * parity;

    if(printer_type == LASERJET_II)
	{
	p_char(27); p_char('E');
//	p_char(27); p_char(42); p_char(114); p_char(0); p_char(65);  // graphics

	p_char(27); p_char(42); p_char(99);
	char str[10];
	draw_string(itoa((buf->buf_dim).X, str, 10)); p_char(65); // dimension

	p_char(27); p_char(42); p_char(99);
	draw_string(itoa((buf->buf_dim).Y, str, 10)); p_char(86);

//	p_char(27); p_char(42); p_char('p'); draw_string(itoa(left, str, 10));

	p_char(27); p_char(42); p_char(116);
	switch(density)
	    {
	    case DD: p_char('7'); p_char('5'); break;
	    case QD: p_char('3'); p_char('0'); p_char('0'); break;
	    case LJ_150: p_char('1'); p_char('5'); p_char('0'); break;
	    case LJ_100: p_char('1'); p_char('0'); p_char('0'); break;
	    }
	p_char(82);     // resolution

	}
    else
	{
	p_char(27); p_char('@');   // reset
	p_char(27); p_char('U'); p_char(1);            // unidirectional print
//	p_char(27); p_char(paper);                     // paper_out sensor on/off
	}

    for(int i = 0; i < num_bounds && !kbhit(); i += buf->nplanes * buf->bitpx)
	{
	int bound_y = (buf->image)->ymax;
	buf->get_BW(i);
	buf->image->ymax = (buf->image->ymax > buf->buf_dim.Y)
			     ? buf->buf_dim.Y - 1
			     : (long)buf->image->ymax;

	draw_image(buf->image);
	(buf->image)->ymax = bound_y;
	}
    if(printer_type == LASERJET_II)
	{
	p_char(13); p_char(10); p_char(12);
	p_char(27); p_char(42); p_char(114); p_char(66);  // end graphics
	p_char(27); p_char(69);  // reset
	}
    else
	{
	p_char(27);
	p_char('@');   // reset
	}
    (buf->bound_size).Y = reserv_size;
    }
//////////////////////////
void PrintManager::draw_image(imageP image)
    {
    uchar byte;
    int prn_picture_width = (long)image->xmax * mx / dx + 1;
    int prn_picture_height = (long)image->ymax * my / dy + 1;

    switch(printer_type)
	{
	case EPSON9:
	    int sh = 22;
	    bool sh1 = OFF;
	    for(int j = 0; j < prn_picture_height && !kbhit();	j += sh)
		{
		if(sh == 22)
		    { sh = 1; sh1 = !sh1; }
		else if(sh1)
		    sh1 = !sh1;
		else
		    sh = 22;
		for(int p = 0; p < pass; p++)
		    {
		    init_printer(prn_picture_width, sh);
		    for(int i = 0; i < prn_picture_width; i++)
			{
			byte = 0;
			for(int bit = 0; bit < 8; bit++)
			    {
			    uchar pix = image_get_pixel(image,
				loc((long)i * dx / mx, (long)(j + 3 * bit) * dy / my),
						      1, 1);
			    uchar lo = (byte << (bit + 1)) >> (bit + 1);
			    uchar hi = (byte >> (8 - bit)) << (8 - bit);
			    byte = hi | lo | (pix << (7 - bit));
			    }
			p_char(byte);
			}
		    p_char(13);
		    }
		p_char(10);
		}
	    p_char(13);
	    break;
	case EPSON24:
	    sh = 24;
	    for(j = 0; j < prn_picture_height && !kbhit(); j += sh)
		{
		for(int p = 0; p < pass; p++)
		    {
		    init_printer(prn_picture_width, sh);
		    for(int i = 0; i < prn_picture_width; i++)
			{
			for(int k = 0; k < 3; k++)
			    {
			    byte = 0;
			    for(int bit = 0; bit < 8; bit++)
				{
				uchar pix = image_get_pixel(image,
				      loc((long)i * dx / mx,
					  (long)(j + k * 8 + bit) * dy / my), 1, 1);
				uchar lo = (byte << (bit + 1)) >> (bit + 1);
				uchar hi = (byte >> (8 - bit)) << (8 - bit);
				byte = hi | lo | (pix << (7 - bit));
				}
			    p_char(byte);
			    }
			}
		    p_char(13);
		    }
		p_char(10);
		}
	    p_char(13);
	    break;
	case LASERJET_II:
	    for(int i = 0; i < prn_picture_height && !kbhit(); i++)
		{
		init_printer(prn_picture_width / 8, 1);
		for(j = 0; j < prn_picture_width / 8; j ++)
		    {
		    byte = 0;
		    for(int bit = 0; bit < 8; bit++)
			{
			uchar pix = image_get_pixel(image,
			      loc((long)(j * 8 + bit) * dx / mx,
				  (long)i * dy / my), 1, 1);
			uchar lo = (byte << (bit + 1)) >> (bit + 1);
			uchar hi = (byte >> (8 - bit)) << (8 - bit);
			byte = hi | lo | (pix << (7 - bit));
			}
		    p_char(byte);
		    }
		}
	    break;
	}
    }
//////////////////////////////
/*
void main()
    {
    int gdriver = DETECT;
    int gmode;
    initgraph(&gdriver, &gmode, "");

    PrintManager p(EPSON9, DD, 2, rect(1, 1, 1, 1), 0, PAPER_ON, 6);
    GrafBuffer* g = new GrafBuffer(loc(750, 590), "work.buf",
				   rect(0, 0, 500, getmaxy() - 1));

    g->b_open();
    g->clear();
    pcx_file_buffer(g, loc(0, 0), "kh_draw.pcx");  // This file shows the
    g->buffer_screen();                            // KNOW-HOW.DRAW PCX
                                                   // editor (source codes
//    p.draw_buffer(g);                              // are available).
//    p.draw_pages(g, "work1.buf", 320);

    pcx_file_buffer(g, loc(0, 0), "inbi.pcx");    // Black and White image
    g->buffer_screen();

    p.draw_buffer(g);

    p.set_comp(1, 2, 2, 1);
    p.draw_buffer(g);

    p.set_comp(1, 1, 2, 2);
    p.draw_buffer(g);

    p.print_part(rect(64, 50, 239, 200), g, "work1.buf");

    g->b_close();
    delete g;
    closegraph();
    }
*/