/* Graphics buffer is a file, which consists of the number of "bounds".
   Each "bound" is a part of virtual graphics page, with the same width,
   and relatively low height. We can load "bound" with given number to
   memory, change it, show it on screen, swap to disk buffer. Format of
   bound is the same as in image (int, int, bitmap).
   Do not use buffer < than screen.

   If you do not use interface library of KNOW-HOW, some files are
       not necessary, as event.lib, and other. It is possible to exclude
       them from project. In this case you should edit colors.cpp file,
       and remove some functions: pColorSet, init_Know_How and so on.
       You need only pScreenSet structure, declared in colors.h.
*/

#ifndef __GRAPH_BUF_
#define __GRAPH_BUF_

#include "image.h"
#include "b&w.h"
#include "patterns.h"
#include "ic_part.h"
#include <stdio.h>

#define BOUND_SIZE 12500/2   // size of bound, bytes

enum { LEFT, UP, RIGHT, DN };
extern int image_size(int width, int heigth, int bitpx, int nplanes);
extern int get_color_mult(int src_max_color, int dest_max_color);

class GrafBuffer
    {
    public:
	int loaded;            // is the buffer ready?
	loc buf_dim;           // buffer dimentions, pixels
	loc bound_size;        // dimentions of bounds, bound_size.X == buf_dim.X
	rect screen_area;      // screen work area (l, t, r, b)
	rect screen_position;  // position of screen in buffer
	FILE* buffer;          // swap file
	char* file_name;       // swap file
	imageP image;          // image for bound
	int nplanes;           // number of planes
	int bitpx;             // bit per pixel in plane
	int change_palette;    // use or not the palette when loading or saving PCX
        int transparent;       // What color show as transparent
        int mode;              // COPY_PUT ...
    public:
	GrafBuffer(loc dim, char* swapName,
		   rect screen_area = rect(0, 0, getmaxx(), getmaxy()),
		   int bpx = 1, int np = 4);
	~GrafBuffer() { fclose(buffer); delete image; unlink(file_name);
			delete file_name; }

	long imagesize(); // if image > 64K, BGI function returns error
	int imagesize(int x, int y);

        void set_screen_area(rect a) { screen_area = a; }
        void set_screen_position(rect a) { screen_position = a; }
	int b_open();     // open swap file (created by constructor)
	void b_close();    // close swap file

	void clear();      // fills buffer file with '0'
	loc get_dim() { return buf_dim; }
        rect get_screen_pos() { return screen_position; }
//	loc get_bound_size() { return bound_size; }

        void set_mode(int m) { mode = m; }
        void set_trans(int t) { transparent = t; }

	imageP get_bound(int number);
	void put_bound(int number);
	void get_BW(int number);  // get bound and keep it as BW

	void bound_screen(int number,      // put image from bound to screen src - in image, dest - on screen
		 loc comp_s = loc(1, 1),   // divx, divy, multx, multy
		 loc comp_d = loc(1, 1));  // rects are the outlines

	void screen_bound(int number);  // load bound from disk to memory, update from screen, put back

	void screen_buffer();       // swap screen to buffer
	void buffer_screen(loc comp_s = loc(1, 1),   // from buffer to screen
			   loc comp_d = loc(1, 1));
	void buffer_screen(rect temp,
			   loc comp_s = loc(1, 1),   // from buffer to screen
			   loc comp_d = loc(1, 1));


	void buffer_disk(rect src, char* name);   // cut and paste

	void scroll(int shift, int direction, int show = 1);    // scrolling

	void pcx_buffer_file(rect src, char* name);
    friend int pcx_file_buffer(GrafBuffer* buf, loc pos, char* name,
                               int col = 16);

// Virtual BGI support
    friend void dither_BW(int** threshold, rect coord, loc dim,
			  GrafBuffer* buf);
    friend void bar(GrafBuffer* buf, rect coord);    // bar in buffer
    };

#endif __GRAPH_BUF_