#include "deditl.h"
#include "cursor.h"

//////////////////////
void DiacomEditLine::exe(int act)
    {
    Cursor curs;
    mouseHideCursor();
    hilite();

    e.what = act ? KEYEVENT : NOEVENT;
    global_i[0] = action_type;
    switch(act)
	{                                         // up, dn and so on may be added
	case AC_CANCEL:
	    e.key = (isRet(RET_REMOVE))
		? EVENT_ALT_F3 : EVENT_ESC;
	    break;
	case AC_OK:
	    e.key = EVENT_F2;
	    break;
	}

    char* temp_str = string ? strdup(string) : strdup("");  // reserv copy

    string = (char*)realloc(string, 256);   // maximum, before exiting function
    memset(string, '\0', 256);              // it will be reallocated

    strcpy(string, temp_str);
    int cur_pos = 0;                    // current pos in string
    int vis_pos = 0;                    // output begins from this position
    settextjustify(LEFT_TEXT, BOTTOM_TEXT);

    curs.set_cursor(screenXL(xy.X) + area[border_type].origin.X,
		    screenYT(xy.Y) + pScreenSet->standart_height
		    + area[border_type].origin.Y);
    curs.show_cursor();

    while(1)
	{
	if(!act)     // if act == 0 - we wait the event, else (f.e. CANCEL
		     // button pressed) - we process act, not event
	    {
	    mouseShowCursor();
	    get_event();
	    mouseHideCursor();
	    }

	int x = getx();	int y = gety();

	curs.set_cursor(screenXL(xy.X + cur_pos - vis_pos)
	    + area[border_type].origin.X,
	       screenYT(xy.Y) + pScreenSet->standart_height
	    + area[border_type].origin.Y);
	curs.hide_cursor();
	::moveto(x, y);

	if(e.mouse1() || e.mouse2())   // mouse pressed
	    {
	    global_i[0] = 0;
	    break;
	    }
	else
	    {
	    if(e.is_control())         // not visible char
                {
                switch(e.key)
                    {
                    case EVENT_LEFT: //global_i[0] = AC_LEFT; break;
		    case EVENT_RIGHT: //global_i[0] = AC_RIGHT; break;
                    case EVENT_UP: //global_i[0] = AC_UP; break;
                    case EVENT_DN: global_i[0] = 0; break; //AC_DOWN; break;
		    }
		switch(e.key)
		    {
		    case EVENT_F1: return;
		    case EVENT_HOME: home(&cur_pos, &vis_pos); break;
		    case EVENT_END: end(&cur_pos, &vis_pos); break;

		    case EVENT_DEL: del(&cur_pos, &vis_pos);  break;
		    case EVENT_BKSP: bksp(&cur_pos, &vis_pos); break;
		    case EVENT_INS: ins = !ins; break;
		    case EVENT_F10:
		    case EVENT_ESC: delete string; global_i[0] = 0;
			string = strdup(temp_str); // don't change string
		    case EVENT_TAB:
		    case EVENT_F6:
		    case EVENT_F2:
		    case EVENT_ALT_F3:
		    case EVENT_ALT_F4:
		    case EVENT_ALT_TAB:
                    case EVENT_LEFT:
		    case EVENT_RIGHT:
                    case EVENT_UP:
                    case EVENT_DN:
		    case EVENT_RETURN:
			string =
			    (char*)realloc(string, strlen(string) + 2);
			delete temp_str;
			unhilite();
			delete global[global_num];
			if(global_num)
			    delete global[0];
			global[global_num] = strdup(string);
			if(global_num)
			    global[0] = strdup(string);
			return;
		    }
                }
	    else
		if(e.is_char())   // visible char
		    {
		    outkey = e.key;
		    draw_char(&cur_pos, &vis_pos);
		    }

	    }
	x = getx();       // new coords recalculation
	y = gety();
	curs.set_cursor(screenXL(xy.X + cur_pos - vis_pos)
	    + area[border_type].origin.X,
	    screenYT(xy.Y) + pScreenSet->standart_height
	    + area[border_type].origin.Y);
	curs.show_cursor();
	moveto(x, y);
	}
// if mouse pressed outside - we keep the edited string
    string = (char*)realloc(string, strlen(string) + 2);
    delete temp_str;
    unhilite();
    delete global[global_num]; global[global_num] = strdup(string);
    delete global[0]; global[0] = strdup(string);
    return;
    }
//////////////////////
