/****************************************************************************/
/* TRDIOBUT                                                                 */
/*--------------------------------------------------------------------------*/
/* Objet TRadioButton (bouton radio)                                        */
/*--------------------------------------------------------------------------*/
/* Auteur     : DELPRAT Jean-Pierre                                         */
/* Cr le    : 10/01/95                                                    */
/****************************************************************************/

#include <stdlib.h>

#include "Const.h"

#include "JPAppli.h"

#include "Mouse.h"
#include "Screen.h"
#include "SpChars.h"

#include "TWindow.h"
#include "TRdioGrp.h"
#include "TRdioBut.h"

/*ͻ*/
/*                           METHODES PUBLIQUES                           */
/*ͼ*/

/****************/
/* Constructeur */
/* ------------ */
/****************************************************************************/
/* group         : Groupe auquel appartient le bouton radio                 */
/* rel_x, rel_y  : Coordonnes du bouton radio p/r au groupe                */
/* width         : Largeur du bouton radio                                  */
/* caption       : Lgende du bouton radio (hot-key prcde de ~)          */
/* enabled       : ENABLED si le bouton radio est activable (DISABLED sinon)*/
/* checked       : CHECKED si le bouton radio est coch (NOT_CHECKED sinon) */
/****************************************************************************/

TRadioButton::TRadioButton(PRadioGroup radio_group,
			   int rel_x,int rel_y,
			   int width,char *caption,
                           boolean checked,
                           boolean enabled)
	     :TCheckBox(radio_group,
	       	        rel_x,rel_y,
		        width,
		        caption,
                        NOT_CHECKED,
			enabled)
{
  f_checked=FALSE;

  // Si c'est le premier bouton radio, on le coche d'office
  // Dans un TRadioGroup, seul un bouton radio peut tre coch

  if ((((PRadioGroup)f_parent)->f_checked_radio_button==NULL) || (checked))
    ((PRadioGroup)f_parent)->m_change_checked_radio_button_to(f_number);
}

/***************/
/* Destructeur */
/* ----------- */
/***************/

TRadioButton::~TRadioButton()
{
}

/****************************************/
/* m_check/m_uncheck : Coche ou dcoche */
/* -----------------   le bouton radio  */
/****************************************/

void TRadioButton::m_check()
{
  ((PRadioGroup)f_parent)->m_change_checked_radio_button_to(f_number);
}

void TRadioButton::m_uncheck()
{
}

/**********************************************************************/
/* m_display_focus_depending_part : Affichage de la partie de l'objet */
/* ------------------------------   dont l'aspect dpend du focus     */
/**********************************************************************/

void TRadioButton::m_display_focus_depending_part()
{
  m_display_caption();
}

/****************************************************************************/
/* m_display_caption                                                        */
/*--------------------------------------------------------------------------*/
/* Affichage de la lgende de l'objet                                       */
/****************************************************************************/

void TRadioButton::m_display_caption()
{
  int x,y;

  // Si l'objet n'est pas ouvert, rien  faire

  if (!f_open)
    return;

  // Rcupration des coordonnes de l'objet dans sa fentre

  x=m_get_x_in_window();
  y=m_get_y_in_window();

  // Affichage de la lgende du bouton-radio

  f_window->m_gotoxy(x,y);

  if (!f_enabled)
    f_window->m_set_inactive_attr(f_background);
  else
    {
      if ((f_focused) && (f_window->m_is_active()))
	f_window->m_set_bright_attr(f_background);
      else
	f_window->m_set_normal_attr(f_background);
    }

  if (f_checked)
    f_window->m_puts(SPECIAL_STRING(SST_RADIOBUTTON_CHECKED));
  else
    f_window->m_puts(SPECIAL_STRING(SST_RADIOBUTTON_UNCHECKED));

  f_window->m_put_caption(f_caption,
			 f_enabled,
			 f_width-3,  // -3 pour la taille de la case
			 JUSTIFIED_LEFT);
}

/*********************************************************************/
/* m_left_button_pressed_event : L'utilisateur a cliqu dans l'objet */
/* ---------------------------   (l'objet tant activable).          */
/*                               Retourne TRUE si l'objet est        */
/*                               intress par cet vnement.        */
/*********************************************************************/

boolean TRadioButton::m_left_button_pressed_event(int /*x*/,int /*y*/)
{
  if (!f_focused)
    {
      if (!m_set_focus())
        return(FALSE);
    }

  ((PRadioGroup)f_parent)->m_change_checked_radio_button_to(f_number);
  JPRefresh();

  WaitMouseLeftButtonRelease();

  return(TRUE);
}

/************************************************************************/
/* m_key_pressed_event : L'utilisateur a appuy sur une touche          */
/* -------------------   qui est propose  l'objet (qui est activable).*/
/*                       Retourne TRUE si l'objet est                   */
/*                       intress par cette touche.                    */
/************************************************************************/

boolean TRadioButton::m_key_pressed_event(TKey key)
{
  if ( (!f_focused) || (key.character!=SPACE))
    if (key.hot_character!=f_hot_key)
      return(FALSE);

  if (!f_focused)
    {
      if (!m_set_focus())
        return(FALSE);
    }

  ((PRadioGroup)f_parent)->m_change_checked_radio_button_to(f_number);

  return(TRUE);
}

/*ͻ*/
/*                            METHODES PRIVEES                            */
/*ͼ*/

