/****************************************************************************/
/* TEDZONE                                                                  */
/*--------------------------------------------------------------------------*/
/* Objet TEditZone (Zone d'dition sur une ligne)                           */
/****************************************************************************/

#ifndef _TEDZONE_H_
#define _TEDZONE_H_

#include "Keyboard.h"
#include "Types.h"

#include "TObject.h"

// Vitesse de dfilement du texte

#define EDITZONE_FIRST_SCROLL_SPEED  150
#define EDITZONE_SCROLL_SPEED        70

class TEditZone:public TObject
{
  /*-----------------*/
  /* Champs protgs */
  /*-----------------*/

  protected:

    // Longueur visible et longueur maximale du texte

    int     f_display_length,
	    f_max_length;

    // Modification du texte autorise

    boolean f_modification_enabled;

    // Vrification de la validit de la chane active

    boolean f_string_checking;

    // Longueur utile de la chane (sans les . finaux)

    int     f_useful_length;

    // Chane en cours de saisie (avec les . finaux)

    char    *f_string;

    // Chane par dfaut (sans les .finaux)

    char    *f_default_string;

    // Message affich si la saisie est invalide

    char    *f_error_message;


    // Mode insertion/recouvrement
    // (champ commun  toutes les instances de l'objet)

    static
    boolean f_insert_mode;

    // Position du titre par rapport au texte

    int     f_xoffset_caption,
	    f_yoffset_caption;

    // Indice de chane du premier caractre visible

    int     f_first_visible_char;

    // Une zone est slectionne ?

    boolean f_zone_selected;

    // Si oui :
    // -> caractres de position min et max de la zone slectionne

    int     f_min_selected_char;
    int     f_max_selected_char;

    // En cours de slection :
    // -> premier et dernier caractres slectionnes
    //    (par ordre de slection)

    int     f_first_selected_char;
    int     f_last_selected_char;

    // Position du cursor (indice dans la chane -> 0..f_useful_length)

    int     f_cursor_position;

    // Donnes au moment o la zone de saisie prend le focus

    char    *f_string_before_focus;      // Chane avant modification
                                         // (sans les . finaux)

    // Chane pour annulation par ALT_BACKSPACE

    char    *f_undo_string;
    boolean  f_undo_string_can_change;

    // Chane retourne par m_get_string (sans les . finaux)

    char    *f_return_string;

    // Callback : Fonction appele  chaque modification de la chane
    //            et son argument

    void    (*f_string_changed_action)(PObject,char *);
    char    *f_string_changed_argument;


  /*--------------------*/
  /* Mthodes publiques */
  /*--------------------*/

  public:

    // Constructeur / Destructeur

     	            TEditZone(PObject parent,
		              int rel_x,int rel_y,
                              int  xoffset_caption,int yoffset_caption,
			      char *caption,
                              int display_length,
			      int max_length,
			      char *string="",
			      boolean enabled=TRUE);
    virtual         ~TEditZone();

    // Mthodes d'accs

	    void    m_set_cursor_at(int char_nb);

    virtual void    m_enable_modification()    {f_modification_enabled=TRUE;};
    virtual void    m_disable_modification()   {f_modification_enabled=FALSE;};

    virtual void    m_enable_string_checking() {f_string_checking=TRUE;};
    virtual void    m_disable_string_checking(){f_string_checking=FALSE;};

	    void    m_select_zone(int position1,int position2);
	    void    m_select_all()       {m_select_zone(0,f_useful_length);};
	    void    m_unselect();
            void    m_clear_selection();

    virtual void    m_set_string(char *string);

    // La chane peut tre manipule tant que l'objet existe

	    char    *m_get_string();
	    int     m_get_string_length() { return(f_useful_length);};

    // Validit d'une chane pour la zone

    virtual boolean m_string_valid(char *string);

    // La zone peut-elle perdre le focus
    // (si non, affiche une boite de dialogue)

    virtual boolean m_can_lose_focus();


    // Dfinition des callbacks

	    void    m_set_string_changed_callback(void (*string_changed_action)(PObject,char *),
						  char *string_changed_argument);

  /*--------------------*/
  /* Mthodes protges */
  /*--------------------*/

  protected:

    // Affichage

    virtual void    m_display();
    virtual void    m_display_focus_depending_part();
    virtual void    m_display_caption();
    virtual void    m_display_string();

    // Prise/Perte du focus

    virtual void    m_lose_focus();
    virtual void    m_take_focus();

    // L'objet devient actif/inactif

    virtual void    m_set_active(boolean active);

    // Evnements

    virtual boolean m_left_button_pressed_event(int x,int y);
    virtual boolean m_left_button_double_click_event(int x,int y);
    virtual boolean m_key_pressed_event(TKey key);

    // Caractres saisis

	    void    m_character_hit(int character);

	    void    m_left_hit(boolean shift_pressed);
	    void    m_right_hit(boolean shift_pressed);
	    void    m_home_hit(boolean shift_pressed);
	    void    m_end_hit(boolean shift_pressed);
	    void    m_alt_backspace_hit();
	    void    m_backspace_hit();      // Annule les modifications
	    void    m_delete_hit();
	    void    m_insert_hit();

    // Appel des callbacks

    virtual void    m_string_modified_callback();


  /*------------------*/
  /* Mthodes prives */
  /*------------------*/

  private:

    // Calculs/Oprations sur la chane

	    void    m_calc_useful_length();
    virtual boolean m_character_valid(int character);
    virtual char    *m_get_error_message();

    // Dplacement du curseur

	    void    m_set_cursor_position(int cursor_position);
	    void    m_move_cursor_with_key_to(boolean shift_pressed,int new_cursor_pos);

    // Rend le curseur visible

	    void    m_show_cursor();

    // Pour l'affichage

    virtual void    m_display_string_chars(unsigned background,int last_visible_char);

};

#endif