comment #

   (C) Copyright 1996 Charon Software, All Rights Reserved
   VCLOCK.ASM, assembled with SLR Systems' OPTASM
   on-screen clock TSR with customizable location, color, snow removal, etc

   v1.5, 02/01/96: this is the first release by Charon Software
   v1.4, 09/15/91: this version (VCLOCK) has been added to coexist with
                   the older version (VIDCLOCK)-- it provides better support
                   for processors other than the low-end 8088 and 8086
   v1.3, 08/15/90: added dynamic shutdown during graphics modes
                   added hook into BIOS video to make display steadier
                   prioritized handling of the old clock vector
   v1.2, 11/28/89: minor optimization of installation routine
   v1.1, 09/11/88: fixed a bug in restoring the INT 2Fh handler
                   rewrote to avoid seconds going to 60
                   optimized for speed & size via self-modifying code
   v1.0, 08/21/88: initial release

#


.186


ResLength equ (Install - Main + 100h + 0Fh) shr 4


Sseg          segment byte stack 'prog'    ; dummy stack segment
Sseg          ends


Cseg          segment byte public 'prog'
              assume  cs:Cseg, ds:Cseg, ss:Sseg

              org     100h


Main          proc    far
              jmp     Install
Main          endp


; ------------------------ INT 8 (timer interrupt) -----------------------


VidClock      proc           far
              pushf
              call dword ptr cs:OldClock    ; let old clock handler process it
              dec            cs:CLOCKTIME   ; time to update display?
              jz             OurClock       ;   yes, go for it
              iret

OldClock  dw ?, ?      ; original INT 8 vector

OurClock:     pusha
              push           ds
              push           es
              push           cs             ; set DS to CS
              pop            ds
              xor            ax,ax          ; set ES to BIOS data area
              mov            es,ax
              mov            dx,ax
              mov            al,es:[0449h]  ; current video mode
              cmp            al,3           ; text mode?
              jbe            ModeOk         ;   yep, continue
              cmp            al,7           ; text mode?
              je             ModeOk         ;   yep, continue
              jmp            ExitClock      ; go exit

ModeOk:       mov            ax,es:[046Ch]  ; lsw of time (3-byte)
              mov            dl,es:[046Eh]  ; msb of time (3-byte)
              shr            dx,1
              rcr            ax,1
              mov            di,32771
              div            di             ; compute hours
              mov            bh,al          ; save 'em
              mov            ax,dx          ; prepare remainder for minutes
              xor            dx,dx
              mov            di,546
              div            di             ; compute minutes
              mov            bl,al          ; save 'em
   NOSECONDS  db 0F8h                       ; *** self-modified code ("clc")
              jc             UpdMinutes     ;   skip seconds if flag says so
              mov            ax,dx          ; prepare remainder for seconds
              mov            dl,9
              div            dl             ; compute seconds
UpdSeconds:   xor            ah,ah
              mov            dl,60
              div            dl
              add            bl,al
              mov            al,ah
GotSeconds:   aam                           ; convert to BCD
              add            ax,"00"        ; convert to ASCII
              xchg           al,ah
              mov word ptr   TIMEMSG+6,ax
UpdMinutes:   mov            al,bl
              xor            ah,ah
              mov            dl,60
              div            dl
              add            bh,al
              mov            al,ah
              aam                           ; convert to BCD
              add            ax,"00"        ; convert to ASCII
              xchg           al,ah
              mov word ptr   TIMEMSG+3,ax
              mov            al,bh          ; hours
              cmp            al,24          ; too large?
              jb             GetHour0       ;   no
              xor            al,al          ; zap to zero
GetHour0:     mov            si,MPLACE      ; 12/24-hour flag, and more...
              or             si,si          ; 24-hour time?
              jz             GetHour        ;   yes, got it
              mov            di,"ma"        ; assume morning
              cmp            al,12          ; is it morning?
              jae            AfterNoon      ;   no, it's after noon
              or             al,al          ; is it 12:xx am?
              jnz            PlaceTime      ;   no, got it
              mov            al,12
              jmp            PlaceTime
AfterNoon:    mov            di,"mp"        ; flag it after noon
              je             PlaceTime      ;   got it if noon
              sub            al,12          ; convert to 12-hour time
PlaceTime:    mov word ptr   ds:TIMEMSG[si],di ; place "am"/"pm" indicator
GetHour:      aam                           ; convert to BCD
              add            ax,"00"        ; convert to ASCII
              xchg           al,ah
              cmp            al,"0"         ; leading zero?
              jne            GotHour        ;   nope, skip
              mov            al," "         ; make it blank
GotHour:      mov word ptr   TIMEMSG,ax
              cld
              db 0BFh                       ; *** self-modified code
      VIDSEG  dw 0                          ; (mov di,####)
              mov            es,di          ; ptr to video memory
              db 0BFh                       ; *** self-modified code
      VIDOFS  dw ?                          ; (mov di,####)
              db 0B4h                       ; *** self-modified code
      COLOUR  db 7                          ; (mov ah,##)
              mov            si,offset TIMEMSG
              xor            cx,cx
              mov            cl,TIMELEN
      NOSNOW  db  0F8h                      ; *** self-modified code ("clc")
              jc             SlowDisplay
DisplayTime:  lodsb                         ; get a chr
              stosw                         ; display it with color
              loop           DisplayTime    ;   go for another
ExitClock:    db 0B0h                       ; *** self-modified code
    UPDATES   db 9                          ; (mov al,##)
              mov            CLOCKTIME,al   ; restart clock display countdown
              pop            es
              pop            ds
              popa
              iret                          ; return

SlowDisplay:  db 0BAh                       ; *** self-modified code
     VIDPORT  dw ?                          ; (mov dx,####)
              mov            bh,ah
SlowDisp:     lodsb
              mov            bl,al
SD1:          in             al,dx          ; wait for retrace
              shr            al,1
              jc             SD1
SD2:          in             al,dx          ; wait for retrace
              shr            al,1
              jnc            SD2
              mov            ax,bx
              stosw
              loop           SlowDisp
              jmp            ExitClock


; ------------------ INT 10h (BIOS video interrupt) ----------------------



VidHandler:   pushf                         ;
              call dword ptr cs:OldVideo    ; let BIOS do its stuff
              mov            cs:CLOCKTIME,1 ; force update of clock display
              iret                          ; return

OldVideo  dw ?, ?      ; original INT 10h vector



; ------------------ INT 2Fh (multiplex interrupt) -----------------------


MuxHandler:   cmp            ah,0DAh        ; is it for us?
              je             OurMux         ;   yep, go process it
NormMux:      db 0EAh      ; *** self-modifying code: JMP FAR PTR xxxx:yyyy
    MOFS      dw ?         ; original INT 2Fh vector
    MSEG      dw ?

OurMux:       or             al,al          ; status request?
              jnz            OM1            ;   no, skip
              dec            al             ; AL=0FFh to show we're here
              iret                          ;   go directly home
OM1:          cmp            al,1           ; "remove self" request?
              jne            OM9            ;   no, exit
              xor            ax,ax
              mov            es,ax
              push           ds
              push           cs             ; set DS = CS
              pop            ds
              cli                           ; interrupts off
              mov            ax,ds:OldClock ; restore old INT 8 vector
              mov            es:[0020h],ax
              mov            ax,ds:OldClock+2
              mov            es:[0022h],ax
              mov            ax,ds:OldVideo ; restore old INT 10h vector
              mov            es:[0040h],ax
              mov            ax,ds:OldVideo+2
              mov            es:[0042h],ax
              mov            ax,ds:MOFS     ; restore old INT 2Fh vector
              mov            es:[00BCh],ax
              mov            ax,ds:MSEG
              mov            es:[00BEh],ax
              sti                           ; interrupts on
              push           cx
              push           di
              mov            cx,ds:VIDSEG   ; video segment
              mov            es,cx
              mov            di,ds:VIDOFS   ; video offset
              xor            cx,cx
              mov            cl,ds:TIMELEN  ; length of clock display
              mov            ax,0720h       ; space in color (white on black)
              cld                           ; set direction forward
              rep            stosw          ; clear the clock
              pop            di
              pop            cx
              pop            ds
              push           cs
              pop            es             ; put current segment in ES
OM9:          iret                          ; return

; ---------------- DATA required by interrupt handlers --------------------


MPLACE    dw 0               ; offset from TIMEMSG for "am" or "pm" indicator
                             ; also a flag: 0: 24hr; 5: 12hr,nosec; 8: 12hr,sec
CLOCKTIME db 1               ; ticks til next screen update
TIMELEN   db 10              ; chars in time display
TIMEMSG   db "00:00:00xm"    ; current time

VidClock      endp


; ------------------ INSTALLATION routine ---------------------------------


Install       proc           near
              mov            dx,offset HeaderMsg
              mov            ah,9
              int            21h            ; display copyright/header message
              mov            dx,offset CpuMsg ; assume 8088 or 8086
              mov            ax,0FFFFh      ; check processor type
              mov            cl,33          ;
              shl            ax,cl          ; is it an 8088 or 8086?
              jnc            Done           ;   yep, exit with error message
              mov            ax,0DA00h      ; query status of our handler
              int            2Fh            ; ...on the multiplex interrupt
              mov            INSTALLED,al   ; save results for later
              xor            ax,ax
              mov            es,ax
              mov            al,es:[044Ah]  ; columns/row
              mov            COL,al         ; set default column
              mov            ch,ah
              mov            cl,ds:[0080h]  ; get command line length
              jcxz           Inform         ;   if null, tell 'em about us
              cld
              mov            si,0081h       ; ptr to command line
Parse:        lodsb                         ; get a chr
              cmp            al,"/"         ; slash?
              je             ParseNext      ;   yes, ignore
              cmp            al,"-"         ; hyphen?
              je             ParseNext      ;   yes, ignore
              cmp            al," "         ; space or control?
              jbe            ParseNext      ;   yes, ignore
              cmp            al,"z"         ; alpha chr?
              ja             Inform         ;   no, bad parm
              cmp            al,"a"         ; alpha chr?
              jb             Parse1         ;   no, skip
              xor            al,32          ; convert to lowercase
              jmp            Parse2
Parse1:       cmp            al,"Z"         ; alpha chr?
              ja             Inform         ;   no, bad parm
              cmp            al,"A"         ; alpha chr?
              jb             Inform         ;   no, bad parm
Parse2:       cmp            al,"M"         ; use military time format?
              jne            Parse2a        ;   no
              mov            MPLACE,1
              jmp            ParseNext
Parse2a:      cmp            al,"I"         ; install clock?
              jne            Parse2b        ;   no
              mov            PINSTALL,1
              jmp            ParseNext
Parse2b:      cmp            al,"S"         ; display seconds?
              jne            Parse2c        ;   no
              mov            NOSECONDS,0F9h ; *** self-modifying code ("stc")
              jmp            ParseNext
Parse2c:      cmp            al,"F"         ; use slow flicker-free display?
              jne            Parse2d        ;   no
              mov            NOSNOW,0F9h    ; *** self-modifying code ("stc")
              jmp            ParseNext
Parse2d:      cmp            al,"R"         ; remove clock?
              jne            Parse2e        ;   no
              mov            PREMOVE,1
              jmp            ParseNext
Parse2e:      cmp            cx,3           ; is there room for a parm?
              jb             Inform         ;   no, error
              mov            ah,al
              lodsb
              dec            cx
              cmp            al,"="         ; is there maybe a parm?
              jne            Inform         ;   no, error
              mov            al,ah
              cmp            al,"U"         ; set update time?
              jne            Parse3a        ;   no
              call           _asc2bin       ; convert to binary
              jc             BadNumber
              or             al,al          ; too frequent?
              jz             BadNumber      ;   yes
              mov            UPDATES,al
              jmp            Parse4
BadNumber:    mov            dx,offset NrMsg
              jmp            Done
MissingParm:  mov            dx,offset MissMsg
              jmp            Done
Parse3a:      cmp            al,"C"         ; set color?
              jne            Parse3b        ;   no
              call           _asc2bin       ; convert to binary
              jc             BadNumber
              jcxz           MissingParm
              cmp            al,15          ; too large?
              ja             BadNumber      ;   yes
              mov            ah,al
              lodsb
              dec            cx
              jz             MissingParm
              cmp            al,","
              jne            MissingParm
              call           _asc2bin       ; convert to binary
              jc             BadNumber
              cmp            al,15          ; too large?
              ja             BadNumber      ;   yes
              shl            al,4
              or             al,ah
              mov            COLOUR,al
              jmp            Parse4
Parse3b:      cmp            al,"L"         ; set location?
              jne            Inform         ;   no, error
              call           _asc2bin       ; convert to binary
              jc             BadNumber
              jcxz           MissingParm
              or             al,al          ; too small?
              jz             BadNumber      ;   yes
              cmp            al,66          ; too large?
              ja             BadNumber      ;   yes
              mov            ROW,al
              lodsb
              dec            cx
              jz             MissingParm
              cmp            al,","
              jne            MissingParm
              call           _asc2bin       ; convert to binary
              jc             BadNumber
              or             al,al          ; too small?
              jz             BadNumber      ;   yes
              cmp            al,76          ; too large?
              ja             BadNumber      ;   yes
              mov            COL,al
              mov            PLOC,1         ; flag location changed
Parse4:       jcxz           NoParse
ParseNext:    loop           Parse

NoParse:      cmp            NOSECONDS,0F8h ; seconds display?
              je             Setup1         ;   yes, skip
              sub            TIMELEN,3
Setup1:       cmp            MPLACE,0       ; military clock?
              jnz            Setup2         ;   yes
              mov            MPLACE,5       ; assume no seconds
              cmp            NOSECONDS,0F8h ; no seconds display?
              jne            Setup3         ;   right, skip out
              mov            MPLACE,8
              jmp            Setup3
Setup2:       sub            TIMELEN,2
              mov            MPLACE,0
Setup3:       cmp            PLOC,0         ; default ROW,COL?
              jnz            SetupDone      ;   no
              mov            al,TIMELEN
              sub            COL,al
              inc            COL

SetupDone:    cmp            PREMOVE,0      ; remove clock?
              jne            Remover        ;   yes
              cmp            PINSTALL,0     ; install clock?
              jne            Installer      ;   yes
              jmp            Inform         ;   go tell 'em about us

Remover:      mov            dx,offset NotHereMsg
              cmp            INSTALLED,0    ; is the clock installed?
              jz             Done           ;   no, done!
              mov            ax,0DA01h      ; tell clock to remove itself
              int            2Fh            ; (returns clock seg in ES)
              mov            ah,49h         ; free up our memory
              int            21h
              mov            dx,offset RemoveMsg
Done:         mov            ah,9
              int            21h            ; display message
              mov            ax,4C00h       ; terminate without error code
              int            21h

Installer:    cmp            INSTALLED,0    ; is the clock installed?
              jz             InstallOk      ;   no, go ahead
              mov            dx,offset AlreadyMsg
              jmp            Done

InstallOk:    mov            es,ds:[002Ch]
              mov            ah,49h         ; release our copy of environment
              int            21h
              xor            ax,ax          ; point to BIOS data area
              mov            es,ax
              mov            cx,ax
              mov            cl,ROW         ; row
              dec            cx
              mov            al,es:[044Ah]  ; columns/row
              shl            al,1           ; double for attribute
              mul            cl             ; row offset
              mov            cl,COL         ; column
              dec            cx
              shl            cx,1           ; column offset
              add            ax,cx          ; offset within page
              add            ax,es:[044Eh]  ; offset of active video page
              mov            VIDOFS,ax
              mov            al,0B8h        ; assume color
              mov            bx,es:[0463h]  ; get video port
              add            bx,6
              mov            VIDPORT,bx
              cmp            bl,0DAh        ; is the active display color?
              je             GotVideo       ;   yes
              mov            al,0B0h        ; set to mono
GotVideo:     mov byte ptr   VIDSEG+1,al
              mov            CLOCKTIME,1    ; set clock to go
              cli                           ; interrupts off
              mov            ax,es:[0020h]  ; get & save the old INT 8 vector
              mov            cs:OldClock,ax
              mov            ax,es:[0022h]
              mov            cs:OldClock+2,ax
              mov            ax,es:[0040h]  ; get & save the old INT 10h vector
              mov            cs:OldVideo,ax
              mov            ax,es:[0042h]
              mov            cs:OldVideo+2,ax
              mov            ax,es:[00BCh]  ; get & save the old INT 2Fh vector
              mov            cs:MOFS,ax
              mov            ax,es:[00BEh]
              mov            cs:MSEG,ax
              mov            ax,cs
              mov            es:[0022h],ax  ; install new INT 8 handler
              mov word ptr   es:[0020h],cs:offset VidClock
              mov            es:[0042h],ax  ; install new INT 10h handler
              mov word ptr   es:[0040h],cs:offset VidHandler
              mov            es:[00BEh],ax  ; install new INT 2Fh handler
              mov word ptr   es:[00BCh],cs:offset MuxHandler
              sti                           ; interrupts on
              mov            dx,offset InstallMsg
              mov            ah,9
              int            21h            ; display installation message
              mov            dx,ResLength   ; size of interrupt handler (parag)
              mov            ax,3100h       ; terminate and stay resident
              int            21h

Inform:       mov            dx,offset InformMsg
              mov            ah,9
              int            21h            ; display information message
              mov            ax,4C00h       ; exit with error code
              int            21h
Install       endp


_asc2bin      proc           near
              push           bx
              push           dx
              jcxz           _bad
              xor            bx,bx
_digit:       lodsb
              sub            al,"0"
              cmp            al,9
              ja             _done1
              mov            dx,bx
              shl            bx,2
              add            bx,dx
              shl            bx,1
              add            bl,al
              adc            bh,0
              jnz            _bad
              loop           _digit

_done1:       dec            si
              mov            al,bl
              clc
_done:        pop            dx
              pop            bx
              ret
_bad:         stc
              jmp            _done
_asc2bin      endp


; --------------- DATA used only by installation routine ------------------

ROW        db 1               ; row
COL        db ?               ; column
PINSTALL   db 0               ; whether to install ourselves
PLOC       db 0               ; whether ROW,COL have been changed
PREMOVE    db 0               ; whether to remove ourselves
TMP1       dw ?
TMP2       dw ?
INSTALLED  db 0               ; whether we're already installed

InstallMsg db 13,10,"VCLOCK installed.",13,10,"$"
RemoveMsg  db 13,10,"VCLOCK removed.",13,10,"$"

AlreadyMsg db 13,10,"Error: VCLOCK was already installed.",13,10,"$"
MissMsg    db 13,10,"Error: Missing parameter.",13,10,"$"
NotHereMsg db 13,10,"Error: VCLOCK was not installed.",13,10,"$"
NrMsg      db 13,10,"Error: Numeric parameter is invalid or out of range.",13,10,"$"
CpuMsg     db 13,10,"Error: 8088 or 8086 processor.  Use VIDCLOCK instead.",13,10,"$"

HeaderMsg  db "(C) Copyright 1996 Charon Software             ",13,10
           db "VClock: configurable background-operating time display"
           db 13,10,"$"

InformMsg  db 13,10
           db "This utility continuously displays the time, without affecting normal",13,10
           db "operation of the computer.  Display is only done while you're in text mode.",13,10
           db 13,10
           db "VClock options:",13,10
           db 13,10
           db "/I        install the clock",13,10
           db "/R        remove the clock",13,10
           db "/C=f,b    set color: foreground, background",13,10
           db "/F        flicker-free (slow) video, for old CGAs",13,10
           db "/L=r,c    set clock location: row, column",13,10
           db "/M        use military (24 hour) time format",13,10
           db "/S        don't display seconds",13,10
           db "/U=t      clock update frequency (in 1/18th seconds)",13,10
           db "$"

Cseg          ends
              end            Main
