; File......: NWTTS4.ASM
; Author....: James R. Zack
; CIS ID....: 75410,1567
; Date......: $Date:   15 Aug 1991 23:07:02  $
; Revision..: $Revision:   1.2  $
; Log file..: $Logfile:   E:/nanfor/src/nwtts4.asv  $
; 
; This is an original work by James Zack and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
; $Log:   E:/nanfor/src/nwtts4.asv  $
;  
;     Rev 1.2   15 Aug 1991 23:07:02   GLENN
;  Forest Belt proofread/edited/cleaned up doc
;  
;     Rev 1.1   14 Jun 1991 19:54:48   GLENN
;  Minor edit to file header
;  
;     Rev 1.0   01 Apr 1991 01:03:44   GLENN
;  Nanforum Toolkit
;  

; $DOC$
; $FUNCNAME$
;     FT_TTSEND()
; $CATEGORY$
;     NetWare
; $ONELINER$
;     End explicit or implicit transaction under NetWare's TTS
; $SYNTAX$
;     FT_TTSEND() -> nResult
; $ARGUMENTS$
;     None
; $RETURNS$
;         0 - Transaction tracking finished (Success)
;       253 - Transaction tracking disabled
;       254 - Transaction ended, records locked
;       255 - No explicit transactions active
;     > 255 - Transaction number
; $DESCRIPTION$
;    For further information on NetWare's Transaction Tracking System (TTS),
;    consult your NetWare manuals.
; $EXAMPLES$
;    nResult := FT_TTSEND()
;    DO CASE
;       CASE nResult == 0
;          ? "Transaction ended"
;       CASE nResult == 253
;          ? "Transaction tracking disabled"
;       CASE nResult == 254
;          ? "Transaction ended, records locked"
;       CASE nResult == 255
;          ? "No explicit transactions active"
;       OTHERWISE
;          ? "Transaction number " + Ltrim(Str(nResult))
;    ENDCASE
; $SEEALSO$
;    FT_TTSABORT() FT_TTSAVAIL() FT_TTSBEGIN() FT_TTSSTAT()
; $END$


PUBLIC    FT_TTSEND
EXTRN     __RETNL:FAR
EXTRN     __RET:FAR
_NanFor    SEGMENT 'CODE'
          ASSUME cs:_NanFor
FT_TTSEND PROC    FAR
          push    bp
          mov     bp,sp
          push    ds
          push    es
          push    si
          push    di
          mov     ah,0c7h          ; Novell API function c7
          mov     al,01h           ; Subfunction 02
          int     21h              ; TTS Begin Transaction
          mov     ah,00h
          cmp     al,00
          je      GDOP
          xor     cx,cx
          xor     dx,dx
GDOP:     push    cx
          push    dx
          call    __RETNL
          add     sp,4
          pop     di
          pop     si
          pop     es
          pop     ds
          pop     bp
          call    __RET
          ret

FT_TTSEND   endp

_NanFor   ends

          end

