; File......: DISPA.ASM
; Author....: Mike Taylor
; Date......: $Date:   15 Aug 1991 23:06:48  $
; Revision..: $Revision:   1.2  $
; Log file..: $Logfile:   E:/nanfor/src/dispa.asv  $
; 
; This is an original work by Mike Taylor and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
; $Log:   E:/nanfor/src/dispa.asv  $
;  
;     Rev 1.2   15 Aug 1991 23:06:48   GLENN
;  Forest Belt proofread/edited/cleaned up doc
;  
;     Rev 1.1   14 Jun 1991 19:54:28   GLENN
;  Minor edit to file header
;  
;     Rev 1.0   01 Apr 1991 01:03:14   GLENN
;  Nanforum Toolkit
;  
;

.MODEL LARGE
.CODE

        PUBLIC  __ft_vconfig
__ft_vconfig PROC

        XOR     AX,AX           ; CLEAR AX
        MOV     AH,0FH          ; BIOS FUNCTION 0FH, GET VIDEO MODE
        INT     10H

        CMP     AL,7            ; DID BIOS RETURN MONO (= 7)?
        jnz     v1              ; if no, then color
        mov     ax,0b000h       ; yes, switch to mono segment
        jmp     v2              ; bypass color assignment
v1:
        mov     ax,0b800h       ; color segment
v2:
        ret                     ; return segment in ax to caller
__ft_vconfig ENDP



        PUBLIC  __ft_gotoxy
__ft_gotoxy PROC

        push    bp              ; save the caller's bp register
        mov     bp,sp           ; establish our base pointer into the stack
        push    bx              ; save bx and dx registers
        push    dx

        xor     ax,ax           ; clear ax register
        xor     bx,bx           ; bx = 0 means video page 0
        mov     dh, [bp + 8]    ; get y coordinate
        mov     dl, [bp + 6]    ; get x coordinate
        mov     ah,2            ; bios function 02h, set cursor position
        int     10h

        xor     ax,ax           ; clear ax register

        pop     dx              ; restore caller's registers
        pop     bx
        pop     bp
        ret
__ft_gotoxy ENDP



        PUBLIC  __ft_fileread
__ft_fileread PROC

        push    bp              ; save the caller's bp register
        mov     bp,sp           ; establish our base pointer into the stack

        push    bx              ; save caller's registers
        push    cx
        push    dx
        push    ds

        mov     bx,[bp + 6]     ; file handle
        mov     dx,[bp + 8]     ; offset of buffer
        mov     ax,[bp + 10]    ; segment of buffer
        push    ax              ; make buffer segment into default data segment
        pop     ds
        mov     cx,[bp + 12]    ; byte count to read in
        xor     ax,ax           ; clear ax register
        mov     ah,3fh          ; dos function 3fh, file block read
        int     21h

        jnc     fr1             ; if carry flag set then error occured
        xor     ax,ax           ;   and notify by returning 0 bytes
                                ; otherwise ax will contain the actual
                                ; bytes read in.

fr1:
        pop     ds              ; restore caller's registers
        pop     dx
        pop     cx
        pop     bx
        pop     bp

        ret

__ft_fileread ENDP



        PUBLIC  __ft_fileseek
__ft_fileseek PROC

        push    bp              ; save the caller's bp register
        mov     bp,sp           ; establish our base pointer into the stack
        push    bx              ; save bx and cx registers
        push    cx

        mov     bx,[bp + 6]     ; file handle
        mov     cx,[bp + 10]    ; msb of long offset parameter
        mov     dx,[bp + 8]     ; lsb of long offset parameter
        mov     al,[bp + 12]    ; seek direction code
        mov     ah,42h          ; dos function 42h, set file pointer
        int     21h

        jnc     fs1             ; if carry flag not set, no error
        xor     ax,ax           ; if error, clear pointer msb and lsb
        xor     dx,dx
fs1:
        pop     cx              ; restore caller's registers
        pop     bx
        pop     bp
        ret
__ft_fileseek ENDP



        PUBLIC  __ft_getkey
__ft_getkey PROC

        xor     ax,ax           ; clear ax register
        mov     ah,07h          ; dos function 07h, get key pressed
        int     21h

        mov     ah,0            ; zero out msb of ax to make sure returned

        ret                     ;   value is only a byte value

__ft_getkey ENDP


        END

