* Program: Tty.prg
* Author:  Greg Lief
* Version: Clipper Summer '87
* 
* Copyright (c) 1988-89 Greg Lief.
* Placed into Public Domain.
*
* Syntax:  Tty(<row>, <message>, [<delay>, <stop column>])
*
* Thanks to Jeanne Nerwinski, who had the idea in the first
* place, and Jeff Wolach, who suggested the <stop column>.
*

FUNCTION Tty
PARAM xrow, msg, delay, stopcol
PRIVATE xcol, yy
* set delay and stop column if parameters were not passed
delay = IF(PCOUNT() < 3, 20, delay)
stopcol = IF(PCOUNT() < 4, -1, stopcol)
xcol = 0
DO WHILE INKEY() = 0 .AND. stopcol != xcol
   @ xrow, xcol SAY CHR(32) + IF(xcol < 79, ;
      SUBSTR(msg, 1, 79 - xcol), '')
   IF 79 - xcol < LEN(msg)
      @ xrow, 0 SAY SUBSTR(msg,80-xcol,LEN(msg)-79+xcol)
   ENDIF
   FOR yy = 1 TO delay
   NEXT
   xcol = IF( xcol = 79, 0, xcol + 1)
ENDDO
RETURN ('')
* EOF: Tty.prg
