* Program: Conorder.prg
* Author:  Diane Lask
* Version: Clipper Summer '87
* Note(s): Tests and demonstrates the use of
*          conditionally-ordered indexing.
*
* Copyright (c) 1988 Nantucket Corp.


* Create a character memory variable to hold your condition.

condition = "Confield = 'EDIT' "

* Create a temporary database definition with 2 fields:
*    Keyfield: a character field of length 10
*    Confield: a character field of length 10

CREATE Temp
APPEND BLANK
REPLACE Field_name WITH 'Keyfield'
REPLACE Field_type WITH 'C'
REPLACE Field_len  WITH 10
APPEND BLANK
REPLACE Field_name WITH 'Confield'
REPLACE Field_type WITH 'C'
REPLACE Field_len  WITH 10
CLOSE

* Create a database from the definition file.

CREATE Conorder FROM Temp
ERASE  Temp.dbf
USE    Conorder

* Set up the Index expression.

APPEND BLANK
INDEX ON (IF(&condition, CHR(0) + Keyfield, Keyfield + CHR(0)));
   TO Conorder

DO WHILE .T.
   CLEAR
   APPEND BLANK
   @ 10, 5  SAY 'Enter a Keyfield'
   @ 10, 60 GET Keyfield PICTURE '@!'
   @ 12, 5  SAY 'Enter the Condition Field '
   @ 13, 5  SAY 'Type "EDIT" to include in database'
   @ 14, 5  SAY 'Type "QUIT" to quit program and list database'
   @ 14, 60 GET Confield PICTURE '@!'
   READ

   IF Confield = 'QUIT'
      QUIT
   ENDIF

   @ 16, 5 SAY 'Press Any Key To Display Database Records '
   INKEY(0)
   GOTO TOP
   LIST Keyfield, Confield
   INKEY(0)
ENDDO
