/*================= LW.Prg :: Main Program of LazyWriter  ====================

   uasge   :   LW [Options]

   Options :   -               Mono Display
               +               Break On
               ScriptFile      Specify Script file

   Compile :   Clipper LW /n  [/d_SHARE]
   Link    :   blinker fi lw lib ck20 @cl52mid.lnk bl in off

   Author      :   C.K.Hung
   Version     :   1.00 1.01 1.10 1.20
   Last Upadat :   Jan  May  Jun  Jun 1995

 ======================================================================== */

#include 'inkey.ch'

//-------- Declear function for macro program ----
external boxmenu, butmenu, blk_while, m_say, m_cls
external dbsetfilter, dbclearfilter, dbgobottom
external prn_ready, swpruncmd, demonstrate, ainsert, getenv

func main( options )                   // Main Function
priv choice := 1
  options := if( empty(options), '', upper(alltrim(options)) )
  initvar(options)
  initprg(options)

  if !(options$'+-*/!@') .and. file(options)
     lw_maker(options)
  else
     while (choice:=eval(s_MainMenu,choice)) > 0 .or. ;
           stdalert('Are you sure to exit LazyWriter ?   Yes  No') # 1
      begin sequence
        do case
           case choice = 1;  LW_Maker()
           case choice = 2;  LW_dbf()
           case choice = 3;  LW_Edit()
           case choice = 4;  LW_Help()
           case choice = 0;  choice := 1
        endc
      end
     endd
  endi
  scr_close(s_oldscr[9])
  scr_load(s_oldscr)
retu

func initprg(opt)                      // initialize program (Env.)
priv zi,zc,zs,zerr
  set scor off
  set date ansi
  set dele on
  set conf on
  set wrap on
  setcancel( '+' $ opt )
  macrof( s_prgname+'.cfg', , , , lwMacErr )
retu


func initvar( opt )                    // initialize system variables

   // ------------ spare var. -----------

 publ tmp0,tmp1,tmp2,tmp3,tmp4,tmp5,tmp6,tmp7,tmp8,tmp9

   // ------------ system var -----------

publ s_olderr   := errorblock( { |x| lw_error(x) } )
publ s_version  := 'LazyWriter 1.20'
publ s_prgname  := 'LW'
publ s_options  := opt

   // ------------ screen var -----------

publ s_oldscr   := scr_save()                    // save old screen
publ s_dispmode := iscolor() .and. !('-'$opt)    // display mode
publ s_MainMenu, s_MainScr, s_MainOpt            // Main Menu Description
publ s_maincol, s_menucol, s_windcol             // colors
publ s_dbfcol,  s_editcol, s_msgcol, s_errcol, s_filecol, s_listcol

 if s_dispmode

    s_maincol := ' w , b/w , n/w          '
    s_menucol := 'b/w,bg+/w | br/w,r+/w'
    s_msgcol  := ' r/w, w+/br             '
    s_errcol  := ' r, gr+, w+ ; n/w, gr+/w | w+/b, bg+/b, n+ @@'
    s_editcol := '  n/bg, gr+/b, , , w+/bg '
    s_filecol := ' n/bg, w+/b '
    s_listcol := ' w+/b; w+/r; w+/b, w+/g, , , w/b'
 else
    s_maincol := ' w , W+/w, n/w          '
    s_menucol := ' n/w,W+/w | w+/w, N+/w  '
    s_msgcol  := ' n/w,w+/w               '
    s_errcol  := ' w, w+, n ; n/w,w+/w | w+/w, n+/w '
    s_editcol := ' w+/n, n/w, , , w/n     '
    s_filecol := ' w/n, n/w '
    s_listcol := ' w+/w; n/w; n/w, w+/n, , ,n+/w '
 endi

publ _ckinkey  := .t.
publ lwScript  := 'DEFAULT.LW'

publ stru_lw   := { { 'lwName'  , 'C', 16 , 0 } , ;
                    { 'lwType'  , 'C', 6  , 0 } , ;
                    { 'lwFile'  , 'C', 12 , 0 } , ;
                    { 'lwLine'  , 'N', 6  , 0 } , ;
                    { 'lwLength', 'N', 6  , 0 } , ;
                    { 'lwNotes' , 'C', 100, 0 } , ;
                    { 'lwText'  , 'M', 10 , 0 }   }

publ stru_lwtmp := { { 'lwLine' , 'C', 200 , 0 } }

publ word_stru  := '.END.END .DO  .WHIL.ENDD.FOR .NEXT.IF  .ELSE.ENDI.ELSEIF'+;
                   '.CASE.OTHE.OTHERWISE.ENDC.LOOP.EXIT.RETU.QUIT.BEGI.RECO.'

publ word_func1 := 'FUNC.PROC.INIT.EXIT.STAT.'
publ word_func2 := 'FUNC.PROC.'

publ HowtoThin  := { |w,s| ('.'+w+'.')$word_stru }

publ lwSTdOut   := { |s| lw_TxtOut( s, margin[3] ) }

publ lwPageChg  := { |s| lw_stdFF(s), devpos(margin[2],0) }

publ LwCommand  := { |s,w| w:=subs(s,2,1), s:=subs(s,3), ;
                     if( w='\', lw_stdout(s),  if( w=':', lw_txtout(s), ;
                         if( w$'?&', lw_stdout(&(s)), nil ) ) ) }
publ lwMacErr   := { |x| lw_error(x,3) }

publ lwrules        // array of macro program
publ lwtime
publ Lazyage    := 0

publ filewidth  := 200
publ bEditfile  := {|fn,l,h,f| editfile(fn,filewidth,s_filecol,h,f,l) }

retu nil


func stdmsg( msg, mode )               // standard message output funciton
retu m_msg( msg, mode, 22, 4, 72, s_msgcol )


func stdalert( cStr, cDelim, nPos )     // display and make a options menu
  makesound()
retu m_alert( cStr, cDelim, -if(empty(nPos),1,nPos), 22, 4, 72, s_msgcol )


func lw_error( x, mode )               // LazyWriter Error Handle (3 mode)
   // Sorry, Not available
retu nil

func LW_Help()                         // Help of LazyWriter
loca s:=scr_save()
   setcolor( if(s_dispmode,'n/bg', 'n/w' ) )
   stdmsg(' LazyWriter Help   Esc..Exit  PageUp/PageDown..Browse')
   memoedit( memoread('lw.hlp'),5,4,19,75,.f.)
   scr_load(s)
retu nil

func LW_Edit()                         // Edit Script file
  lwScript := padr( lwScript, 40 )
  Stdmsg( ' What is your Script File ?  ', 'S' )
  readmodal( { m_get( 22, 33, s_msgcol, 'lwScript', '@K!' ) } )
  if lastkey() = 27
     retu .f.
  endi
  if ! file(lwscript) .and. ;
     stdalert('New File !  Initialize with sample.lw ?  Yes  No')=1
     memowrit( lwscript, memoread('Sample.LW') )
  endi
retu eval( beditfile, lwScript,,'LazyWriter: Edit Script File => '+trim(lwscript))


//===================================================================
//=============================lw1.prg===============================


// Notes of lw_maker:
//  (1) A script file can not exceed 64k because of memoread(),
//      using include(<file>) can solve this problem.
//  (2) don't handle ';' to join two lines for complex macro, if need to
//      run complex macro, write macro program in other file and use
//      macrof(<file>) run it.

func LW_Maker( cFile )                 // Generate documentation
loca lwBuf, lwFlg, lwTmp,lwi
loca LwPtr, LwLen

  // ------- if cfile invalid, input script file --------------

  lwScript := padr( if( empty(cfile), lwScript, cFile ), 40 )
  if empty(cFile) .or. !file(cFile)
     Stdmsg( ' What is your Script File ?  ', 'S' )
     readmodal( { m_get( 22, 33, s_msgcol, 'lwScript', '@K!', ;
                         {|| file(alltrim(lwScript)) }) } )
     if lastkey() = 27
        retu nil
     endi
  endi

  //---------- read script file and process script file ---------

  LwBuf := Str_Cut( memoread( lwScript ) )      // read file
  LwLen := len( LwBuf )                         // position of header
  LwPtr := 0
  while (++LwPtr) <= LwLen .and. ;
        ( empty( LwBuf[LwPtr] ) .or. asc(LwBuf[LwPtr])=35 )
  endd

  lw_initvar()                                  // init var.
  lw_process( lwbuf, 1, lwptr-1, .t. )          // process header
  if ! lw_confirm()                             // confirm & init
     retu nil
  endi
  lwtime := second()
  lw_init()
  stdmsg( ' Reading the rules of format <'+format+'> ......' )
  lwRules := str_line( memoread( 'lwRules.'+format ), ';', '//' )
  macroa( lwRules, 'Init', , lwCommand, lwMacErr) // run init macro
  lw_process( lwbuf, lwptr+1 )                    // process text area
  macroa( lwRules, 'End', , lwCommand, lwMacErr)  // run end macro

retu nil


func lw_initvar()                      // init control variable before generating

publ lwPageNo:=0, lwFooting
publ lwIdxList   := { {}, {} }

publ Format   := 'DOC'          // Output Format (Other Opts Txt,Ng,Eh,Dbf,..)
publ SysNotes := ''             // Notes of system (object type)
publ Files    := '*.*'          // all files
publ Execute  := '*.exe'
publ Database := '*.dbf'
publ Index    := '*.ntx'       // not support RDD in this version
publ Source   := '*.prg,*.mac'

publ PageLines := 64
publ PageWidth := 0
publ Margin    := { 3, 3, 3, 3 }
publ Path      := ''
publ OutPut    := 'Default.Doc'
publ Confirm   := ! file( s_options )

publ Project     := ''
publ Author      := ''
publ Description := ''
publ Version     := ''
publ Remarks     := ''

retu nil


func lw_confirm()                      // Input or Confirm Control Variables.

memvar Format, SysNotes
memvar Files, Execute, Database, Index, Source          // files
memvar Path , OutPut, Remarks, Confirm, PageLines       // misc
memvar Project, Description, Author, Version            // project
memvar UMargin, DMargin, LMargin, RMargin
loca lwpath, lwscr, lwchkpath, lwget
loca lwprom:=' Edit   Esc...Cancel   Ctrl-W / PageUP / PageDown...Processing'
loca lwbstr := { |s,d,l| s:=if(valtype(s)#'C',d,s), if(len(s)<l,padr(s,l),s) }

  Path        := eval( lwbstr, path,        '', 53 )
  Project     := eval( lwbstr, Project,     '', 80 )
  Description := eval( lwbstr, Description, '', 80 )
  Version     := eval( lwbstr, Version,     '', 80 )
  Author      := eval( lwbstr, Author,      '', 80 )
  Remarks     := eval( lwbstr, Remarks,     '', 80 )
  SysNotes    := eval( lwbstr, SysNotes,    '', 80 )

  Files       := eval( lwbstr, Files,     '*.*'  , 53 )
  Execute     := eval( lwbstr, execute,   '*.exe', 53 )
  Database    := eval( lwbstr, database,  '*.dbf', 53 )
  Source      := eval( lwbstr, source,    '*.prg,*.mac', 53 )

  Format      := eval( lwbstr,Format, 'DOC', 3 )
  OutPut      := eval( lwbstr,output, 'Document', 53 )
  Confirm     := default( confirm, .t. )
  PageLines   := default( PageLines, 64 )
  PageWidth   := default( PageWidth,  0 )
  Margin      := default( margin, { 3, 3, 3, 3 } )

  lwscr := scr_save(5,4,19,76)
  scroll(5,4,19,76)
  m_say( 5, 4,padc('Control Variables of LazyWriter ',72), 'w+/br' )
  setcolor( s_editcol )
  m_say( 6, 4, ' Project Path    '+ padr(Path       ,53)  )
  m_say( 7, 4, ' Project Name    '+ padr(Project    ,53)  )
  m_say( 8, 4, ' Description     '+ padr(Description,53)  )
  m_say( 9, 4, ' Version Info    '+ padr(Version    ,53)  )
  m_say(10, 4, ' Author          '+ padr(Author     ,53)  )
  m_say(11, 4, ' Remarks         '+ padr(Remarks    ,53)  )
  m_say(12, 4, ' System Notes    '+ padr(SysNotes   ,53)  )

  m_say(13, 4, ' Project Files   '+ padr(Files      ,53)  )
  m_say(14, 4, ' Execute Files   '+ padr(Execute    ,53)  )
  m_say(15, 4, ' Database        '+ padr(Index      ,53)  )
  m_say(16, 4, ' Source Code     '+ padr(Source     ,53)  )

  m_say(17, 4, ' Ouput Format    '+ padr(Format     ,53)  )
  m_say(18, 4, ' Output File     '+ padr(OutPut     ,53)  )
  m_say(19, 4, ' Page:Len/wide   '+ str(PageLines,4) + str(PageWidth,5) ;
        + '         Margin (U/D/L/R) '+ str(Margin[1],4) ;
        + str(Margin[2],4) + str(Margin[3],4) + str(Margin[4],4) )

  if confirm
    lwchkpath:= ;
      { |p| p:=alltrim(path), if( right(p,1) $ ':\', nil, p:=p+'\' ), ;
            if( (adir(p+'*.prg')>0), done(.t.,stdmsg(lwprom)), ;
                done(.f., stdmsg(' Invalid Path  ' + p + ;
                                 ' : No source file found !','s'))) }
    stdmsg(lwprom)
    lwget := {}
    aadd(lwget, m_get( 6,23, , 'Path', '@ks53', lwchkpath ) )
    aadd(lwget, m_get( 7,23, , 'Project    ', '@s53' ) )
    aadd(lwget, m_get( 8,23, , 'Description', '@s53' ) )
    aadd(lwget, m_get( 9,23, , 'Version    ', '@s53' ) )
    aadd(lwget, m_get(10,23, , 'Author     ', '@s53' ) )
    aadd(lwget, m_get(11,23, , 'Remarks    ', '@s53' ) )
    aadd(lwget, m_get(12,23, , 'SysNotes   ', '@s53' ) )
    aadd(lwget, m_get(13,23, , 'Files      ', '@s53' ) )
    aadd(lwget, m_get(14,23, , 'Execute    ', '@s53' ) )
    aadd(lwget, m_get(15,23, , 'Database   ', '@s53' ) )
    aadd(lwget, m_get(16,23, , 'Source     ', '@s53' ) )

    aadd(lwget, m_get(17,23, , 'Format     ', 'xxx' ) )
    aadd(lwget, m_get(18,23, , 'OutPut     ', '@ks53' ) )
    aadd(lwget, m_get(19,23, , 'PageLines','9999') )
    aadd(lwget, m_get(19,28, , 'PageWidth','9999') )
    aadd(lwget, m_get(19,61, , 'Margin[1]','999') )
    aadd(lwget, m_get(19,65, , 'Margin[2]','999') )
    aadd(lwget, m_get(19,69, , 'Margin[3]','999') )
    aadd(lwget, m_get(19,73, , 'Margin[4]','999') )
    readmodal(lwget)
    if lastkey()=27 .and. stdalert('Do you want to cancel ?   Yes  No')=1
       retu .f.
    endi
  endi
*  scr_load(lwscr)
retu .t.


func lw_init()                         // initialize gen-document process

loca mdir, mfiles, lwdir:='', mi, mj, mw

  path   := alltrim(path)                         // format control var.
  if( right(path,1) $ ':\', nil, path += '\' )    // path
  Output := alltrim(output)                       // output file
  if ! empty( sysnotes )                          // sysnotes (index)
     mw := str_cut( sysnotes, ',' )
     lwIdxList := { {}, {} }
     for mi := 1 to len( mw )
         if ( mj := at( '$', mw[mi] ) ) > 0
            aadd( lwIdxList[1], uppe( alltrim( left( mw[mi], mj-1 ) ) ) )
            aadd( lwIdxList[2], uppe( alltrim( subs( mw[mi], mj+1 ) ) ) )
         endi
     next
  endi

  if file('lw.dbf')
     dbcloseall()
     use lw
     lwdir := lw->lwtext
     close
  endi
  if ! ( lwdir == lw_chkfile( path + alltrim(files) ) )
     lw_initdbf()
  endi
retu nil


func lw_initdbf()                      // initialize system database
loca mdir, mi, mpct, mtsize, mtok
loca mlines:=0, mNotes := ''

  if confirm .and. file('lw.dbf') .and. ;
     stdalert('Database needs to be updated!   Update   Skip','!')=2
     retu nil
  endi
  dbcloseall()

  if file('lw.dbf')
     stdmsg(' Backup Old System Database to LWOLD.*  ......')
     ferase('lwold.dbf'); frename('lw.dbf','lwold.dbf')
     ferase('lwold.dbt'); frename('lw.dbt','lwold.dbt')
  endi

  stdmsg(' Create New Database and Analyse Source Program......')
  dbcreate( 'lw'   , stru_lw )
  dbcreate( 'lwtmp', stru_lwtmp )
  dbcloseall()
  dbusearea( .t., , 'lwtmp' )
  dbusearea( .t., , 'lw' )
  dbappend()
  lw -> lwName  := '!SYS:FILES'
  lw -> lwNotes := 'Files of ' + path
  lw -> lwTexT  := lw_chkfile( path + alltrim(files) )
  mdir := lw_dir( path, source )
  mtsize := mtok := 0
  aeval( mdir, { |x| mtsize+=x[2] } )
  for mi := 1 to len(mdir)
      mtok += mdir[mi,2]
      mpct := mtok/mtsize
      stdmsg( padr(' Analysing '+mdir[mi,1], 25 ) + ;
              padr(str_bar(40*mpct),40,'') + str(100*mpct,4)+' %' )
      dbselectarea('lwtmp')
      appe from ( path + mdir[mi,1] ) sdf
      mLines += lastrec()
      mnotes += str( lastrec(), 6 ) + '   ' + mdir[mi,1] + chr(13) + chr(10)
      lw_getfunc( mdir[mi,1] )
      dbselectarea('lwtmp')
      zap
  next
  sele lw
  dbappend()
  repl lwname with '!SYS:SOURCE', lwlength with mlines, lwNotes with files
  dbcloseall()
  ferase( 'lwtmp.dbf')
retu nil


func lw_chkfile( cFileSpec )           // return a sorted file list for verify
   // Sorry, Not available
retu ms


func lw_getfunc( cFName )              // get the function info. from lwtmp.dbf
   // Sorry, Not available
retu nil


func lw_addrec( cName, cType, cNote, cText, nLen, cFile, nLine )   // add a record
loca moa := select()
  dbselectarea('lw')
  dbappend()
  repl lwName with cName,  lwLength with default(nLen,0), ;
       lwtype with cType, lwNotes with cNote, lwText with cText, ;
       lwfile with default(cFile,''), lwline with default(nline,0)
  dbselectarea( moa )
retu nil


//===================================================================
//=============================lw2.prg===============================


func lw_process( cFile, nPos, nEnd, lMode )      // process a script file
   // Sorry, Not available
retu nil


func include( cName )                        // include other script file
  if ! file( cName := alltrim(cName) )
     stdalert(' Warning  Script File [ ' + cName + ' ] not found !     OK','!',-1 )
     retu nil
  endi
retu lw_process( cName )


func section( cName, para1, para2, para3 )   // insert sections by running a macro prg
retu macroa( lwRules, cName, { para1,para2,para3 } , lwCommand, lwMacErr )



// ================ output method ================

func lw_txtout( cStr, nMgt )           // generation a line of text
  if  '' $ cStr
      if alltrim(cStr) = ''
         retu scrollpage()
      endi
      cStr := strtran( cStr, '', '' )
  endi
  devout( if(empty(nMgt),'', spac(nMgt) ) + cStr )
  devpos( prow()+1, 0 )
retu lw_pagechk()

func lw_pagechk()                      // Page Checker
  if PageLines <= 0 .or. prow() < ( PageLines - Margin[2] - 2 )
     retu .f.
  endi
  ScrollPage()
retu .t.

func lw_stdout( cStr )                 // standard ouput, using block to re-define
retu eval( lwStdOut, cstr )

func ScrollPage()                      // Scroll Page ( will lw_stdFF() )
retu eval( lwPageChg )

func lw_StdFF()                        // std form feed process
loca ms := if( empty(lwfooting), '', '===[ '+lwFooting+' ]' )
  ms += '===[ Page ' + ltrim(str(++lwPageNo)) + ' ]==='
  if empty( PageLines ) .or.  prow() >= ( Pagelines - Margin[2] )
     devpos( prow() + 1, 0 )
  else
     devpos( Pagelines - Margin[2], 0 )
  endi
  devout( padc( ms, if( empty(PageWidth), 80, PageWidth ) ) )
retu devpos( 0, 0 )

// ================= dir function =================

func lw_dir( cPath, cMap, cDele, bSort )         // get a file list
loca mi, mj, mk
loca aList := {}, dList := {}, aRetu := {}
  default( @bSort, { |x,y,k1,k2| k1:=at('.',x[1]), k2:=at('.',y[1]), ;
                     k1:=if(k1=0,'   '+x[1],subs(x[1],k1+1)+left(x[1],k1-1)), ;
                     k2:=if(k2=0,'   '+y[1],subs(y[1],k2+1)+left(y[1],k2-1)), ;
                     k1 < k2 }  )
  while ! empty( cDele )
     mi := at( ',', cDele )
     mk := cPath + alltrim( if( mi=0, cDele, Left(cDele,mi-1) ) )
     cDele := if( mi=0, '', subs(cDele, mi+1 ) )
     if( empty(mk), nil, dList := aJoin( dList, directory( mk ) ) )
  endd
  while ! empty( cMap )
     mi := at( ',', cMap )
     mk := cPath + alltrim( if( mi=0, cMap, Left(cMap,mi-1) ) )
     cMap := if( mi=0, '', subs(cMap, mi+1 ) )
     if( empty(mk), nil, aList := aJoin( aList, directory( mk ) ) )
  endd
  asort( alist, , , bSort )
  for mi := 1 to len( aList )
      if ascan( dList, { |x| x[1] == aList[mi,1] } ) = 0 .and. ;
         ! ( mi>1 .and. aList[mi,1] == aList[mi-1,1] )
         aadd( aRetu, aList[mi] )
      endi
  next
retu aRetu

func lw_dirsize( aDir )                // file size
loca ms := 0
  aeval( aDir, { |x| ms += x[2] } )
retu tran( ms, '999,999,999 Bytes' )


//===================================================================
//=============================lw3.prg===============================


func lw_idxinfo()                      // get info. of index to an array

loca fidx := lw_dir( path, index )
loca fdbf := lw_dir( path, database )
loca info := {}
loca mi, mj, ml, mk, mn
  dbcloseall()
  dbusearea( , , 'lw' )
  for mi := 1 to len( fidx )
      dbsetindex( path + fidx[mi,1] )
      mk := left( fidx[mi,1], at( '.', fidx[mi,1] ) - 1 )
      if ! empty(lwIdxList) .and. ( mj:=ascan(lwIdxList[1],{|x| mk==x}) ) > 0
         aadd( info, { fidx[mi,1], lwIdxList[2,mj]+'.dbf', indexkey() } )
      else
         mj:= ascan( fdbf, { |x| (mk+'.')$x[1] } )
         aadd( info, { fidx[mi,1], if( mj=0, '', fdbf[mj,1] ), indexkey() } )
      endi
      dbclearind()
   next
  dbcloseall()
retu info


func lw_dbfinfo()                      // get the info. of database to an array

loca fidx  := lw_dir( path, index )
loca fdbf  := lw_dir( path, database )
loca fldbf := len( fdbf )
loca info  := array( fldbf )
loca dList := {}
loca mi, mj, ml, mk, mn

  for mi := 1 to fldbf              // make a dbf info array
      info[mi] := { fdbf[mi,1], fdbf[mi,2], fdbf[mi,3], {}, nil, nil }
  next

  for mi := 1 to len( fidx )
      mk := left( fidx[mi,1], at( '.', fidx[mi,1] ) - 1 )
      if ! empty(lwIdxList) .and. ( mj:=ascan(lwIdxList[1],{|x| mk==x}) ) > 0
         mk := lwIdxList[2,mj]
      endi
      mj   := ascan( fdbf, { |x| (mk+'.') $ x[1] } )
      if( mj=0, '', aadd( info[mj,4], fidx[mi,1] ) )
  next

  for mi :=1 to fldbf
      dbcloseall()
      dbusearea( , , path + info[mi,1] )
      info[mi,5] := dbstruct()
      info[mi,6] := lastrec()
      for mj := 1 to len( info[mi,4] )
          dbsetindex( path+info[mi,4,mj] )
          info[mi,4,mj] := { info[mi,4,mj], indexkey() }
          dbclearind()
      next
  next
  dbcloseall()
retu info

//===================================================================
//=========================lw4.prg  Ver1.2===========================
//* stat uPath, uHistory, uStatCol, uLastFunc, uRow, uCol, uKey

func lw_dbf()                   // browse database
field lwName, lwType, lwFile, lwLine, lwLength, lwNotes, lwText
priv uPath, uHistory, uStatCol, uLastFunc, uRow, uCol, uKey

  if !file('lw.dbf') .or. !file('lw.dbt')
     stdalert('Database not Found, please do "Create Document" first!   OK', '!' )
     retu nil
  endi

  use lw
  go top
  uPath    := trim( subs(lwNotes,10) )
  uHistory := {}
  ustatCol := if( ','$s_filecol, subs(s_filecol,at(',',s_filecol)+1), s_filecol )

  stdmsg( ' Index Database, please wait ......' )
  inde on lwName to lw
  dbseek('A',.t.)

  m_cls( s_editcol, 5, 4, 19, 75 )
  stdmsg( 'Tab..Seek  Enter..View  Ctrl-Enter..EditFile  Alt-L..Report  Esc..Exit' )
  cbrowse( 5,4,19,75, 's!', 'uf_dbf', ;
           {'lwname','lwtype','lwfile','lwline','lwLine+lwLength','lwnotes'},;
           {,,,,,''},,{'Function','Type','File','From','To','Notes'}, 1 )

  close all
  ferase('lw.ntx')

retu nil


func uf_dbf()                       // user function of cbrowse()
loca mk := lastkey()
loca mi, mt
  if mk = K_ESC
     retu 0
  elseif mk = K_CTRL_ENTER
     mt := ' LazyWriter : Edit Source File => '+trim(uPath+lwfile)+' '
     eval( bEditfile, uPath+lwfile, lwLine, mt )
  elseif mk = K_ENTER
     pushscreen()
     uLastFunc:=0
     while lwdispfunc()
     endd
     popscreen()
     retu 2
  elseif mk=K_ALT_L
     uKey:=getkeystr('  List String to Report : ',50)
     if !empty(uKey)
        mi  := alert('Search String Options',{'All Function','All Position'})
        mPos:= GetKeyPos( uKey, mi=2 )
        if empty(mPos)
           alert(' String not found !')
        else
           mi:=alert('Please select the width of report !', {'80','130','180'} )
           lw_listkey( mPos, uKey, if(mi=2,130,if(mi=3,180,80)) )
        endi
     endi
     retu 2
  endi
retu 1

func lwgotofunc( nOldRec, nRow, nCol )          // switch to another function
loca ms:=str_num(len(uHistory),3)+' '
  makesound()
  uRow := nRow
  uCol := nCol
  if recno() # nOldRec
     uLastFunc := nOldRec
     aadd( uHistory, ms+lwname+lwfile+str(lwline,5)+str(recno(),15) )
  endi
  keyboard Chr(K_CTRL_W)
retu nil


func lwdispfunc( )                      // view a function
loca mc:=if(s_dispmode,'w+/br','n/w')
  uStatCol := mc
  m_msg(trim(lwtype)+' '+padr(trim(lwname)+'(..)',20)+' FILE='+lwfile+;
        ' Lines='+ltrim(str(lwline))+'..'+ltrim(str(lwline+lwlength)),,0,,,mc)
  m_msg('<< Alt+ >>  ?..Help  P..Print  Left..Prev  Right..Next  ' + ;
        'Up..LastScr  Down..Goto',,,,,mc )
  setcolor(s_filecol)
  memoedit( lwtext,1,0,23,79, .t., 'uf_viewfunc', filewidth,, uRow, uCol )
retu lastkey()#27


func uf_viewfunc( m, nrow, ncol )       // user function of memoedit
loca mk := lastkey()
loca mr := recno()
loca mw, ms, mi, mj, mPos
  if m>2
     retu 0
  endi
  ms := { row(), col() }
  devpos(0,63)
  dispout( 'Row:'+str_num(nRow+lwLine-1,4)+'  Col:'+str_num(nCOl,3), ustatCol )
  devpos( ms[1], ms[2] )
  if mk=309 .or. chr(mk)$'?/'         //  alt-? => help menu
     mk:=lwkeymenu()
  endi
  do case
     case mk=K_ESC
          uLastFunc:=recno()
     case mk=K_ALT_P
          if prn_ready()
             memowrit('prn',lwtext+chr(12))
          endi
     case mk=K_ALT_LEFT
          dbgoto( recno()-1 )
          while !bof() .and. !isalpha(lwname)
             dbgoto( recno()-1 )
          endd
          if( bof(), dbgoto(mr), lwgotofunc(mr) )
     case mk=K_ALT_RIGHT
          dbgoto( recno()+1 )
          while !eof() .and. !isalpha(lwname)
             dbgoto( recno()+1 )
          endd
          if( eof(), dbgoto(mr), lwgotofunc(mr) )
     case mk=K_ALT_UP
          dbgoto(uLastFunc)
          lwgotofunc(mr)
     case mk=K_ALT_DOWN
          uKey := getkeystr('  Goto Function: ',16)
          if !empty(uKey)
             dbseek( trim(uKey), .t. )
             lwgotofunc(mr)
          endi
     case mk=K_ALT_A
          ms := if( isalpha(lwname), '-'+left(lwname,15), subs(lwname,2)+' ' )
          if dbseek(ms)
             lwgotofunc(mr)
          else
            dbgoto(mr)
            alert(' Control-Sentence not found !')
          endi
     case mk=K_ALT_Z
          ms := if( isalpha(lwname), '*'+left(lwname,15), subs(lwname,2)+' ' )
          if dbseek(ms)
             lwgotofunc(mr)
          else
            dbgoto(mr)
            alert(' Comment-Message not found !')
          endi

     case isalpha(chr(mk))
          tone(80); retu 32
  endc
retu 0


func PickWord( nRow )                  // pick up a word from screen
   // Sorry, Not available
retu mws

func lwKeyMenu()                // help menu of browse functions
loca aMenu:= { 'Alt-Left  => Prev Function        ', ;
               'Alt-Right => Next Function        ', ;
               'Alt-Up    => Last Screen          ', ;
               'Alt-Down  => Seek Function        ', ;
               'Alt-Z     => Comment of Function  ', ;
               'Alt-A     => Control Sentence Only', ;
               'Alt-BS    => Call History         ', ;
               '----------------------------------', ;
               'Alt-<   => Look for Last String   ', ;
               'Alt->   => Look for Next String   ', ;
               'ShiftTab=> Skip to Last String    ', ;
               'Tab     => Skip to Next String    ', ;
               'Alt-F   => Find String            ', ;
               'Alt-N   => Find Next              ', ;
               'Alt-S   => Search String          ', ;
               'Alt-L   => Search String to Report'  }
loca aKey:= { K_ALT_LEFT, K_ALT_RIGHT, K_ALT_UP, K_ALT_DOWN, ;
              K_ALT_Z, K_ALT_A, K_ALT_BS, 0, 307, 308, K_SH_TAB, ;
              K_TAB, K_ALT_F, K_ALT_N, K_ALT_S, K_ALT_L }
loca bSele:={ ,,,,,,,.f.}
loca mi := e_choice(2,36,20,75,'n$',' ',s_listcol,' Help Menu ', aMenu,bSele)
retu if( mi=0, 0, aKey[mi] )


func GetKeyPos( cKey, lListAll )        // search the position of key string
loca ms   := m_msg( '  Searching String... Please wait...','r',,,,s_MsgCol)
loca mPos := {}
loca mt   := 0
loca mr   := recno()
loca mp, mi, mj
     loca for isalpha(lwname) .and. cKey$uppe(lwtext)
     while found() .and. ;
           (inkey()#27 .or. alert('Stop Search ?',{'Yes','No'})#1)
        mp := str_pos( uppe(lwtext), cKey )
        for mi:=1 to if( lListall, len(mp), 1 )
            mt++
            mj:=mPostoLc( lwtext, filewidth, mp[mi] )
            aadd(mPos, str(mt,3)+'  ' + lwname + 'Pos=' + ;
                 str_num(mj[1],4) + '/'+str_num(mj[2],3)+str(recno(),15) )
            m_say( 24,0,padr('  Find String at Funciton: '+lwname+ ;
                   '    (Total:'+ltrim(str(mt))+') ...... ',80),s_MsgCol)
        next
        continue
     endd
     dbgoto(mr)
     scr_load(ms)
retu mPos


func getkeyStr( cProm, nWidth, cInit )          // get a key string
loca ms := m_msg( cProm,'r',,,,s_MsgCol)
priv cKey := uppe( padr( if(empty(cInit),Pickword(),cInit), nWidth) )
  readmodal( { m_get(24,len(cProm)+1,s_MsgCol,'cKey','@k!') } )
  scr_load(ms)
  cKey := if( lastkey()#K_ESC, trim(cKey), '' )
retu if( right(cKey,1)=='.', left(cKey,len(cKEy)-1), cKey)


func lw_listkey( aPos, cKey, nWidth )   // list key string to reprot
loca ml  := len(aPos)
loca mr  := recno()
loca mscr := scr_save(24)
loca mi, mj, mp, ms
  default(@nWidth,80)
  set device to printer
  set printer to lw.buf
  devpos(0,0)
  mi:=mp:=0
  while (mi<ml) .and. ;
        (inkey()#27 .or. alert('Do you want to abort ?',{'Yes','No'})#1)
     @ 3,0 say padc('Research Report of String :'+ cKey,nWidth)
     @ 4,0 say 'Date:'+dtoc(date())+spac(nWidth-21)+'Page:'+str_num(++mp,3)
     @ 6,0 say 'No.  FileName     Lines  FuncName     Text'
     @ mj:=7,0 say repl('-',nWidth)
     while mi<ml .and. mj<60
       dbgoto( val( right(aPos[++mi],10) ) )
       ms := ' Create Report: processing file='+lwfile
       ms += ' func='+lwname+tran(100*mi/ml,'99.99% OK')
       m_say(24,0,padr(ms,80),s_msgcol)
       ms := memoline( lwtext, 250, val(subs(aPos[mi],26,5)) )
       ms := str_num(mi,4)+' '+padr(lwfile,12)+' '+;
             str(lwline,5)+'  '+padr(lwname,12)+' '+ms
       @ ++mj, 0 say padr(ms,nWidth)
     endd
     if mj<60
        devpos(mj+2,0); devout(padc('===End of Report===',nWidth))
     endi
     devpos(0,0)
  endd
  scr_load(mscr)
  dbgoto(mr)
  set printer to
  set device to screen
  setkey( asc('P'), {||__keyboard(chr(K_CTRL_W))} )
  setkey( asc('p'), {||__keyboard(chr(K_CTRL_W))} )
  if editfile('lw.buf',-nWidth-5,s_filecol,'Preview Report','Esc..Exit  P..Print')
     if(prn_ready(), __copyfile('lw.buf','prn'), nil )
  endi
  setkey( asc('P'), nil )
  setkey( asc('p'), nil )
retu nil


func lw_look1( cKey, nRow, nCol )         // look for next appearence.
   // Sorry, Not available
retu mi


func lw_look2( cKey, nRow, nCol )         // look for prev appearence.
   // Sorry, Not available
retu mi



// ========================= THE END ======== LW.PRG =====================

