Program chromatografie;

{$M 16384,0,655360}

uses app,dos,dialogs,drivers,editors,graph,graphapp,helpfile,Input,objects,
     menus,msgbox,stddlg,views,chrHelp,chrres,fhrpr10;

{GraphApp is to be found in the examples of Turbo Vision 7.0 (And 6.0)}

type tprog = object(tapplication) {Hoofdprogramma}
              constructor init;
              procedure initmenubar; virtual;
              procedure initstatusline; virtual;
              Procedure GetEvent(var Event:tEvent); virtual;
              procedure HandleEvent(var event:tevent); virtual;
              Function GetPalette: pPalette; virtual;
              Procedure ShowGraphView;
             end;
     pResults  = ^tResults;
     tResults  = object(tdialog)
                Procedure HandleEvent(var Event:tEvent); virtual;
                Procedure EndModal(Command:word); virtual;
               end;
     pstd      = ^tstd;
     tstd      = object(tdialog)
                  stdget : array[1..5] of PRealLine;
                  Constructor init;
                  Function teststd:boolean;
                  Procedure HandleEvent(var Event:tEvent); virtual;
                 end;
     pchemlist = ^tchemlist;
     tchemlist = object(tListViewer) {Laat zien: Lijst Met Chemicals}
                  FirstTime: boolean;
                  pChemStr : pDOSStream;
                  pChemCol : pChemCollection;
                  Constructor Init(var Bounds:tRect;AScrollBar:pScrollBar);
                  Procedure AddChem;
                  Procedure FocusItem(Item : integer); virtual;
                  Procedure Redraw; virtual;
                  Procedure SelectItem(Item : integer); virtual;
                  Procedure SetState(AState:word;Enable:boolean); virtual;
                  Function CheckAndCalcRt:boolean;
                  Function GetText(Item:integer;MaxLen:Integer):String; virtual;
                  Destructor Done; virtual;
                 end;
     pchemview = ^tchemview; {View met alle CHEMICALS daarin}
     tchemview = object(tdialog)
                  Constructor init;
                  Procedure HandleEvent(var Event:tEvent); virtual;
                 end;
     peditchem = ^teditchem;
     teditchem = object(tdialog)
                  name    : pinputline;
                  quant   : pRealLine;
                  vconst  : pRealLine;
                  Constructor Init;
                  Procedure HandleEvent(var Event:tEvent); virtual;
                  Procedure ShowData(Item:pChemRec);
                  Procedure GetData2(var Item:pChemRec);
                 end;

const cmLoad      = 100; hcHelp      = $FE01;
      cmStandards = 102; hcList      = $FFFF;
      cmSaveNew   = 103; mfYesNo     = mfYesButton+mfNoButton;
      cmOldStd    = 104;
      cmSaveNum   = 105;
      cmViewGraph = 106;
      cmExit      = 109;
      cmResSave   = 111;
      cmResolution= 115;
      cmResult    = 116;
      cmAdd       = 117;hlLoad      = 117;
      cmDel       = 118;hlSave      = 118;
      VGAhi       = 2;
      VGA         = 9;

var gd,gm,count : integer;
    kollengte   : real;
    inst        : file of real;
    uitvf       : text;
    msx,msy     : word;
    stdOK       : boolean;
    std         : pstd;
    pchem       : pchemview;
    pedit       : peditchem;
    pResol      : pResolutionf;
    pSaveRes    : pResults;
    ptxt        : pInputline;
    fname       : string;
    nrOfChem    : byte;
    pList       : pChemList;

Function CalcRetTime:boolean;

begin
 {Zorg dat de net ingevoerde waarden in de edit box meegerekend worden!!!}
 pChem^.Focus; {Simpel he?}

 if std^.teststd = false then
 begin
  messagebox(^C'Calculation of Chromatogram aborted.',nil,mfInformation+mfOKButton);
  CalcRetTime := false;
  exit;
 end;

 if pList^.CheckAndCalcRt = false then
 begin
  messagebox(^C'Calculation of Chromatogram aborted.',nil,mfInformation+mfOKButton);
  CalcRetTime := false;
  exit;
 end;
 CalcRetTime := True;
end;

Procedure leesgegevens;

begin
 stdOK := true;
 assign(inst,'STANDARD.DAT');
 {$I-}
 reset(inst);
 {$I+}
 if IOresult = 0 then
 begin
  read(inst,kollengte,debiet,snelh,schotels,verh);
  close(inst);
 end
 else
 begin
  kollengte := 0; debiet := 0; snelh := 0; schotels := 0; verh := 0;
  messagebox('Could not find file STANDARD.DAT',nil,mfError+mfOKbutton);
 end;
end;

Procedure Schrijfgegevens;

var aaa : string;
    bbb : real;
    ccc : integer;

begin
 assign(inst,'STANDARD.DAT');
 {$I-}
 rewrite(inst);
 {$I+}
 if IOResult <> 0 then
 begin
  messagebox(^C'Error while saving STANDARD.DAT',nil,mfError+mfOKbutton);
  exit;
 end;
 for count := 1 to 5 do
 begin
  std^.stdget[count]^.getdata(aaa);
  val(aaa,bbb,ccc);
  write(inst,bbb);
 end;
 close(inst);
 messagebox(^C'Standards Saved.',nil,mfInformation+mfOKbutton);
end;

Procedure SaveNumResults;

var  forl,tellen  : integer;
     var2,var3    : real;
     nStof,laagste: word;
     Change       : boolean;
     laag2,Rf     : real;
     lijst2       : array[1..30] of chemlabel;
     txt          : string;

 Function get(aa:real):string;

 var bb : string[15];

 begin
  str(aa:15,bb);
  get := bb;
 end;

 Function get10(aa:real):string;

 var bb : string[10];

 begin
  str(aa:10,bb);
  get10 := bb;
 end;

 Function GiveItem(ItemNr:integer):pChemRec;

 begin
  GiveItem := pChemRec(pList^.pChemCol^.At(ItemNr));
 end;

begin
 {I-}
 assign(uitvf,fname);
 rewrite(uitvf);
 {I+}
 if IOResult <> 0 then
 begin
  messagebox(^C'Error while making file.',nil,mfError+mfOkbutton);
  exit;
 end;
 nstof := 0;
 repeat
  Change := false;
  laag2 := 1e38;
  for tellen := 0 to pList^.Range-1 do
  begin
   if (GiveItem(tellen)^.tr < laag2) and (GiveItem(tellen)^.mol > 1e-30) then
   begin
    laag2 := GiveItem(tellen)^.tr;
    laagste := tellen;
   end;
  end;
  if laag2 < 1e38 then
  begin
   Nstof := NStof + 1;
   lijst2[NStof] := GiveItem(laagste)^;
   pChemRec(pList^.pChemCol^.At(laagste))^.tr := 1.6e38;
   Change := true;
  end;
 Until not Change;
 Writeln(uitvf,'GLC/HPLC-simulator   Programming by:Franois Reincke   V2.0  (c)1995   Shareware');
 writeln(uitvf,' ');
 writeln(uitvf,'STANDARD FIGURES OF KOLOM:');
 writeln(uitvf,'Length of kolom(m): '+get(kollengte));
 writeln(uitvf,'Debiet of kolom(m3/s): '+get(debiet));
 writeln(uitvf,'Flowspeed (Gas or liquid) (m/s): '+get(snelh));
 writeln(uitvf,'Plate Number (HETP): '+get(schotels));
 writeln(uitvf,'Volumeratio stationairy/mobile phase: '+get(verh));
 writeln(uitvf,'  ');
 Writeln(uitvf,'Piek nr|Injec.Quant.(mol)|Equil.Const|Retent.time (s)|Cmax(mol/l)|Stand.dev.');
 Writeln(uitvf,'-------+-----------------+-----------+---------------+-----------+----------');
 for forl := 1 to nstof do
 begin
  var3 := lijst2[forl].tr/sqrt(schotels);
  var2 := (lijst2[forl].mol*1e-3)/(debiet*var3*sqrt(2*pi));
  str(forl:3,fname);
  write(uitvf,'  ',fname+'  |   '+get10(lijst2[forl].mol)+'    |'+get10(lijst2[forl].Kv)+' |');
  writeln(uitvf,get(lijst2[forl].tr),'|'+get10(var2)+' |'+get10(var3));
 end;
 writeln(uitvf,'  ');
 if nstof <> 1 then
 begin
  writeln(uitvf,'Resolution between pieks:|Resolutionfactor:');
  writeln(uitvf,'-------------------------+-----------------');
  for forl := 2 to nstof do
  begin
   var2 := lijst2[forl-1].tr/sqrt(schotels);
   var3 := lijst2[forl].tr/sqrt(schotels);
   Rf := (lijst2[forl].tr-lijst2[forl-1].tr)/(0.5*(4*var3+4*var2));
   str(forl-1:2,fname);
   str(forl:2,txt);
   writeln(uitvf,'         '+fname+'-'+txt+'          | ',get(Rf));
  end;
 end;
 Close(uitvf);
end;

Constructor tprog.init;

var tel :word;

 Procedure intro;

 var D : pdialog;
     R : trect;

 begin
  R.assign(0,0,40,20);
  D := new(pdialog,init(R,'Welcome'));
  with d^ do
  begin
   options := options or ofCentered;
   R.Grow(-1,-1);
   dec(R.B.Y,3);
   insert(new(Pstatictext, init(R,
    #13 +
    ^C'C H R S I M'#13 +
    #13 +
    #13 +
    ^C'A Model Which Calculates'#13 +
    ^C'the Outcome of Chromatografy'#13 +
    #13 +
    #13 +
    ^C'Programming by:'#13 +
    ^C'Franois  Reincke'#13 +
    #13 +
    #13 +
    ^C'(c) 1994   Version 2.0   Shareware')));
   R.assign(14,16,24,18);
   insert(new(Pbutton,init(R,'~O~k',cmOk, bfNormal)));
  end;
  if validview(d) <> nil then
  begin
   execview(d);
   dispose(D,done);
  end;
 end;

begin
 inherited init;
 RegisterHelpFile;
 intro;
 leesgegevens;
 std := new(pstd,init);
 insertwindow(std);
 pEdit := new(pEditChem,init);
 insertWindow(pEdit);
 pchem := new(pChemView,init);
 insertwindow(pChem);
 Gd := VGA;
 Gm := VGAHI;
 if not(GraphAppInit(Gd,Gm,nil,true)) then
 begin
  messagebox('Could not load EGAVGA.BGI.',nil,mfError+mfOkbutton);
 end;
 ChemChanged := true;
end;

Procedure tprog.initmenubar;

var R : trect;

begin
 getextent(R);
 R.B.Y := R.A.Y + 1;
 menubar := new(Pmenubar, init(R, newmenu(
   Newsubmenu('~F~ile',hcFile, newmenu(
    NewItem('~N~ew','',kbNoKey,cmNew,hcNew,
    Newitem('~L~oad file','F2',kbF2,cmload,hcOpen,
    Newitem('~S~ave file','F3',kbF3,cmSave,hcSave,
     Newline(
    newitem('E~x~it','ALT-X',kbALTX,cmExit,hcExit,
    nil)))))),
   Newsubmenu('~S~tandards',hcStandards, newmenu(
    Newitem('~L~oad old Values','',kbNoKey, cmOldStd, hcLoadStd,
    Newitem('~S~ave new Values','',kbNoKey, cmSaveNew, hcSavestd,
    nil))),
   Newsubmenu('~C~hromatogram',hcChromatogram, newmenu(
    NewItem('View ~C~hromatogram','F4',kbF4,cmViewGraph, hcViewChrom,
    NewItem('View ~P~ieks','F5',kbF5,cmResult,hcViewPieks,
    NewItem('View ~R~esolution f.','F6',kbF6,cmResolution,hcViewRes,
    NewItem('~S~ave Results','',kbNokey,cmSaveNum, hcSaveRes,
    nil))))),
   nil))))));
end;

Procedure tprog.initstatusline;

var R :trect;

begin
 getextent(R);
 R.A.Y := R.B.Y - 1;
 statusline := new(Pstatusline, init(R,
   Newstatusdef(hcNoContext, hcNoContext,
    NewStatusKey('~F1~ Help', kbF1, cmHelp,
    newStatuskey('~F2~ Load', kbF2, cmLoad,
    newstatuskey('~F3~ Save', kbF3, cmSave,
    newstatuskey('~F4~ Chromatogram', kbF4, cmViewGraph,
    newstatuskey('~F5~ Pieks', kbF5, cmResult,
    newstatuskey('~F9~ Swap', kbF9, cmNext,
    newstatuskey('~F10~ Menu', kbF10, cmMenu,
    newstatuskey('~ALT-X~ Exit', kbALTX, cmExit,
    newstatuskey('', kbAltQ, cmQuit,
    nil))))))))),
   Newstatusdef(hcFile,hcFile,
    NewStatusKey('~F1~ Help', kbF1, cmHelp,
    newstatuskey(' ~Load~ and/or ~Save~ files. Also for ~Exit~.',kbnokey, cmCancel,
    nil)),
   NewStatusDef(hcNew,hcNew,
    NewStatusKey('~F1~ Help', kbF1, cmHelp,
    newstatuskey(' ~Clear~ all the Chemicals.',kbNoKey, cmCancel,
    nil)),
   Newstatusdef(hcOpen,hcOpen,
    NewStatusKey('~F1~ Help', kbF1, cmHelp,
    newstatuskey(' ~Load~ a *.chr file from disk.',kbnokey, cmCancel,
    nil)),
   Newstatusdef(hcSave,hcSave,
    NewStatusKey('~F1~ Help', kbF1, cmHelp,
    newstatuskey(' ~Save~ a *.chr file on a disk.',kbnokey, cmCancel,
    nil)),
   Newstatusdef(hcExit,hcExit,
    NewStatusKey('~F1~ Help', kbF1, cmHelp,
    newstatuskey(' Exit ~CHRSIM~. Until next time!',kbnokey, cmCancel,
    nil)),
   Newstatusdef(hcStandards,hcSaveStd,
    NewStatusKey('~F1~ Help', kbF1, cmHelp,
    newstatuskey(' (Re)~Load~ or ~Save~ the Standard Figures of the Kolom',kbNokey,cmCancel,
    nil)),
   Newstatusdef(hcChromatogram,hcChromatogram,
    NewStatusKey('~F1~ Help', kbF1, cmHelp,
    newstatuskey(' ~Calculate~ the Chromatogram and ~View~ the Results.',kbnokey,cmCancel,
    nil)),
   Newstatusdef(hcViewChrom,hcViewChrom,
    NewStatusKey('~F1~ Help', kbF1, cmHelp,
    newstatuskey(' ~Plot~ the Chromatogram on the screen.',kbnokey,cmCancel,
    nil)),
   Newstatusdef(hcViewPieks,hcViewPieks,
    NewStatusKey('~F1~ Help', kbF1, cmHelp,
    newstatuskey(' ~View~ the nummeric data on every piek.',kbnokey,cmCancel,
    nil)),
   Newstatusdef(hcViewRes,hcViewRes,
    NewStatusKey('~F1~ Help', kbF1, cmHelp,
    newstatuskey(' ~View~ the Resolution factors between two adjacent pieks.',kbnokey,cmCancel,
    nil)),
   Newstatusdef(hcSaveRes,hcSaveRes,
    NewStatusKey('~F1~ Help', kbF1, cmHelp,
    newstatuskey(' ~Save~ the NUMMERIC outcome of the chromatogram to ~Disk~.',kbnokey,cmCancel,
    nil)),
   NewStatusDef(hcHelp,hcHelp,
    NewStatusKey('Use ~TAB~ or the mouse to select. ~ESC~ to Exit Help.',kbNoKey,cmCancel,
    nil),
   NewStatusDef(hcChrInst,hcChrInst,
    NewStatusKey('~F1~ Help', kbF1, cmHelp,
    NewStatuskey(' Enter how the ~Chromatogram~ should be made.', kbNoKey, cmCancel,
    nil)),
   NewStatusDef(hcList,hcList,
    NewStatusKey('~F1~ Help',kbF1, cmHelp,
    NewStatusKey('~Insert~ Add Chemical', kbIns, cmAdd,
    NewStatusKey('~Delete~ Delete Chemical', kbDel, cmDel,
    newStatuskey('', kbF2, cmLoad,
    newstatuskey('', kbF3, cmSave,
    newstatuskey('', kbF4, cmViewGraph,
    newstatuskey('', kbF5, cmResult,
    newstatuskey('~F9~ Swap', kbF9, cmNext,
    newstatuskey('', kbF10, cmMenu,
    newstatuskey('~ALT-X~ Exit', kbALTX, cmExit,
    newstatuskey('', kbAltQ, cmQuit,
    nil))))))))))),
   nil)))))))))))))))));
end;

procedure tProg.GetEvent(var Event: TEvent);
var
  W: PWindow;
  HFile: PHelpFile;
  HelpStrm: PDosStream;
const
  HelpInUse: Boolean = False;
begin
  inherited GetEvent(Event);
  case Event.What of
    evCommand:
      if (Event.Command = cmHelp) and not HelpInUse then
      begin
        HelpInUse := True;
        HelpStrm := New(PDosStream, Init(FExpand('chrHelp.hlp'), stOpenRead));
        HFile := New(PHelpFile, Init(HelpStrm));
        if HelpStrm^.Status <> stOk then
        begin
          MessageBox('Could not open help file.', nil, mfError + mfOkButton);
          Dispose(HFile, Done);
        end
        else
        begin
          W := New(PHelpWindow,Init(HFile, GetHelpCtx));
          if ValidView(W) <> nil then
          begin
            W^.HelpCtx := hcHelp;
            ExecView(W);
            Dispose(W, Done);
          end;
          ClearEvent(Event);
        end;
        HelpInUse := False;
      end;
    evMouseDown:
      if Event.Buttons <> 1 then Event.What := evNothing;
  end;
end;

Procedure tprog.HandleEvent(var Event:Tevent);

 Procedure insertOldstd;

 var get : string;

  Procedure S(aa:real);

  begin
   str(aa:15:10,get);
  end;

 begin
  if messagebox(^C'Lose new values?',nil,mfWarning+mfYesNoCancel) = cmYes then
  begin
   leesgegevens;
   for count := 1 to 5 do
    begin
     case count of
      1 : S(kollengte);
      2 : S(debiet);
      3 : S(snelh);
      4 : S(schotels);
      5 : S(verh);
     end;
     std^.stdget[count]^.setdata(get);
    end;
   std^.redraw;
   std^.Focus;
  end;
 end;

 Procedure SaveNew;

 begin
  if std^.teststd = false then
  begin
   messagebox(^C'Standards NOT Saved',nil,mfInformation+mfOKButton);
   exit;
  end;
  if messagebox(^C'Lose Old Values?',nil,mfConfirmation+mfYesNoCancel) = cmYes then
  begin
   Schrijfgegevens;
  end;
  Std^.Redraw;
  Std^.Focus;
 end;

 Procedure Results;

 var R :Trect;

 begin
  CalcRetTime;
  R.assign(1,1,52,8);
  pSaveRes := new(pResults,init(R,'Save Results'));
  with pSaveRes^ do
  begin
   Options := options or ofCentered;
   R.assign(2,2,48,3);
   ptxt := new(pInputline,init(R,80));
   insert(ptxt);
   R.assign(2,1,48,2);
   insert(new(pLabel,init(R,'Enter a Name to Save the Nummeric Results to:',ptxt)));
   R.assign(10,4,20,6);
   insert(new(pButton,init(R,'~S~ave',cmResSave,bfDefault)));
   R.assign(30,4,40,6);
   insert(new(pButton,init(R,'~C~ancel',cmCancel,bfNormal)));
   SelectNext(False);
   HelpCtx := hcSaveRes;
  end;
  if ExecuteDialog(pSaveRes,nil) = cmResSave then
   SaveNumResults;
 end;

 Procedure ShowPieks(Which:boolean);

 var R    : trect;

 begin
  if not CalcRetTime then
   exit;
  if nrOfChem = 0 then
  begin
   MessageBox(^C'No Chemicals Entered.',nil,mfError+mfOkButton);
   exit;
  end;
  if Which then
  begin
   GetExtent(R);
   R.B.Y := R.B.Y-3;R.A.Y := R.A.Y+1;R.A.X := R.A.X+1;R.B.X := R.B.X-1;
   pPiek := New(pPieks,init(R,pList^.pChemCol));
   Executedialog(pPiek,nil);
  end
  else
  begin
   GetExtent(R);
   R.B.Y := R.B.Y-3;R.A.Y := R.A.Y+1;R.A.X := R.A.X+1;R.B.X := R.B.X-1;
   pResol := new(pResolutionf,init(R,pList^.pChemCol));
   Executedialog(pResol,nil);
  end;
 end;

 Procedure NewChem;

 var ccc : integer;
     ddd : string;

 begin
  if MessageBox(^C'Clear old Chemicals?',nil,mfConfirmation+mfYesNo) =
     cmYes then
  begin
   for ccc := 0 to pList^.pChemCol^.Count-1 do
    Freemem(pList^.pChemCol^.At(ccc),SizeOf(ChemLabel));
   pList^.pChemCol^.DeleteAll;
   pList^.ReDraw;
   ChemChanged := True;
  end;
 end;

 Procedure LoadChem;

 var pSave    : pFileDialog;
     FileName : FNameStr;
     pExStr   : pDOSStream;
     ddd      : string;
     tel      : integer;

 begin
  FileName := '*.CHM';
  pSave := new(pFileDialog,init('*.CHM','Load Chemical List','~N~ame',fdOpenButton,hlLoad));
  pSave^.HelpCtx := hcOpen;
  if ExecuteDialog(psave,@FileName) <> cmCancel then
  begin
   if pList^.Range > 0 then
   begin
    case Messagebox(^C'Delete old chemicals before loading file?',nil,mfInformation+mfYesNoCancel) of
     cmYes : begin
              for tel := 0 to pList^.pChemCol^.Count-1 do
               FreeMem(pList^.pChemCol^.At(tel),SizeOf(ChemLabel));
              pList^.pChemCol^.DeleteAll;
              pList^.ReDraw;
             end;
     cmCancel : exit;
    end;
   end;
   pExStr := new(pDOSStream,init(FileName,stOpenRead));
   if pExStr^.Status = stOk then
   begin
    pList^.pChemCol^.Load(pExStr^);
    pList^.ReDraw;
    if pList^.Range > 0 then
     pList^.FocusItem(0);
    ChemChanged := true;
   end
   else
   begin
    if pExSTr^.Status = -2 then
     MessageBox(^C'Could not find file.',nil,mfError+mfOkButton)
    else
     Messagebox(^C'Error while loading file.',nil,mfError+mfOkButton);
   end;
   pExStr^.Done;
  end;
 end;

 Procedure SaveChem;

 var pSave    : pFileDialog;
     FileName : FNameStr;
     pExStr,pExStr2: pDOSStream;

 begin
  CalcRetTime;
  FileName := '*.CHM';
  pSave := new(pFileDialog,init('*.CHM','Save Chemical List','~N~ame',fdOkButton,hlSave));
  pSave^.HelpCtx := hcSave;
  if ExecuteDialog(psave,@FileName) <> cmCancel then
  begin
   pExStr := new(pDOSStream,init(FileName,stOpenWrite));
   if pExStr^.Status = stOk then
   begin
    if MessageBox(^C'File already exists. Overwrite?',nil,mfConfirmation+mfYesNoCancel)
     = cmYes then
    begin
     pExStr^.Seek(0);
     pList^.pChemCol^.Store(pExStr^);
     pExStr^.Truncate;
     MessageBox(^C'Chemicals succesfully saved to file: '+FileName,nil,mfConfirmation+mfOkbutton);
    end
    else
     MessageBox(^C'Chemicals NOT Saved.',nil,mfInformation+mfOkButton);
   end
   else
   begin
    if pExStr^.Status = -2 then
    begin
     pExStr2 := new(pDOSStream,init(FileName,stCreate));
     pList^.pChemCol^.Store(pExStr2^);
     Dispose(pExStr2,done);
     MessageBox(^C'Chemicals succesfully saved to file: '+FileName,nil,mfConfirmation+mfOkbutton);
    end
    else
     MessageBox(^C'Error while writing file. Chemicals NOT saved.',nil,mferror+mfOkbutton);
    pExStr^.Reset;
   end;
   Dispose(pExStr,Done);
  end;
 end;

 Procedure ExitProg;

 var Event2 : tEvent;

 begin
  if MessageBox(^C'EXIT - Are you sure?',nil,mfConfirmation+mfYesButton+mfNoButton)
   = cmYes then
  begin
   Event2.What := evCommand;
   Event2.Command := cmQuit;
   Event2.InfoPtr := nil;
   PutEvent(Event2);
  end;
 end;

begin
 inherited HandleEvent(Event);
 if Event.What = evCommand then
 begin
  case Event.Command of
   cmOldStd    : InsertOldStd;
   cmSaveNew   : SaveNew;
   cmViewGraph : ShowGraphView;
   cmExit      : ExitProg;
   cmResult    : ShowPieks(true);
   cmResolution: ShowPieks(false);
   cmSaveNum   : Results;
   cmNew       : NewChem;
   cmLoad      : LoadChem;
   cmSave      : SaveChem;
   cmAdd       : begin
                  pList^.AddChem;
                  ChemChanged := true;
                 end;
   cmDel       : begin
                  if pList^.Range > 0 then
                  begin
                   if messagebox(^C'Are you sure you want to delete '+pChemRec(pList^.pChemCol^.At(pList^.Focused))^.Name+'?',
                    nil,mfConfirmation+mfYesNo) = cmYes then
                   begin
                    FreeMem(pList^.pChemCol^.At(pList^.Focused),SizeOf(ChemLabel));
                    pList^.pChemCol^.AtDelete(pList^.Focused);
                    pList^.ReDraw;
                    ChemChanged := true;
                   end;
                  end;
                 end;
  else
   exit;
  end;
  ClearEvent(Event);
 end;
end;

function TProg.GetPalette: PPalette;
const
  CNewColor = CAppColor + CHelpColor;
  CNewBlackWhite = CAppBlackWhite + CHelpBlackWhite;
  CNewMonochrome = CAppMonochrome + CHelpMonochrome;
  P: array[apColor..apMonochrome] of string[Length(CNewColor)] =
    (CNewColor, CNewBlackWhite, CNewMonochrome);
begin
  GetPalette := @P[AppPalette];
end;

Procedure Tprog.ShowGraphView;

var pChr          : pChrOpt;
    ChrResult     : word;
    AllOK           : boolean;
    Event           : tEvent;
    b,sigma,fy,fx   : real;
    ky,kx           : integer;
    d,fl            : word;
    nx,ny,ox,oy     : integer;
    step,x,y        : real;
    Conc,exponent   : real;
    txt             : string;

 Function Geefxwaarde(tijd:real):word;

 begin
  Geefxwaarde := round((((tijd-xL)/(xH-xL))*(msx-40))+30);
 end;

 Function Geefywaarde(conc:real):word;

 begin
  geefywaarde := round((((conc)/(yH-yL))*(msy-30))+10);
 end;

begin
 if not(CalcRetTime) then
  exit;
 pChem^.Focus;
 if NrOfChem = 0 then
 begin
  MessageBox(^C'No Chemicals Entered.',nil,mfError+mfOkButton);
  exit;
 end;

 {Vraag naar grenzen van grafiek en graphics Device}
 {Instelling y-as}
 cmax := 0;
 for count := 0 to pList^.pChemCol^.Count-1 do
 begin
  cmax2 := 1e-3*(ChemLabel(pList^.pChemCol^.At(count)^).mol*sqrt(schotels))/
                (ChemLabel(pList^.pChemCol^.At(count)^).tr*debiet*sqrt(2*pi));
  if cmax2 > cmax then cmax := cmax2;
 end;

 {Instelling x-as}
 tmax := 0;
 for count := 0 to pList^.pChemCol^.Count-1 do
  if ChemLabel(pList^.pChemCol^.At(count)^).tr > tmax then tmax := ChemLabel(pList^.pChemCol^.At(count)^).tr;

 {Dialogbox}
 pChr := new(pChrOpt,init);
 ChrResult := ExecuteDialog(pChr,nil);
 if ChrResult in [cmChrom,cmChromPrint] then
 begin
  {Draw Chromatogram}
  if not GraphicsStart then
  begin
   Messagebox(GraphErrorMsg(Graphresult) + '.', nil, mfError + mfOkButton);
   exit;
  end;
  ChemChanged := false;

  msx := GetMaxX;
  msy := GetMaxY;
  OutTextXY(1,msy-10,'One moment please...');
  {Basis van grafiek}
  line(30,10,30,msy-20);
  line(30,msy-20,msx-10,msy-20);
  {Grafiek tekenen}
  Step := (xH-xL)/((msx-30)/2);
  ox := 30;oy := msy-20;x := xL;
  repeat
   y := 0; {Summerize all the concentrations of all chemicals}
   for fl := 0 to pList^.pChemCol^.Count-1 do
   begin
    sigma   := ChemLabel(pList^.pChemCol^.At(fl)^).tR/sqrt(schotels);
    cmax    := 1e-3*(ChemLabel(pList^.pChemCol^.At(fl)^).mol)/(debiet*sigma*sqrt(2*pi));
    exponent:= -0.5*(x-ChemLabel(pList^.pChemCol^.At(fl)^).tr)*(x-ChemLabel(pList^.pChemCol^.At(fl)^).tr)/(sigma*sigma);
    if exponent < -88 then exponent := -88;
    Conc := cmax*exp(exponent);
    if Conc > 1e-90 then y := y + Conc;
    if y < yL then y := yL;
    if y > yH then y := yH;
   end;
   nx := geefxwaarde(x);
   ny := geefywaarde(yH-y);
   line(ox,oy,nx,ny);
   ox := nx;
   oy := ny;
   x := x + step;
  until x >= xH+step;
  Setfillstyle(0,0);
  Bar(1,msy-10,msx,msy);
  {opmaken y-as}
  ky := 0;fy := 1;
  while (((yL+yH)*fy)/2) < 1 do
  begin
   ky := ky + 1;
   fy := fy *10;
  end;
  while (((yL+yH)*fy)/2) > 10 do
  begin
   ky := ky - 1;
   fy := fy /10;
  end;
  b := yL;
  repeat
   line(28,geefywaarde(yH-b),32,geefywaarde(yH-b));
   str((b*fy):3:1,txt);
   outtextxy(3,geefywaarde(yH-b)-3,txt);
   b := b + yS;
  until b >= yH+yS;
  if ky = 0 then outtext('Concentratie(mol/l)')
  else
  begin
   str(-1*ky,txt);
   outtext('Concentratie(10^'+txt+' mol/l)');
  end;
  {opmaken x-as}
  kx := 0;fx := 1;
  while (((xL+xH)*fx)/2) > 10 do
  begin
   kx := kx + 1;
   fx := fx /10;
  end;
  while (((xL+xH)*fx)/2) < 1 do
  begin
   kx := kx - 1;
   fx := fx *10;
  end;
  b := xL;
  repeat
   line(geefxwaarde(b),msy-18,geefxwaarde(b),msy-22);
   str((b*fx):3:1,txt);
   outtextxy(geefxwaarde(b)-12,msy-16,txt);
   b := b + xS;
  until b >= xH+xS;
  if kx = 0 then outtextxy(msx-120,msy-8,'Tijd(s)')
  else
  begin
   str(kx,txt);
   outtextxy(msx-120,msy-8,'Tijd(10^'+txt+' s)');
  end;
  if ChrResult = cmChromPrint then
   PrintScr(msx,msy,1,false) {See FHRPR10.PAS)}
  else
   repeat
    GetKeyEvent(Event);
   until Event.What <> evNothing;

  {Close Graph}
  GraphicsStop;
 end;
end;

Constructor tstd.Init;

var R :trect;
    get,t: string;
    count: word;

 Procedure S(aa:real);

 begin
  str(aa:15:10,get);
 end;

begin
 R.assign(30,0,80,10);
 inherited init(R,'Standard figures');
 Flags := wfMove;
 for count := 1 to 5 do
 begin
  R.assign(31,count,48,count+1); {Max grootte: 15 karakters}
  stdget[count] := new(pRealLine, init(R,15));
  case count of
   1 : S(kollengte);
   2 : S(debiet);
   3 : S(snelh);
   4 : S(schotels);
   5 : S(verh);
  end;
  stdget[count]^.setdata(get);
  insert(stdget[count]);
  R.assign(1,count,31,count+1);
  case count of
   1 : t := '~L~ength of kolom (m)';
   2 : t := '~D~ebiet of kolom (m3/s)';
   3 : t := '~S~peed of flow (m/s)';
   4 : t := 'Number of ~P~lates';
   5 : t := '~R~atio stationary/mobile phase';
  end;
  insert(new(plabel,init(R,t,stdget[count])));
 end;
 R.assign(8,7,22,9);
 insert(new(pbutton,init(r,'~I~nsert old', cmOldstd, bfNormal)));
 R.Assign(25,7,37,9);
 insert(new(pbutton,init(R,'~S~ave new', cmSaveNew, bfNormal)));
 Selectnext(false);
end;

Function tstd.teststd:boolean;

var aaa : word;
    t : string;
    aab : real;
    xxx : tevent;

begin
 for aaa := 1 to 5 do
 begin
  stdget[aaa]^.getReal(aab);
  if not(stdGet[aaa]^.StatusOk) then
  begin
   case aaa of
    1 : t := 'Length of kolom';
    2 : t := 'Debiet of kolom';
    3 : t := 'Speed of flow';
    4 : t := 'Number of Plates';
    5 : t := 'Ratio stationary/mobile phase';
   end;
   messagebox('Invalid nummeric format of "'+t+'"',nil,mfOKbutton+MfError);
   teststd := false;
   exit;
  end;
 end;
 teststd := true;
 stdget[1]^.getReal(kollengte);
 stdget[2]^.getReal(debiet);
 stdget[3]^.getReal(snelh);
 stdget[4]^.getReal(schotels);
 stdget[5]^.getReal(verh);
end;

Procedure tstd.HandleEvent(var Event:tEvent);

begin
 inherited HandleEvent(Event);
 if Event.What = evBroadcast then
  if Event.Command = cmDefault then
   if (stdget[1]^.GetState(sfFocused)) or
      (stdget[2]^.GetState(sfFocused)) or
      (stdget[3]^.GetState(sfFocused)) or
      (stdget[4]^.GetState(sfFocused)) or
      (stdget[5]^.GetState(sfFocused)) then
    begin
     SelectNext(False);
     ClearEvent(Event);
    end;
end;

Constructor tChemView.init;

var r :tRect;
    ptxt : pstring;
    pScrl : pScrollbar;

begin
 R.assign(0,0,30,17);
 inherited init(R,'Chemicals');
 Flags := wfMove;

 R.assign(29,1,30,16);
 pScrl := new(pScrollbar,init(R));
 insert(pScrl);
 R.assign(1,1,29,16);
 pList := new(pChemList,init(R,pScrl));
 insert(pList);
 pList^.ReDraw;
 Selectnext(False);

 HelpCtx := hcList;
end;

Procedure tChemView.HandleEvent(var Event:tEvent);

begin
 inherited HandleEvent(Event);
 if Event.What = evBroadcast then
  if Event.Command = cmDefault then
   if GetState(sfFocused) then
   begin
    pEdit^.Focus;
    pEdit^.Name^.Focus;
    ClearEvent(Event);
   end;
end;

Procedure tResults.HandleEvent(var Event:tEvent);

begin
 inherited HandleEvent(Event);
 if Event.What = evCommand then
 begin
  case Event.Command of
   cmResSave   : EndModal(cmResSave);
   cmCancel : EndModal(cmCancel);
  else
   exit;
  end;
 end;
end;

Procedure tResults.EndModal(Command:word);

begin
 ptxt^.Getdata(fname);
 Inherited EndModal(Command);
end;

Constructor tEditChem.Init;

var R    : TRect;
    hstr : string;
    xxx  : real;
    count : word;

begin
 R.assign(30,11,80,17);
 inherited init(R,'Edit Chemicals');
 Flags := wfmove;
 R.assign(7,1,48,2);
 name := new(pinputline,init(R,80));
 hstr := 'Chemical nr.0001';
 name^.Setdata(hstr);
 insert(name);
 R.assign(1,1,7,2);
 insert(new(plabel,init(R,'~N~ame',name)));

 R.assign(31,3,48,4);
 quant := new(pRealLine,init(R,20));
 quant^.SetReal(0,10,15);
 insert(quant);
 R.assign(1,3,27,4);
 insert(new(pLabel,init(R,'~Q~uantity(mol)',quant)));

 R.assign(31,4,48,5);
 vconst := new(pRealLine,init(R,20));
 vconst^.SetReal(0,10,15);
 insert(vconst);
 R.assign(1,4,27,5);
 insert(new(pLabel,init(R,'Equilibrium ~K~onstant, Kv',vconst)));

 Selectnext(false);
end;

Procedure tEditChem.HandleEvent(var Event:tEvent);

begin
 inherited HandleEvent(Event);
 if Event.What = evBroadCast then
  if Event.Command = cmDefault then
   if vconst^.GetState(sfFocused) then
   begin
    pchem^.Focus;
    ClearEvent(Event);
   end
   else
   begin
    if GetState(sfFocused) then
    begin
     Selectnext(False);
     ClearEvent(Event);
    end;
   end;
end;

Procedure tEditChem.ShowData(Item:pChemRec);

begin
 Name^.SetData(Item^.Name);
 if Item^.Mol = -12.34567890 then
  Quant^.SetData(Item^.SMol)
 else
  Quant^.SetReal(Item^.Mol,10,15);
 if Item^.Kv = -12.34567890 then
  VConst^.SetData(Item^.SKv)
 else
  VConst^.SetReal(Item^.Kv,10,15);

 Redraw;
end;

Destructor tChemList.Done;

begin
 pChemStr^.Seek(0);
 pChemCol^.Store(pChemStr^);
 pChemStr^.Truncate;
 inherited Done;
end;

Constructor tChemList.Init(var Bounds: tRect;AScrollBar:pScrollBar);

begin
 inherited Init(Bounds,1,nil,AScrollBar);
 pChemCol := new(pChemCollection,init);
 pChemStr := new(pDOSStream,init('CHEMICAL.DAT',stOpen));
 if pChemStr^.Status <> stOk then
 begin
  if pChemStr^.Errorinfo = 2 then
  begin
   pChemStr^.Reset;
   dispose(pChemStr,done);
   pChemStr := new(pDOSStream,init('CHEMICAL.DAT',stCreate));
  end
  else
  begin
   messagebox(^C'Can''t Build or Create Chemical List.',nil,mfOkButton+mfError);
   pChemStr^.Reset;
  end;
 end
 else
  pChemCol^.Load(pChemStr^);
 FirstTime := true;
end;

Procedure tChemList.AddChem;

var pChem : pChemRec;
    txt  : string;
    NrInList : word;
    Whereto : integer;

begin
 NrInList := pChemCol^.Count;
 if NrInList < 10000 then
 begin
  {Veld Schoonmaken}
  GetMem(pChem,SizeOf(ChemLabel));
  pChem^.mol := 0; pChem^.SMol := '';
  pChem^.Kv := 0; pChem^.SKv := '';
  pChem^.tr := 0;

  {Toevoegen aan lijst}
  str(NrInList+1,txt);
  if NrInList+1 < 10 then
   pChem^.name := 'Chemical nr.000'+txt
  else
   if NrInList+1 < 100 then
    pChem^.name := 'Chemical nr.00'+txt
   else
    if NrInList+1 <1000 then
     pChem^.name := 'Chemical nr.0'+txt
    else
     pChem^.name := 'Chemical nr.'+txt;
  pChemCol^.Insert(pChem);
 end
 else
  messagebox(^C'Can''t make more chemicals',nil,mfError+mfOkbutton);
 Redraw;
 if pChemCol^.Search(pChem,WhereTo) then
  FocusItem(Whereto);
end;

Procedure tChemList.Redraw;

var CollectionLength : integer;

begin
 CollectionLength := pChemCol^.Count;
 SetRange(CollectionLength);
 DrawView;
end;

Function tChemList.GetText(Item:Integer;MaxLen:Integer):String;

var txt : string;

begin
 txt := pChemRec(pChemCol^.At(Item))^.Name;
 if length(txt) > MaxLen then
  txt := Copy(txt,1,MaxLen);
 GetText := txt;
end;

Procedure tChemList.SelectItem(Item:Integer);

begin
 inherited SelectItem(Item);
 pEdit^.Focus;
end;

Procedure tChemList.FocusItem(Item:Integer);

var ppoint : pCHemRec;

begin
 inherited FocusItem(Item);
 ppoint := pChemCol^.At(Item);
 pEdit^.ShowData(ppoint);
end;

Procedure tChemList.SetState(AState:word;Enable:Boolean);

var CurSel,NextSel : integer;
    pChemical : pChemRec;

begin
 inherited SetState(AState,Enable);
 if (AState = sfActive) and (Enable = true) then
 begin
  if FirstTime then
   FirstTime := False
  else
  begin
   CurSel := Focused;
   GetMem(pChemical,SizeOf(ChemLabel));
   pEdit^.GetData2(pChemical);
   if pList^.Range > 0 then
   begin
    FreeMem(pChemCol^.At(CurSel),SizeOf(ChemLabel));
    pChemCol^.AtDelete(CurSel);
    pCHemCol^.Insert(pChemical);
    pList^.DrawView;
    if pChemCol^.Search(pChemical,NextSel) then
     FocusItem(NextSel);
    ChemChanged := true;
   end;
  end;
 end;
end;

Function tChemList.CheckAndCalcRt:boolean;

var counting : integer;

begin
 NrOfChem := 0;
 with pChemCol^ do
 begin
  for counting :=  0 to Range-1 do
  begin
   if pChemRec(At(Counting))^.Mol = -12.34567890 then
   begin
    messagebox(^C'Invalid "Quantity" in '+pChemRec(At(Counting))^.Name+'.',nil,mfError+mfOkButton);
    FocusItem(counting);
    pEdit^.Focus;
    pEdit^.Quant^.Focus;
    CheckAndCalcRt := false;
    exit;
   end;
   if pChemRec(At(Counting))^.Kv = -12.34567890 then
   begin
    messagebox(^C'Invalid "Equilibrium Constant" in '+pChemRec(At(Counting))^.Name+'.',nil,mfError+mfOkButton);
    FocusItem(counting);
    PEdit^.Focus;
    pEdit^.VConst^.Focus;
    CheckAndCalcRt := false;
    exit;
   end;
   pChemRec(At(Counting))^.tr := (kollengte/snelh)*(1+pChemRec(At(Counting))^.Kv*verh);
   if pChemRec(At(COunting))^.Mol > 0 then
    NrOfChem := NrOfChem +1;
  end;
 end;
 CheckAndCalcRt := true;
end;

Procedure tEditChem.GetData2(var Item:pChemRec);

var error : integer;

begin
 Name^.GetData(Item^.Name);
 Quant^.GetData(Item^.SMol);
 Val(Item^.SMol,Item^.Mol,error);
 if error <> 0 then
  Item^.Mol := -12.34567890;
 VConst^.GetData(Item^.SKv);
 Val(Item^.SKv,Item^.Kv,error);
 if error <> 0 then
  Item^.Kv := -12.34567890;
end;

var tprog2 : tprog;

begin
 tprog2.init;
 tprog2.run;
 tprog2.done;
end.