Version 1.00
BEGIN Form frmGasVariables
	AutoRedraw   = 0
	BackColor    = QBColor(7)
	BorderStyle  = 1
	Caption      = "Gas Variables"
	ControlBox   = -1
	Enabled      = -1
	ForeColor    = QBColor(0)
	Height       = Char(9)
	Left         = Char(9)
	MaxButton    = 0
	MinButton    = 0
	MousePointer = 0
	Tag          = ""
	Top          = Char(5)
	Visible      = 0
	Width        = Char(64)
	WindowState  = 0
	BEGIN CommandButton cmdCancel
		BackColor    = QBColor(7)
		Cancel       = -1
		Caption      = "&Cancel"
		Default      = 0
		DragMode     = 0
		Enabled      = -1
		Height       = Char(3)
		Left         = Char(50)
		MousePointer = 0
		TabIndex     = 6
		TabStop      = -1
		Tag          = ""
		Top          = Char(4)
		Visible      = -1
		Width        = Char(10)
	END
	BEGIN Label lblLine
		Alignment    = 2
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = " =  = "
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Left         = Char(29)
		MousePointer = 0
		TabIndex     = 7
		Tag          = ""
		Top          = Char(4)
		Visible      = -1
		Width        = Char(17)
	END
	BEGIN Label lblTop
		Alignment    = 2
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = "nRT"
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Left         = Char(29)
		MousePointer = 0
		TabIndex     = 8
		Tag          = ""
		Top          = Char(3)
		Visible      = -1
		Width        = Char(17)
	END
	BEGIN Label lblBottom
		Alignment    = 2
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = "PV"
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Left         = Char(29)
		MousePointer = 0
		TabIndex     = 9
		Tag          = ""
		Top          = Char(5)
		Visible      = -1
		Width        = Char(17)
	END
	BEGIN Label lblIdealGas
		Alignment    = 2
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = "Use the ideal gas law when three variables are known."
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(3)
		Left         = Char(28)
		MousePointer = 0
		TabIndex     = 10
		Tag          = ""
		Top          = Char(4)
		Visible      = 0
		Width        = Char(20)
	END
	BEGIN Label lblInstruct
		Alignment    = 0
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = "Select 2 properties that change as the gas goes from state 1 to state 2."
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(2)
		Left         = Char(1)
		MousePointer = 0
		TabIndex     = 0
		Tag          = ""
		Top          = Char(0)
		Visible      = -1
		Width        = Char(60)
	END
	BEGIN CheckBox chkProperty
		BackColor    = QBColor(7)
		Caption      = "&pressure constant"
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 0
		Left         = Char(1)
		MousePointer = 0
		TabIndex     = 1
		TabStop      = -1
		Tag          = ""
		Top          = Char(3)
		Value        = 0
		Visible      = -1
		Width        = Char(21)
	END
	BEGIN CheckBox chkProperty
		BackColor    = QBColor(7)
		Caption      = "&temperature constant"
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 1
		Left         = Char(1)
		MousePointer = 0
		TabIndex     = 2
		TabStop      = -1
		Tag          = ""
		Top          = Char(4)
		Value        = 0
		Visible      = -1
		Width        = Char(24)
	END
	BEGIN CheckBox chkProperty
		BackColor    = QBColor(7)
		Caption      = "&volume constant"
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 2
		Left         = Char(1)
		MousePointer = 0
		TabIndex     = 3
		TabStop      = -1
		Tag          = ""
		Top          = Char(5)
		Value        = 0
		Visible      = -1
		Width        = Char(19)
	END
	BEGIN CheckBox chkProperty
		BackColor    = QBColor(7)
		Caption      = "&moles constant"
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 3
		Left         = Char(1)
		MousePointer = 0
		TabIndex     = 4
		TabStop      = -1
		Tag          = ""
		Top          = Char(6)
		Value        = 0
		Visible      = -1
		Width        = Char(18)
	END
	BEGIN CommandButton cmdDone
		BackColor    = QBColor(7)
		Cancel       = 0
		Caption      = "&Done"
		Default      = -1
		DragMode     = 0
		Enabled      = -1
		Height       = Char(3)
		Left         = Char(50)
		MousePointer = 0
		TabIndex     = 5
		TabStop      = -1
		Tag          = "2"
		Top          = Char(1)
		Visible      = -1
		Width        = Char(10)
	END
END
' Updated:  October, 1996 by Christopher King
'
' ------------------------------------------------------------------------
'               Copyright (C) 1996 by Christopher King
'
' You have a royalty-free right to use, modify, reproduce and distribute
' the OneOhOne Files (and/or any modified version) in any way you find
' useful, provided that you agree that Christopher King has no warranty,
' obligations or liability for any OneOhOne Files.
' ------------------------------------------------------------------------
DECLARE SUB FormPositionClear (BYVAL nvGroup%)
'$FORM frmGas
'$FORM frmMdi
DEFINT A-Z
OPTION EXPLICIT
'$INCLUDE: 'common.bi'

DIM SHARED mnNumberChecked    ' Set in chkProperty_Click
DIM SHARED nGasEquation

'  The Done button can be pressed only if
'  2 variables are selected.  Displays formula on this form.
'
SUB chkProperty_Click (Index AS INTEGER)
' If 0, 1 or all 4 properties are checked, then
' disable the done button.
DIM N

IF chkProperty(Index).Value = 1 THEN
   chkProperty(Index).Caption = LEFT$(chkProperty(Index).Caption, LEN(chkProperty(Index).Caption) - 8)
ELSE
   chkProperty(Index).Caption = chkProperty(Index).Caption + "constant"
END IF

mnNumberChecked = 0
FOR N = 0 TO 3
   IF chkProperty(N).Value = 1 THEN
      mnNumberChecked = mnNumberChecked + 1
   END IF
NEXT N

IF mnNumberChecked = 3 THEN
   cmdDone.Enabled = FALSE
   lblIdealGas.Visible = TRUE
   lblTop.Caption = "PV = nRT"
   lblLine.Caption = ""
   lblBottom.Caption = ""
ELSEIF mnNumberChecked = 4 THEN
   cmdDone.Enabled = FALSE
   lblIdealGas.Visible = FALSE
      lblTop.Caption = "P2V2       P1V1"
     lblLine.Caption = " = R = "
   lblBottom.Caption = "n2T2       n1T1"
ELSEIF mnNumberChecked < 2 THEN
   cmdDone.Enabled = FALSE
   lblIdealGas.Visible = FALSE
      lblTop.Caption = ""
     lblLine.Caption = ""
   lblBottom.Caption = ""
ELSE     ' 2 checked.
   cmdDone.Enabled = TRUE
   lblIdealGas.Visible = FALSE
   IF chkProperty(0).Value = 1 THEN
      IF chkProperty(1).Value = 1 THEN       ' Pressure & temperature
         nGasEquation = 1
            lblTop.Caption = "P2   nR   P1"
           lblLine.Caption = " =  = "
         lblBottom.Caption = "T2   V    T1"
      ELSEIF chkProperty(2).Value = 1 THEN   ' Pressure & volume
         nGasEquation = 2
            lblTop.Caption = "P2V2 = nRT = P1V1"
           lblLine.Caption = ""
         lblBottom.Caption = ""
      ELSE                                   ' Pressure & moles
         nGasEquation = 3
            lblTop.Caption = "P2   RT   P1"
           lblLine.Caption = " =  = "
         lblBottom.Caption = "n2   V    n1"
      END IF
   ELSEIF chkProperty(1).Value = 1 THEN
      IF chkProperty(2).Value = 1 THEN       ' Temperature & volume
         nGasEquation = 4
            lblTop.Caption = "V2   nR   V1"
           lblLine.Caption = " =  = "
         lblBottom.Caption = "T2   P    T1"
      ELSE                                   ' Temperature & moles
         nGasEquation = 5
            lblTop.Caption = "1     R     1 "
           lblLine.Caption = " =  = "
         lblBottom.Caption = "n2T2   PV   n1T1"
      END IF
   ELSE                                      ' Volume & moles
         nGasEquation = 6
         lblTop.Caption = "V2   RT   V1"
        lblLine.Caption = " =  = "
      lblBottom.Caption = "n2   P    n1"
   END IF
END IF

END SUB

SUB cmdCancel_Click ()
UNLOAD frmGasVariables
END SUB

SUB cmdDone_Click ()

' If same variables chosen as when form loaded, do nothing.
IF nGasEquation <> VAL(frmGas.cmdVariables.Tag) THEN
   frmGas.cmdVariables.Tag = STR$(nGasEquation)

END IF

UNLOAD frmGasVariables
END SUB

DEFSNG A-Z
SUB Form_Load ()
' Check the variables presently used.
IF frmGas.txtVariable(27).Visible THEN ' Pressure
   chkProperty(0).Value = 1
END IF
IF frmGas.txtVariable(32).Visible THEN ' Temperature
   chkProperty(1).Value = 1
END IF
IF frmGas.txtVariable(29).Visible THEN ' Volume
   chkProperty(2).Value = 1
END IF
IF frmGas.txtVariable(30).Visible THEN ' moles
   chkProperty(3).Value = 1
END IF

' Position the form so the gas form is visible.
IF frmGas.Top < Screen.Height - (frmGas.Top + frmGas.Height - 1) THEN
   ' Place form below frmGas.
   IF frmGas.Top + frmGas.Height + 11 > Screen.Height THEN
      Top = Screen.Height - 11
   ELSE
      Top = frmGas.Top + frmGas.Height
   END IF
ELSE
   ' Place form above frmGas.
   IF frmGas.Top < 10 THEN
      Top = 0
   ELSE
      Top = frmGas.Top - 10
   END IF
END IF
END SUB

