(*--------------------------------------------------------------------------*)
(*                 DisplayInt  -- Display integer value                     *)
(*--------------------------------------------------------------------------*)

PROCEDURE DisplayInt( i, b : INTEGER );

(*--------------------------------------------------------------------------*)
(*                                                                          *)
(*     Procedure:  DisplayInt                                               *)
(*                                                                          *)
(*     Purpose:    Displays integer using specified base.                   *)
(*                                                                          *)
(*     Calling Sequence:                                                    *)
(*                                                                          *)
(*        DisplayInt( i , b : INTEGER );                                    *)
(*                                                                          *)
(*           i   --- the integer to be displayed                            *)
(*           b   --- the base to be used in conversion                      *)
(*                                                                          *)
(*     Calls:  none                                                         *)
(*                                                                          *)
(*--------------------------------------------------------------------------*)

VAR
   buf  : ARRAY [1..20] OF CHAR;
   j    : INTEGER;
   sign : CHAR;
   dig  : INTEGER;

BEGIN (* DisplayInt *)
                                   (* Remember sign of number *)
   sign := ' ';

   IF i < 0 THEN
      BEGIN
         sign := '-';
         i    := -i
      END;

   j := 0;
                                   (* Get display form of number,  *)
                                   (* one digit at a time.         *)
   WHILE i > 0 DO
      BEGIN
         j   := j + 1;
         dig := i MOD b;
         i   := i DIV b;
         IF dig < 10 THEN
            buf[j] := CHR( dig + ORD('0') )
         ELSE
            buf[j] := CHR( dig - 10 + ORD('A') )
      END;

                                    (* Ensure hard zero is output as '0' *)
   IF j = 0 THEN
      BEGIN
         buf[1] := '0';
         j := 1;
      END;
                                    (* Display the converted digits and sign *)
   WRITE(' ':19-j,sign);

   FOR j := j DOWNTO 1 DO WRITE(buf[j]);

END   (* DisplayInt *);

(*--------------------------------------------------------------------------*)
(*                    Display  -- Display value of variable                 *)
(*--------------------------------------------------------------------------*)

PROCEDURE Display( lab: CHAR; VAR v: valuety );

(*--------------------------------------------------------------------------*)
(*                                                                          *)
(*     Procedure:  Display                                                  *)
(*                                                                          *)
(*     Purpose:    Displays value of variable.                              *)
(*                                                                          *)
(*     Calling Sequence:                                                    *)
(*                                                                          *)
(*        Display( lab: CHAR; VAR v: valuety );                             *)
(*                                                                          *)
(*           lab --- the variable to be displayed                           *)
(*           v   --- the record containing the value of the variable        *)
(*                                                                          *)
(*     Calls:                                                               *)
(*                                                                          *)
(*        DisplayInt                                                        *)
(*        ABS                                                               *)
(*        Log10                                                             *)
(*                                                                          *)
(*--------------------------------------------------------------------------*)

BEGIN  (* Display *)

                                   (* Write name of variable *)
   WRITE(lab,' ');

                                   (* Check variable type *)
   WITH v DO

      CASE typ OF
                                   (* Display integer in dec, oct, hex *)
         int: BEGIN
                 DisplayInt( i , 10 );
                 DisplayInt( i ,  8 );
                 WRITE('B');
                 DisplayInt( i , 16 );
                 WRITELN('X');
              END;

                                   (* Display real in fractional, expon. *)
         rea: IF r <> 0.0 THEN
                 BEGIN
                    IF Log10( ABS ( r ) ) < ( 18 - FRAC ) THEN
                       WRITE(r:20:FRAC,'  ');
                    WRITELN(r:20);
                 END
              ELSE
                 WRITELN(0:20);

      END  (* CASE *);

END  (* Display *);
