
' MiPG: A Fuel Consumption Number Converter, V. 2.0
' by: Don Scott <swamp@edmc.net>
' written in QBasic
' Oct., 2000

COLOR 15, 9  'default screen color

1 CLS
LOCATE 2, 25
PRINT "MIPG: A FUEL CONSUMPTION CALCULATOR "
LOCATE 4
PRINT TAB(20); "ͻ"
PRINT TAB(20); "   ENTER             FOR                    "
PRINT TAB(20); "͹  "
PRINT TAB(20); "     1     RAW DATA INPUT                   "
PRINT TAB(20); "     2     liters/100 km. to mpg (both)     "
PRINT TAB(20); "     3     mpg (imperial) to l./100 km.     "
PRINT TAB(20); "     4     mpg (u.s.) to l./100 km.         "
PRINT TAB(20); "     5     mpg (imp.) to mpg (u.s.)         "
PRINT TAB(20); "     6     mpg (u.s.) to mpg (imp.)         "
PRINT TAB(20); "     7     km. to miles                     "
PRINT TAB(20); "     8     miles to km.                     "
PRINT TAB(20); "     9     more conversions                 "
PRINT TAB(20); "     10    reference                        "
PRINT TAB(20); "     11    change screen colors             "
PRINT TAB(20); "     12    SIMPLE CALCULATOR                "
PRINT TAB(20); "     13    EXIT                             "
PRINT TAB(20); "ͼ  "
PRINT TAB(33); "(choose from above)"
PRINT ""
LOCATE , 35
INPUT ; "selection"; n$
PRINT "                                                          "

10 IF n$ = "1" THEN
GOTO 120

ELSEIF n$ = "2" THEN
CLS
LOCATE 5, 32
INPUT ; "(input) liters/100 km."; f
IF f = 0 THEN
GOTO 1
END IF
g = (100 / f) * 2.835
h = (100 / f) * 2.352
PRINT "": PRINT ""
PRINT TAB(32); USING "mpg (imp.) =#####.##"; g
PRINT TAB(32); USING "mpg (u.s.) =#####.##"; h
PRINT "": PRINT ""
GOTO 80

20 ELSEIF n$ = "3" THEN
CLS
LOCATE 5, 32
INPUT ; "mpg (imp.) "; i
IF i = 0 THEN
GOTO 1
END IF
j = 282.5 / i
PRINT "": PRINT ""
PRINT TAB(32); USING "liters/100 km. =#####.##"; j
PRINT "": PRINT ""
GOTO 80

30 ELSEIF n$ = "4" THEN
CLS
LOCATE 5, 32
INPUT ; "mpg (u.s.)"; k
IF k = 0 THEN
GOTO 1
END IF
l = 235.2 / k
PRINT "": PRINT ""
PRINT TAB(32); USING "liters/100 km. =#####.##"; l
PRINT "": PRINT ""
GOTO 80

40 ELSEIF n$ = "5" THEN
CLS
LOCATE 5, 32
INPUT ; "mpg (imp.)"; m
IF m = 0 THEN
GOTO 1
END IF
n = m * .83
PRINT "": PRINT ""
PRINT TAB(32); USING "mpg (u.s.) =#####.##"; n
PRINT "": PRINT ""
GOTO 80

50 ELSEIF n$ = "6" THEN
CLS
LOCATE 5, 32
INPUT ; "mpg (u.s.)"; o
IF o = 0 THEN
GOTO 1
END IF
p = o * 1.2
PRINT "": PRINT ""
PRINT TAB(32); USING "mpg (imp.) =#####.##"; p;
PRINT "": PRINT ""
GOTO 80

60 ELSEIF n$ = "7" THEN
CLS
LOCATE 5, 32
INPUT ; "km."; q
IF q = 0 THEN
GOTO 1
END IF
r = q * .6213
PRINT "": PRINT ""
PRINT TAB(32); USING "miles =#####.##"; r
PRINT "": PRINT ""
GOTO 80

70 ELSEIF n$ = "8" THEN
CLS
LOCATE 5, 32
INPUT ; "miles"; s
IF s = 0 THEN
GOTO 1
END IF
t = s * 1.6093
PRINT "": PRINT ""
PRINT TAB(32); USING "km. =#####.##"; t
PRINT "": PRINT ""
GOTO 80

ELSEIF n$ = "9" THEN
GOTO 90

ELSEIF n$ = "10" THEN
GOTO 100

ELSEIF n$ = "11" THEN
GOTO 110

ELSEIF n$ = "12" THEN
GOTO 170

ELSEIF n$ = "13" THEN
GOTO 75

ELSE
GOTO 1
END IF

75 PRINT ""
PRINT TAB(35); "FARE THEE WELL!!"
END

80
PRINT "": PRINT "": PRINT ""
LOCATE , 29
PRINT "Ŀ"
LOCATE , 29
PRINT " press < for main menu "
LOCATE , 29
INPUT "  ", o$
PRINT ""
IF o$ = "x" THEN
GOTO 1
ELSE
GOTO 1
END IF

90 CLS
LOCATE 2
PRINT TAB(22); "Distance and Fluid Measure Conversions"
LOCATE 4
PRINT "         1 km.= .621 mi.                  1 gal. (imp.)= 4.546 l.            "
PRINT "              = .540 n.mi.                             = 1.21 gal. (u.s.)    "
PRINT ""
PRINT "         1 mi.= 1.609 km.                 1 gal. (u.s.)= .833 gal. (imp.)    "
PRINT "              = .869 n.mi.                             = 3.785 l.            "
PRINT ""
PRINT "         1 n.mi.= 1.852 km.               1 l.= .220 gal., .880 qt. (imp.)   "
PRINT "                = 1.151 mi.                   = .264 gal., 1.057 qt. (u.s.)  "
PRINT ""
PRINT "         n.mi.= nautical mile"
PRINT "": PRINT ""
INPUT ; "                     e.g. 44 (km.)         Quantity"; u
PRINT ""
INPUT ; "                     e.g. .540 (to n.m.)   Conv. Factor"; v
PRINT ""
w = u * v
PRINT USING "                     e.g. 23.76            Product =#####.##"; w
PRINT ""
LOCATE , 11
PRINT "press 1 < for another, or any other key < for main menu"
PRINT ""
INPUT "                                     selection"; p$
IF p$ = "1" THEN
GOTO 90
ELSE GOTO 1
END IF

100 CLS
PRINT ""
PRINT "   Definitions of Distance and Fluid Measures, Etc. ͻ "
PRINT "                                                                            "
PRINT "     1 light year=9.46070*10^15 meters           1 liter=1,000 ml.          "
PRINT "                 =5.87848*10^12 mi.                     =.264 u.s. gal.     "
PRINT "                 =.3066  parsecs                        =.220 imp. gal.     "
PRINT "     1 astronomical unit=149,501,201 km.                                    "
PRINT "                        =92,900,000 mi.          1 gallon=32 gills          "
PRINT "     12 inches=1 foot (ft.)                     (u.s. or =8 pints           "
PRINT "     3 feet=1 yard (yd.)                           imp.) =4 quarts          "
PRINT "     5.5 yards (yd.)=1 rod (rd.)                                            "
PRINT "     40 rods=1 furlong (fur.), 660 ft.           1 cm.=.3937 in.            "
PRINT "     8 furlongs=1 mile (mi.), 5280 ft.           1 mm.=.0394 in             "
PRINT "     1 league=3 mi., 5,280 yd.                   1 in.=2.54 cm.             "
PRINT "     1 meter (m.)=39.27 in.                                                 "
PRINT "     1 kilometer (km.)=1,000 meters (m.)         1 kilogram (kg.)=2.20 lb.  "
PRINT "     1 fathom=6 ft.                              1 lb.=.45 kg.              "
PRINT "     1 cable=100 fathoms                              =450 gm.              "
PRINT "     1 nautical mile (n.mi)=10 cables                 =16 ounces (oz.)      "
PRINT "                           =1.1515 mi.                                      "
PRINT "                           =1 degree             1 chug=7 slugs             "
PRINT "                           =6,000 ft.                  =49 sips             "
PRINT "                                                                            "
INPUT "   press any key < to return to menu ͼ ", q$
IF q$ = "{" THEN
GOTO 1
ELSE GOTO 1
END IF

110 CLS
LOCATE 4
PRINT TAB(20); "ͻ  "
PRINT TAB(20); "   ENTER              FOR                   "
PRINT TAB(20); "͹"
PRINT TAB(20); "     1           white on black             "
PRINT TAB(20); "     2           green on black             "
PRINT TAB(20); "     3           cyan on black              "
PRINT TAB(20); "     4           black on cyan              "
PRINT TAB(20); "     5           grey on black              "
PRINT TAB(20); "     6           flameout                   "
PRINT TAB(20); "     7           barf city                  "
PRINT TAB(20); "     8           default                    "
PRINT TAB(20); "     9           MAIN MENU                  "
PRINT TAB(20); "ͼ  "
PRINT ""
LOCATE , 32
INPUT ; "enter color number"; r$
IF r$ = "1" THEN
COLOR 15, 0
GOTO 1
ELSEIF r$ = "2" THEN
COLOR 10, 0
GOTO 1
ELSEIF r$ = "3" THEN
COLOR 11, 0
GOTO 1
ELSEIF r$ = "4" THEN
COLOR 0, 11
GOTO 1
ELSEIF r$ = "5" THEN
COLOR 7, 0
GOTO 1
ELSEIF r$ = "6" THEN
COLOR 4, 14
GOTO 1
ELSEIF r$ = "7" THEN
COLOR 10, 13
GOTO 1
ELSEIF r$ = "8" THEN
COLOR 15, 9
GOTO 1
ELSEIF r$ = "9" THEN
GOTO 1
ELSE
GOTO 1
END IF

120 CLS
LOCATE 4
PRINT TAB(20); "ͻ  "
PRINT TAB(20); "   ENTER              FOR                   "
PRINT TAB(20); "͹"
PRINT TAB(20); "     1      liters and kilometers           "
PRINT TAB(20); "     2      kilometers and u.s. gallons     "
PRINT TAB(20); "     3      u.s. gallons and miles          "
PRINT TAB(20); "     4      miles and liters                "
PRINT TAB(20); "     5      MAIN MENU                       "
PRINT TAB(20); "ͼ  "
PRINT ""
LOCATE , 31
INPUT ; "select calculation"; x$

125 IF x$ = "1" THEN
GOTO 130
ELSEIF x$ = "2" THEN
GOTO 140
ELSEIF x$ = "3" THEN
GOTO 150
ELSEIF x$ = "4" THEN
GOTO 160
ELSEIF x$ = "5" THEN
GOTO 1
ELSE
GOTO 1
END IF

130 CLS
LOCATE 5, 29
INPUT ; "(input) liters"; y
IF y = 0 THEN
GOTO 120
END IF
PRINT ""
LOCATE , 29
INPUT ; "(input) kilometers"; z
IF z = 0 THEN
GOTO 120
END IF
PRINT ""
LOCATE , 29
INPUT ; "(input) total cost"; h
PRINT "": PRINT ""
A = 100 / (z / y)
b = z / y
c = b * 2.82
d = b * 2.35
e = h / z
f = h / (z * .62)
PRINT TAB(29); USING "liters per 100 km. =#####.##"; A
PRINT TAB(29); USING "kilometers per liter =#####.##"; b
PRINT TAB(29); USING "mpg (imperial) =#####.##"; c
PRINT TAB(29); USING "mpg (u.s.) =#####.##"; d
PRINT TAB(29); USING "cost per km. =#####.##"; e
PRINT TAB(29); USING "cost per mi. =#####.##"; f

135 PRINT "": PRINT "": PRINT ""
LOCATE , 17
PRINT "Ŀ"
LOCATE , 17
PRINT " press 1 < for another, or < for main menu "
LOCATE , 17
PRINT ""
PRINT ""
LOCATE , 36
INPUT "selection"; pp$
IF pp$ = "1" THEN
GOTO 120
ELSEIF pp$ = "2" THEN
ELSE GOTO 1
END IF

140 CLS
LOCATE 5, 29
INPUT ; "(input) u.s. gallons"; y
IF y = 0 THEN
GOTO 120
END IF
PRINT ""
LOCATE , 29
INPUT ; "(input) kilometers"; z
IF z = 0 THEN
GOTO 120
END IF
PRINT ""
LOCATE , 29
INPUT ; "(input) total cost"; h
PRINT "": PRINT ""
A = 100 / (z / (y * 3.785))
b = z / (y * 3.785)
c = (z * .621) / (y * .833)
d = (z * .621) / y
e = h / z
f = h / (z * .62)
PRINT TAB(29); USING "liters per 100 km. =#####.##"; A
PRINT TAB(29); USING "kilometers per liter =#####.##"; b
PRINT TAB(29); USING "mpg (imperial) =#####.##"; c
PRINT TAB(29); USING "mpg (u.s.) =#####.##"; d
PRINT TAB(29); USING "cost per km. =#####.##"; e
PRINT TAB(29); USING "cost per mi. =#####.##"; f
GOTO 135

150 CLS
LOCATE 5, 29
INPUT ; "(input) u.s. gallons"; y
IF y = 0 THEN
GOTO 120
END IF
PRINT ""
LOCATE , 29
INPUT ; "(input) miles"; z
IF z = 0 THEN
GOTO 120
END IF
PRINT ""
LOCATE , 29
INPUT ; "(input) total cost"; h
PRINT "": PRINT "": PRINT ""
A = 100 / (z * 1.609 / (y * 3.785))
b = (z * 1.609) / (y * 3.785)
c = z / (y * .833)
d = z / y
e = h / (z * 1.62)
f = h / z
PRINT TAB(29); USING "liters per 100 km. =#####.##"; A
PRINT TAB(29); USING "kilometers per liter =#####.##"; b
PRINT TAB(29); USING "mpg (imperial) =#####.##"; c
PRINT TAB(29); USING "mpg (u.s.) =#####.##"; d
PRINT TAB(29); USING "cost per km. =#####.##"; e
PRINT TAB(29); USING "cost per mi. =#####.##"; f
GOTO 135

160 CLS
LOCATE 5, 29
INPUT ; "(input) liters"; y
IF y = 0 THEN
GOTO 120
END IF
PRINT ""
LOCATE , 29
INPUT ; "(input) miles"; z
IF z = 0 THEN
GOTO 120
END IF
PRINT ""
LOCATE , 29
INPUT ; "(input) total cost"; h
PRINT "": PRINT "": PRINT ""
A = 100 / ((z * 1.609) / y)
b = (z * 1.609) / y
c = z / (y * .22)
d = z / (y * .264)
e = h / (z * 1.62)
f = h / z
PRINT TAB(29); USING "liters per 100 km. =#####.##"; A
PRINT TAB(29); USING "kilometers per liter =#####.##"; b
PRINT TAB(29); USING "mpg (imperial) =#####.##"; c
PRINT TAB(29); USING "mpg (u.s.) =#####.##"; d
PRINT TAB(29); USING "cost per km. =#####.##"; e
PRINT TAB(29); USING "cost per mi. =#####.##"; f
GOTO 135

170
DIM total AS DOUBLE
DIM number AS DOUBLE
DIM secondNumber AS DOUBLE
DIM more AS STRING
DIM moreNumbers AS STRING
DIM operation AS STRING

total = 0
more = "y"
moreNumbers = "c"

CLS
WHILE more = "y"
        INPUT "Enter the first number"; number
        total = number
        WHILE moreNumbers = "c"
                PRINT "The total is:"; total
                PRINT "Select an operation"
                PRINT "(+)"
                PRINT "(-)"
                PRINT "(x)"
                PRINT "(/)"
                PRINT ""
                INPUT "choose"; operation
                CLS
                IF operation = "+" THEN
                        PRINT "Enter the number to Add to"; total
                        INPUT secondNumber
                        total = secondNumber + total
                        PRINT "The total is now:"; total
                ELSE
                        IF operation = "-" THEN
                                PRINT "Enter the number to Subtract from"; total
                                INPUT secondNumber
                                total = total - secondNumber
                                PRINT "The total is now:"; total
                        ELSE
                                IF operation = "x" THEN
                                        PRINT "Enter the number to Multiply"; total; "by"
                                        INPUT secondNumber
                                        total = secondNumber * total
                                        PRINT "The total is now:"; total
                 
                                ELSE
                                        IF operation = "/" THEN
                                                PRINT "Enter the number to Divide"; total; "by"
                                                INPUT secondNumber
                                                IF secondNumber = 0 THEN
                                                        PRINT "You cannot divide by zero"
                                                ELSE
                                                        total = total / secondNumber
                                                END IF
                                                PRINT "The total is now:"; total
                                        ELSE
                                                PRINT "you must select an operation"
                                        END IF
                                END IF
                        END IF
                END IF

                INPUT "Do you wish to continue (c), start with new numbers (n), or quit (n)"; moreNumbers
        CLS
        WEND
        PRINT "The grand total is:"; total
        INPUT "Do you wish to make more calculations (y or n)"; more
        moreNumbers = "c"
        total = 0
WEND
GOTO 1















